/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.http.BasicHttpFetcher;
import org.apache.shindig.gadgets.http.EchoServer;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.easymock.EasyMock;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BasicHttpFetcherTest {
    private static final int ECHO_PORT = 9003;
    protected static final Uri BASE_URL = Uri.parse((String)"http://localhost:9003/");
    private static EchoServer server;
    protected BasicHttpFetcher fetcher = null;
    protected HttpEntity mockEntity;
    protected InputStream mockInputStream;

    @BeforeClass
    public static void setUpOnce() throws Exception {
        server = new EchoServer();
        server.start(9003);
    }

    @AfterClass
    public static void tearDownOnce() throws Exception {
        if (server != null) {
            server.stop();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fetcher = new BasicHttpFetcher(BASE_URL.getAuthority());
        this.mockInputStream = (InputStream)EasyMock.createMock(InputStream.class);
        EasyMock.expect((Object)this.mockInputStream.available()).andReturn((Object)0);
        this.mockInputStream.close();
        this.mockEntity = (HttpEntity)EasyMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)this.mockEntity.getContent()).andReturn((Object)this.mockInputStream);
        EasyMock.expect((Object)this.mockEntity.getContentLength()).andReturn((Object)16384L).anyTimes();
    }

    @Test
    public void testWithProxy() throws Exception {
        String content = "Hello, Gagan!";
        Uri uri = new UriBuilder(Uri.parse((String)"http://www.google.com/search")).addQueryParameter("body", content).addQueryParameter("status", "201").toUri();
        HttpRequest request = new HttpRequest(uri);
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((long)201L, (long)response.getHttpStatusCode());
        Assert.assertEquals((Object)content, (Object)response.getResponseAsString());
    }

    @Test
    public void testToByteArraySafeThrowsException1() throws Exception {
        EasyMock.reset((Object[])new Object[]{this.mockInputStream});
        this.mockInputStream.close();
        String exceptionMessage = "IO Exception and Any Random Cause";
        IOException e = new IOException(exceptionMessage);
        EasyMock.expect((Object)this.mockInputStream.read((byte[])EasyMock.isA(byte[].class))).andThrow((Throwable)e).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockEntity, this.mockInputStream});
        boolean exceptionCaught = false;
        try {
            this.fetcher.toByteArraySafe(this.mockEntity);
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)exceptionMessage, (Object)ioe.getMessage());
            exceptionCaught = true;
        }
        Assert.assertTrue((boolean)exceptionCaught);
        EasyMock.verify((Object[])new Object[]{this.mockEntity, this.mockInputStream});
    }

    @Test
    public void testToByteArraySafeThrowsException2() throws Exception {
        String exceptionMessage = "EOF Exception and Any Random Cause";
        EOFException e = new EOFException(exceptionMessage);
        EasyMock.expect((Object)this.mockInputStream.read((byte[])EasyMock.isA(byte[].class))).andThrow((Throwable)e).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockEntity, this.mockInputStream});
        boolean exceptionCaught = false;
        try {
            this.fetcher.toByteArraySafe(this.mockEntity);
        }
        catch (EOFException eofe) {
            Assert.assertEquals((Object)exceptionMessage, (Object)eofe.getMessage());
            exceptionCaught = true;
        }
        Assert.assertTrue((boolean)exceptionCaught);
        EasyMock.verify((Object[])new Object[]{this.mockEntity, this.mockInputStream});
    }

    @Test
    public void testToByteArraySafeThrowsException3() throws Exception {
        EasyMock.reset((Object[])new Object[]{this.mockInputStream});
        this.mockInputStream.close();
        EasyMock.expect((Object)this.mockInputStream.available()).andReturn((Object)1);
        String exceptionMessage = "Unexpected end of ZLIB input stream";
        EOFException e = new EOFException(exceptionMessage);
        EasyMock.expect((Object)this.mockInputStream.read((byte[])EasyMock.isA(byte[].class))).andThrow((Throwable)e).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockEntity, this.mockInputStream});
        boolean exceptionCaught = false;
        try {
            this.fetcher.toByteArraySafe(this.mockEntity);
        }
        catch (EOFException eofe) {
            Assert.assertEquals((Object)exceptionMessage, (Object)eofe.getMessage());
            exceptionCaught = true;
        }
        EasyMock.verify((Object[])new Object[]{this.mockEntity, this.mockInputStream});
        Assert.assertTrue((boolean)exceptionCaught);
    }

    @Test
    public void testToByteArraySafeHandleException() throws Exception {
        String exceptionMessage = "Unexpected end of ZLIB input stream";
        EOFException e = new EOFException(exceptionMessage);
        EasyMock.expect((Object)this.mockInputStream.read((byte[])EasyMock.isA(byte[].class))).andThrow((Throwable)e).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockEntity, this.mockInputStream});
        try {
            this.fetcher.toByteArraySafe(this.mockEntity);
        }
        catch (EOFException eofe) {
            Assert.fail((String)"Exception Should have been caught");
        }
        EasyMock.verify((Object[])new Object[]{this.mockEntity, this.mockInputStream});
    }

    @Test
    public void testToByteArraySafeHandlesExceptionWithNoMessage() throws Exception {
        EOFException e = new EOFException();
        EasyMock.expect((Object)this.mockInputStream.read((byte[])EasyMock.isA(byte[].class))).andThrow((Throwable)e).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockEntity, this.mockInputStream});
        try {
            this.fetcher.toByteArraySafe(this.mockEntity);
        }
        catch (EOFException eofe) {
            Assert.fail((String)"Exception Should have been caught");
        }
        EasyMock.verify((Object[])new Object[]{this.mockEntity, this.mockInputStream});
    }

    @Test
    public void testHeadWithMaxObjectSizeBytes() throws Exception {
        this.fetcher.setMaxObjectSizeBytes(0x100000);
        Uri uri = new UriBuilder(Uri.parse((String)"http://www.google.com/search")).addQueryParameter("body", "").addQueryParameter("status", "200").toUri();
        HttpRequest request = new HttpRequest(uri);
        request.setMethod("HEAD");
        HttpResponse response = this.fetcher.fetch(request);
        Assert.assertEquals((long)200L, (long)response.getHttpStatusCode());
        Assert.assertEquals((Object)"", (Object)response.getResponseAsString());
    }
}

