/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.apache.shindig.gadgets.rewrite.XPathWrapper;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class HtmlParserTest
extends Assert {
    private final GadgetHtmlParser nekoParser = new NekoSimplifiedHtmlParser(new ParseModule.DOMImplementationProvider().get());

    @Test
    public void testParseSimpleString() throws Exception {
        this.parseSimpleString(this.nekoParser);
    }

    private void parseSimpleString(GadgetHtmlParser htmlParser) throws Exception {
        Document doc = htmlParser.parseDom("content");
        XPathWrapper wrapper = new XPathWrapper(doc);
        HtmlParserTest.assertEquals((Object)"content", (Object)wrapper.getValue("/html/body"));
    }

    @Test
    public void testParseTagWithStringContents() throws Exception {
        this.parseTagWithStringContents(this.nekoParser);
    }

    void parseTagWithStringContents(GadgetHtmlParser htmlParser) throws Exception {
        Document doc = htmlParser.parseDom("<span>content</span>");
        XPathWrapper wrapper = new XPathWrapper(doc);
        HtmlParserTest.assertEquals((Object)"content", (Object)wrapper.getValue("/html/body/span"));
    }

    @Test
    public void testParseTagWithAttributes() throws Exception {
        this.parseTagWithAttributes(this.nekoParser);
    }

    void parseTagWithAttributes(GadgetHtmlParser htmlParser) throws Exception {
        Document doc = htmlParser.parseDom("<div id=\"foo\">content</div>");
        XPathWrapper wrapper = new XPathWrapper(doc);
        HtmlParserTest.assertEquals((Object)"content", (Object)wrapper.getValue("/html/body/div"));
        HtmlParserTest.assertEquals((Object)"foo", (Object)wrapper.getValue("/html/body/div/@id"));
    }

    @Test
    public void testParseNestedContentWithNoCloseForBrAndHr() throws Exception {
        this.parseNestedContentWithNoCloseForBrAndHr(this.nekoParser);
    }

    void parseNestedContentWithNoCloseForBrAndHr(GadgetHtmlParser htmlParser) throws Exception {
        Document doc = htmlParser.parseDom("<div>x and y<br> and <hr>z</div>");
        XPathWrapper wrapper = new XPathWrapper(doc);
        HtmlParserTest.assertEquals((Object)"x and y and z", (Object)wrapper.getValue("/html/body/div"));
        HtmlParserTest.assertEquals((long)1L, (long)wrapper.getNodeList("/html/body/div/br").getLength());
        HtmlParserTest.assertEquals((long)1L, (long)wrapper.getNodeList("/html/body/div/hr").getLength());
    }
}

