/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.render.CajaResponseRewriter;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterTestBase;
import org.junit.Assert;
import org.junit.Test;

public class CajaResponseRewriterTest
extends RewriterTestBase {
    private static final Uri CONTENT_URI = Uri.parse((String)"http://www.example.org/content");

    private String rewrite(HttpRequest request, HttpResponse response) throws Exception {
        request.setSanitizationRequested(true);
        ResponseRewriter rewriter = this.createRewriter();
        HttpResponseBuilder hrb = new HttpResponseBuilder(this.parser, response);
        rewriter.rewrite(request, hrb);
        return hrb.getContent();
    }

    private ResponseRewriter createRewriter() {
        return new CajaResponseRewriter(new RequestPipeline(){

            public HttpResponse execute(HttpRequest request) {
                return null;
            }
        });
    }

    @Test
    public void testJs() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType("text/javascript");
        req.setCajaRequested(true);
        HttpResponse response = new HttpResponseBuilder().setResponseString("var a;").create();
        String sanitized = "$v.initOuter('a');";
        Assert.assertTrue((boolean)this.rewrite(req, response).contains(sanitized));
    }

    @Test
    public void testJsWithoutCaja() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType("text/javascript");
        req.setCajaRequested(false);
        HttpResponse response = new HttpResponseBuilder().setResponseString("var a;").create();
        String sanitized = "var a;";
        Assert.assertTrue((boolean)this.rewrite(req, response).contains(sanitized));
    }

    @Test
    public void testNonJs() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType("text/html");
        req.setCajaRequested(true);
        HttpResponse response = new HttpResponseBuilder().setResponseString("<html></html>").create();
        Assert.assertEquals((Object)"", (Object)this.rewrite(req, response));
    }
}

