/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.caja.CajaHtmlParser;
import org.apache.shindig.gadgets.rewrite.ContentTypeCharsetRemoverRewriter;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.DomWalkerTestBase;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContentTypeCharsetRemoverRewriterTest
extends DomWalkerTestBase {
    private CajaHtmlParser htmlParser;

    @Before
    public void setUp() {
        super.setUp();
        ParseModule.DOMImplementationProvider domImpl = new ParseModule.DOMImplementationProvider();
        this.htmlParser = new CajaHtmlParser(domImpl.get());
    }

    @Test
    public void testContentTypeCharsetRemoved() throws Exception {
        String html = "<html><head><META Content=\"hello world\" Http-equiv=\"Content-Title\"><META Content=\"text/html ; charset = 'GBK'\" Http-equiv=\"Content-TYPE\"><META Content=\"gzip\" Http-EQuIv=\"Content-Encoding\"></head><body><a href=\"hello\">Hello</a></body></html>";
        String expected = "<html><head><meta content=\"hello world\" http-equiv=\"Content-Title\"><meta content=\"text/html \" http-equiv=\"Content-TYPE\"><meta content=\"gzip\" http-equiv=\"Content-Encoding\"></head><body><a href=\"hello\">Hello</a>\n</body></html>";
        ContentTypeCharsetRemoverRewriter rewriter = new ContentTypeCharsetRemoverRewriter();
        Gadget gadget = DomWalker.makeGadget((HttpRequest)new HttpRequest(Uri.parse((String)"http://1.com/")));
        MutableContent mc = new MutableContent((GadgetHtmlParser)this.htmlParser, html);
        rewriter.rewrite(gadget, mc);
        Assert.assertEquals((Object)expected, (Object)mc.getContent());
    }

    @Test
    public void testNoMetaNode() throws Exception {
        String html = "<html><head><title>hello</title></head><body><a href=\"hello\">Hello</a></body></html>";
        String expected = "<html><head><title>hello</title></head><body><a href=\"hello\">Hello</a></body></html>";
        ContentTypeCharsetRemoverRewriter rewriter = new ContentTypeCharsetRemoverRewriter();
        Gadget gadget = DomWalker.makeGadget((HttpRequest)new HttpRequest(Uri.parse((String)"http://1.com/")));
        MutableContent mc = new MutableContent((GadgetHtmlParser)this.htmlParser, html);
        rewriter.rewrite(gadget, mc);
        Assert.assertEquals((Object)expected, (Object)mc.getContent());
    }

    @Test
    public void testMalformedCharset() throws Exception {
        String html = "<html><head><META Content=\"text/html ; pharset='hello'; hello=world\" Http-equiv=\"Content-TYPE\"></head><body><a href=\"hello\">Hello</a></body></html>";
        String expected = "<html><head><meta content=\"text/html ; pharset='hello'; hello=world\" http-equiv=\"Content-TYPE\"></head><body><a href=\"hello\">Hello</a>\n</body></html>";
        ContentTypeCharsetRemoverRewriter rewriter = new ContentTypeCharsetRemoverRewriter();
        Gadget gadget = DomWalker.makeGadget((HttpRequest)new HttpRequest(Uri.parse((String)"http://1.com/")));
        MutableContent mc = new MutableContent((GadgetHtmlParser)this.htmlParser, html);
        rewriter.rewrite(gadget, mc);
        Assert.assertEquals((Object)expected, (Object)mc.getContent());
        html = "<html><head><META Content=\"text/html ; charsett='hello'; hello=world\" Http-equiv=\"Content-TYPE\"></head><body><a href=\"hello\">Hello</a></body></html>";
        expected = "<html><head><meta content=\"text/html ; charsett='hello'; hello=world\" http-equiv=\"Content-TYPE\"></head><body><a href=\"hello\">Hello</a>\n</body></html>";
        mc = new MutableContent((GadgetHtmlParser)this.htmlParser, html);
        rewriter.rewrite(gadget, mc);
        Assert.assertEquals((Object)expected, (Object)mc.getContent());
    }
}

