/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.base.Charsets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class MutableContentTest {
    private MutableContent mhc;

    @Before
    public void setUp() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ParseModule(), new PropertiesModule()});
        this.mhc = new MutableContent((GadgetHtmlParser)injector.getInstance(GadgetHtmlParser.class), "DEFAULT VIEW");
    }

    @Test
    public void getContentAndParseTreeNoSets() throws Exception {
        String content = this.mhc.getContent();
        Assert.assertEquals((Object)"DEFAULT VIEW", (Object)content);
        Document document = this.mhc.getDocument();
        Assert.assertEquals((long)2L, (long)document.getFirstChild().getChildNodes().getLength());
        Assert.assertSame((Object)document.getFirstChild().getChildNodes().item(1).getFirstChild().getNodeType(), (Object)3);
        Assert.assertEquals((Object)content, (Object)document.getFirstChild().getChildNodes().item(1).getTextContent());
        Assert.assertSame((Object)content, (Object)this.mhc.getContent());
        Assert.assertTrue((boolean)Arrays.equals(content.getBytes("UTF8"), IOUtils.toByteArray((InputStream)this.mhc.getContentBytes())));
        Assert.assertSame((Object)document, (Object)this.mhc.getDocument());
        Assert.assertEquals((long)0L, (long)this.mhc.getNumChanges());
    }

    @Test
    public void modifyContentReflectedInTreeAndBytes() throws Exception {
        Assert.assertEquals((long)0L, (long)this.mhc.getNumChanges());
        this.mhc.setContent("NEW CONTENT");
        Assert.assertEquals((long)1L, (long)this.mhc.getNumChanges());
        Assert.assertEquals((Object)"NEW CONTENT", (Object)new String(IOUtils.toByteArray((InputStream)this.mhc.getContentBytes()), "UTF8"));
        Document document = this.mhc.getDocument();
        Assert.assertEquals((long)1L, (long)document.getChildNodes().getLength());
        Assert.assertEquals((Object)"NEW CONTENT", (Object)document.getChildNodes().item(0).getTextContent());
        this.mhc.documentChanged();
        Assert.assertEquals((long)2L, (long)this.mhc.getNumChanges());
    }

    @Test
    public void modifyContentReflectedInTreeUtf8() throws Exception {
        String theContent = "N\ufffdW C\ufffdNT\ufffdNT";
        Assert.assertEquals((long)0L, (long)this.mhc.getNumChanges());
        this.mhc.setContent(theContent);
        Assert.assertEquals((long)1L, (long)this.mhc.getNumChanges());
        Assert.assertEquals((Object)theContent, (Object)new String(IOUtils.toByteArray((InputStream)this.mhc.getContentBytes()), "UTF8"));
        Document document = this.mhc.getDocument();
        Assert.assertEquals((long)1L, (long)document.getChildNodes().getLength());
        Assert.assertEquals((Object)theContent, (Object)document.getChildNodes().item(0).getTextContent());
        this.mhc.documentChanged();
        Assert.assertEquals((long)2L, (long)this.mhc.getNumChanges());
    }

    @Test
    public void modifyBytesReflectedInContentAndTree() throws Exception {
        Assert.assertEquals((long)0L, (long)this.mhc.getNumChanges());
        this.mhc.setContentBytes("NEW CONTENT".getBytes("UTF8"), Charsets.UTF_8);
        Assert.assertEquals((long)1L, (long)this.mhc.getNumChanges());
        Document document = this.mhc.getDocument();
        Assert.assertEquals((long)1L, (long)document.getChildNodes().getLength());
        Assert.assertEquals((Object)"NEW CONTENT", (Object)document.getChildNodes().item(0).getTextContent());
        Assert.assertEquals((Object)"NEW CONTENT", (Object)this.mhc.getContent());
        Assert.assertEquals((long)1L, (long)this.mhc.getNumChanges());
        InputStream is = this.mhc.getContentBytes();
        Assert.assertEquals((Object)"NEW CONTENT", (Object)new String(IOUtils.toByteArray((InputStream)is), "UTF8"));
        Assert.assertEquals((long)1L, (long)this.mhc.getNumChanges());
    }

    @Test
    public void modifyTreeReflectedInContent() throws Exception {
        Document document = this.mhc.getDocument();
        document.getFirstChild().getFirstChild().setTextContent("FOO CONTENT");
        Assert.assertEquals((long)0L, (long)this.mhc.getNumChanges());
        MutableContent.notifyEdit((Document)document);
        Assert.assertEquals((long)1L, (long)this.mhc.getNumChanges());
        Assert.assertTrue((boolean)this.mhc.getContent().contains("FOO CONTENT"));
        document.getFirstChild().getFirstChild().setTextContent("BAR CONTENT");
        MutableContent.notifyEdit((Document)document);
        Assert.assertEquals((long)2L, (long)this.mhc.getNumChanges());
        Assert.assertTrue((boolean)this.mhc.getContent().contains("BAR CONTENT"));
        Assert.assertTrue((boolean)new String(IOUtils.toByteArray((InputStream)this.mhc.getContentBytes()), "UTF8").contains("BAR CONTENT"));
        Assert.assertSame((Object)document, (Object)this.mhc.getDocument());
    }
}

