/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.RewriterUtils;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.junit.Assert;
import org.junit.Test;

public class RewriterUtilsTest {
    @Test
    public void testIsHtmlWithoutHtmlTagContext() throws Exception {
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://www.example.org/"));
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeader("Content-Type", "text/html");
        Assert.assertTrue((boolean)RewriterUtils.isHtml((HttpRequest)req, (HttpResponseBuilder)builder));
    }

    @Test
    public void testIsHtmlReturnsFalseIfNonHtmlTagContext() throws Exception {
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://www.example.org/"));
        req.setParam(UriCommon.Param.HTML_TAG_CONTEXT.getKey(), (Object)"script");
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeader("Content-Type", "text/html");
        Assert.assertFalse((boolean)RewriterUtils.isHtml((HttpRequest)req, (HttpResponseBuilder)builder));
    }

    @Test
    public void testIsHtmlReturnsTrueIfHtmlAcceptingTagContext() throws Exception {
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://www.example.org/"));
        req.setParam(UriCommon.Param.HTML_TAG_CONTEXT.getKey(), (Object)"link");
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeader("Content-Type", "text/html");
        Assert.assertTrue((boolean)RewriterUtils.isHtml((HttpRequest)req, (HttpResponseBuilder)builder));
        req.setParam(UriCommon.Param.HTML_TAG_CONTEXT.getKey(), (Object)"iframe");
        Assert.assertTrue((boolean)RewriterUtils.isHtml((HttpRequest)req, (HttpResponseBuilder)builder));
    }
}

