/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.CssResponseRewriter;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.DomWalkerTestBase;
import org.apache.shindig.gadgets.rewrite.StyleTagExtractorVisitor;
import org.apache.shindig.gadgets.uri.PassthruManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleTagExtractorVisitorTest
extends DomWalkerTestBase {
    private ProxyUriManager proxyUriManager;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.proxyUriManager = new PassthruManager();
    }

    @Test
    public void visitBypassesComment() throws Exception {
        Comment comment = this.doc.createComment("comment");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(comment));
    }

    @Test
    public void visitBypassesText() throws Exception {
        Text text = this.doc.createTextNode("text");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(text));
    }

    @Test
    public void visitBypassesNonStyle() throws Exception {
        Element node = this.elem("div", new String[0]);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(node));
    }

    @Test
    public void visitBypassesStyleWhenRewriterOff() throws Exception {
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(this.config(false, true, true), this.elem("style", new String[0])));
    }

    @Test
    public void visitBypassesStyleWhenStyleTagNotIncluded() throws Exception {
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(this.config(true, false, true), this.elem("style", new String[0])));
    }

    @Test
    public void visitReservesStyleNode() throws Exception {
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatus(this.elem("style", new String[0])));
    }

    @Test
    public void visitReservesCasedStyleNode() throws Exception {
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatus(this.elem("sTyLE", new String[0])));
    }

    @Test
    public void revisitNothingExtracted() throws Exception {
        Gadget gadget = this.gadget();
        CssResponseRewriter cssRewriter = (CssResponseRewriter)EasyMock.createMock(CssResponseRewriter.class);
        EasyMock.replay((Object[])new Object[]{cssRewriter});
        ImmutableList nodes = ImmutableList.of();
        Node head = this.addNodesToHtml((List<Node>)nodes);
        Assert.assertFalse((boolean)this.getRevisitStatus(gadget, true, cssRewriter, (List<Node>)nodes));
        EasyMock.verify((Object[])new Object[]{cssRewriter});
        Assert.assertEquals((long)0L, (long)head.getChildNodes().getLength());
    }

    @Test
    public void revisitExtractSpecRelative() throws Exception {
        Uri base = GADGET_URI;
        Gadget gadget = this.gadget();
        CssResponseRewriter cssRewriter = (CssResponseRewriter)EasyMock.createMock(CssResponseRewriter.class);
        Element elem1 = this.elem("elem1", new String[0]);
        Element elem2 = this.elem("elem2", new String[0]);
        String urlStr1 = "http://foo.com/1.css";
        ImmutableList extractedUrls1 = ImmutableList.of((Object)urlStr1);
        String urlStr2 = "http://bar.com/1.css";
        ImmutableList extractedUrls2 = ImmutableList.of((Object)urlStr2);
        EasyMock.expect((Object)cssRewriter.rewrite((Element)EasyMock.eq((Object)elem1), (Uri)EasyMock.eq((Object)base), (CssResponseRewriter.UriMaker)EasyMock.isA(CssResponseRewriter.UriMaker.class), EasyMock.eq((boolean)true), (GadgetContext)EasyMock.eq((Object)gadget.getContext()))).andReturn((Object)extractedUrls1).once();
        EasyMock.expect((Object)cssRewriter.rewrite((Element)EasyMock.eq((Object)elem2), (Uri)EasyMock.eq((Object)base), (CssResponseRewriter.UriMaker)EasyMock.isA(CssResponseRewriter.UriMaker.class), EasyMock.eq((boolean)true), (GadgetContext)EasyMock.eq((Object)gadget.getContext()))).andReturn((Object)extractedUrls2).once();
        EasyMock.replay((Object[])new Object[]{cssRewriter});
        ImmutableList nodes = ImmutableList.of((Object)elem1, (Object)elem2);
        Node head = this.addNodesToHtml((List<Node>)nodes);
        Assert.assertTrue((boolean)this.getRevisitStatus(gadget, true, cssRewriter, (List<Node>)nodes));
        EasyMock.verify((Object[])new Object[]{cssRewriter});
        Assert.assertEquals((long)2L, (long)head.getChildNodes().getLength());
        Element child1 = (Element)head.getChildNodes().item(0);
        Assert.assertEquals((Object)"link", (Object)child1.getTagName());
        Assert.assertEquals((Object)"stylesheet", (Object)child1.getAttribute("rel"));
        Assert.assertEquals((Object)"text/css", (Object)child1.getAttribute("type"));
        Assert.assertEquals((Object)urlStr1, (Object)child1.getAttribute("href"));
        Element child2 = (Element)head.getChildNodes().item(1);
        Assert.assertEquals((Object)"link", (Object)child2.getTagName());
        Assert.assertEquals((Object)"stylesheet", (Object)child2.getAttribute("rel"));
        Assert.assertEquals((Object)"text/css", (Object)child2.getAttribute("type"));
        Assert.assertEquals((Object)urlStr2, (Object)child2.getAttribute("href"));
    }

    @Test
    public void revisitExtractViewHrefRelative() throws Exception {
        Uri base = Uri.parse((String)"http://view.com/viewbase.xml");
        Gadget gadget = this.gadget(true, true, base);
        CssResponseRewriter cssRewriter = (CssResponseRewriter)EasyMock.createMock(CssResponseRewriter.class);
        Element elem1 = this.elem("elem1", new String[0]);
        Element elem2 = this.elem("elem2", new String[0]);
        String urlStr1 = "http://foo.com/1.css";
        ImmutableList extractedUrls1 = ImmutableList.of((Object)urlStr1);
        String urlStr2 = "http://bar.com/1.css";
        ImmutableList extractedUrls2 = ImmutableList.of((Object)urlStr2);
        EasyMock.expect((Object)cssRewriter.rewrite((Element)EasyMock.eq((Object)elem1), (Uri)EasyMock.eq((Object)base), (CssResponseRewriter.UriMaker)EasyMock.isA(CssResponseRewriter.UriMaker.class), EasyMock.eq((boolean)true), (GadgetContext)EasyMock.eq((Object)gadget.getContext()))).andReturn((Object)extractedUrls1).once();
        EasyMock.expect((Object)cssRewriter.rewrite((Element)EasyMock.eq((Object)elem2), (Uri)EasyMock.eq((Object)base), (CssResponseRewriter.UriMaker)EasyMock.isA(CssResponseRewriter.UriMaker.class), EasyMock.eq((boolean)true), (GadgetContext)EasyMock.eq((Object)gadget.getContext()))).andReturn((Object)extractedUrls2).once();
        EasyMock.replay((Object[])new Object[]{cssRewriter});
        ImmutableList nodes = ImmutableList.of((Object)elem1, (Object)elem2);
        Node head = this.addNodesToHtml((List<Node>)nodes);
        Assert.assertTrue((boolean)this.getRevisitStatus(gadget, true, cssRewriter, (List<Node>)nodes));
        EasyMock.verify((Object[])new Object[]{cssRewriter});
        Assert.assertEquals((long)2L, (long)head.getChildNodes().getLength());
        Element child1 = (Element)head.getChildNodes().item(0);
        Assert.assertEquals((Object)"link", (Object)child1.getTagName());
        Assert.assertEquals((Object)"stylesheet", (Object)child1.getAttribute("rel"));
        Assert.assertEquals((Object)"text/css", (Object)child1.getAttribute("type"));
        Assert.assertEquals((Object)urlStr1, (Object)child1.getAttribute("href"));
        Element child2 = (Element)head.getChildNodes().item(1);
        Assert.assertEquals((Object)"link", (Object)child2.getTagName());
        Assert.assertEquals((Object)"stylesheet", (Object)child2.getAttribute("rel"));
        Assert.assertEquals((Object)"text/css", (Object)child2.getAttribute("type"));
        Assert.assertEquals((Object)urlStr2, (Object)child2.getAttribute("href"));
    }

    @Test
    public void revisitExtractSpecRelativeDisabled() throws Exception {
        Uri base = GADGET_URI;
        Gadget gadget = this.gadget();
        CssResponseRewriter cssRewriter = (CssResponseRewriter)EasyMock.createMock(CssResponseRewriter.class);
        Element elem1 = this.elem("elem1", new String[0]);
        Element elem2 = this.elem("elem2", new String[0]);
        ImmutableList extractedUrls1 = ImmutableList.of();
        ImmutableList extractedUrls2 = ImmutableList.of();
        EasyMock.expect((Object)cssRewriter.rewrite((Element)EasyMock.eq((Object)elem1), (Uri)EasyMock.eq((Object)base), (CssResponseRewriter.UriMaker)EasyMock.isA(CssResponseRewriter.UriMaker.class), EasyMock.eq((boolean)true), (GadgetContext)EasyMock.eq((Object)gadget.getContext()))).andReturn((Object)extractedUrls1).once();
        EasyMock.expect((Object)cssRewriter.rewrite((Element)EasyMock.eq((Object)elem2), (Uri)EasyMock.eq((Object)base), (CssResponseRewriter.UriMaker)EasyMock.isA(CssResponseRewriter.UriMaker.class), EasyMock.eq((boolean)true), (GadgetContext)EasyMock.eq((Object)gadget.getContext()))).andReturn((Object)extractedUrls2).once();
        EasyMock.replay((Object[])new Object[]{cssRewriter});
        ImmutableList nodes = ImmutableList.of((Object)elem1, (Object)elem2);
        Node head = this.addNodesToHtml((List<Node>)nodes);
        Assert.assertFalse((boolean)this.getRevisitStatus(gadget, false, cssRewriter, (List<Node>)nodes));
        EasyMock.verify((Object[])new Object[]{cssRewriter});
        Assert.assertEquals((long)0L, (long)head.getChildNodes().getLength());
    }

    private DomWalker.Visitor.VisitStatus getVisitStatus(Node node) throws Exception {
        return this.getVisitStatus(this.config(true, true, true), node);
    }

    private DomWalker.Visitor.VisitStatus getVisitStatus(ContentRewriterFeature.Config config, Node node) throws Exception {
        return new StyleTagExtractorVisitor(config, null, null).visit(null, node);
    }

    private boolean getRevisitStatus(Gadget gadget, boolean shouldRewriteUrl, CssResponseRewriter cssRewriter, List<Node> nodes) throws Exception {
        return new StyleTagExtractorVisitor(this.config(true, true, shouldRewriteUrl), cssRewriter, this.proxyUriManager).revisit(gadget, nodes);
    }

    private ContentRewriterFeature.Config config(boolean enabled, boolean styleInc, boolean rewriteUrl) {
        ContentRewriterFeature.Config config = (ContentRewriterFeature.Config)EasyMock.createMock(ContentRewriterFeature.Config.class);
        EasyMock.expect((Object)config.isRewriteEnabled()).andReturn((Object)enabled).anyTimes();
        EasyMock.expect((Object)config.getIncludedTags()).andReturn((Object)ImmutableSet.of((Object)(styleInc ? "style" : "foo"))).anyTimes();
        EasyMock.expect((Object)config.shouldRewriteURL((String)EasyMock.isA(String.class))).andReturn((Object)rewriteUrl).anyTimes();
        EasyMock.replay((Object[])new Object[]{config});
        return config;
    }

    private Node addNodesToHtml(List<Node> nodes) throws Exception {
        Element html = this.elem("html", new String[0]);
        Element head = this.elem("head", new String[0]);
        Element body = this.elem("body", new String[0]);
        html.appendChild(head);
        html.appendChild(body);
        for (Node node : nodes) {
            body.appendChild(node);
        }
        html.getOwnerDocument().appendChild(html);
        return head;
    }
}

