/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;

public class FakeProcessor
extends Processor {
    protected final Map<Uri, ProcessingException> exceptions = Maps.newHashMap();
    protected final Map<Uri, String> gadgets = Maps.newHashMap();
    public static final Uri SPEC_URL = Uri.parse((String)"http://example.org/g.xml");
    public static final Uri SPEC_URL2 = Uri.parse((String)"http://example.org/g2.xml");
    public static final String SPEC_TITLE = "JSON-TEST";
    public static final String SPEC_TITLE2 = "JSON-TEST2";
    public static final int PREFERRED_HEIGHT = 100;
    public static final int PREFERRED_WIDTH = 242;
    public static final String LINK_REL = "rel";
    public static final String LINK_HREF = "http://example.org/foo";
    public static final String SPEC_XML = "<Module><ModulePrefs title=\"JSON-TEST\">  <Link rel='rel' href='http://example.org/foo'/></ModulePrefs><UserPref name=\"up_one\">  <EnumValue value=\"val1\" display_value=\"disp1\"/>  <EnumValue value=\"abc\" display_value=\"disp2\"/>  <EnumValue value=\"z_xabc\" display_value=\"disp3\"/>  <EnumValue value=\"foo\" display_value=\"disp4\"/></UserPref><Content type=\"html\" preferred_height = \"100\" preferred_width = \"242\">Hello, world</Content></Module>";
    public static final String SPEC_XML2 = "<Module><ModulePrefs title=\"JSON-TEST2\"/><Content type=\"html\">Hello, world</Content></Module>";
    private final FeatureRegistry featureRegistry;

    public FakeProcessor() {
        this(null);
    }

    public FakeProcessor(FeatureRegistry featureRegistry) {
        super(null, null, null, null, null);
        this.gadgets.put(SPEC_URL, SPEC_XML);
        this.gadgets.put(SPEC_URL2, SPEC_XML2);
        this.featureRegistry = featureRegistry;
    }

    public Gadget process(GadgetContext context) throws ProcessingException {
        ProcessingException exception = this.exceptions.get(context.getUrl());
        if (exception != null) {
            throw exception;
        }
        try {
            GadgetSpec spec = new GadgetSpec(Uri.parse((String)"#"), this.gadgets.get(context.getUrl()));
            View view = spec.getView(context.getView());
            return new Gadget().setContext(context).setSpec(spec).setCurrentView(view).setGadgetFeatureRegistry(this.featureRegistry);
        }
        catch (GadgetException e) {
            throw new RuntimeException(e);
        }
    }
}

