/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.AbstractContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.CaptureRewriter;
import org.apache.shindig.gadgets.rewrite.DefaultResponseRewriterRegistry;
import org.apache.shindig.gadgets.servlet.AccelHandler;
import org.apache.shindig.gadgets.servlet.HtmlAccelServlet;
import org.apache.shindig.gadgets.servlet.ServletTestFixture;
import org.apache.shindig.gadgets.uri.AccelUriManager;
import org.apache.shindig.gadgets.uri.DefaultAccelUriManager;
import org.apache.shindig.gadgets.uri.DefaultProxyUriManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Before;
import org.junit.Test;

public class HtmlAccelServletTest
extends ServletTestFixture {
    private static final String REWRITE_CONTENT = "working rewrite";
    private static final String SERVLET = "/gadgets/accel";
    private HtmlAccelServlet servlet;

    @Before
    public void setUp() throws Exception {
        FakeContainerConfig config = new FakeContainerConfig();
        DefaultAccelUriManager accelUriManager = new DefaultAccelUriManager((ContainerConfig)config, (ProxyUriManager)new DefaultProxyUriManager((ContainerConfig)config, null));
        this.rewriter = new FakeCaptureRewriter();
        this.rewriterRegistry = new DefaultResponseRewriterRegistry(Arrays.asList(this.rewriter), null);
        this.servlet = new HtmlAccelServlet();
        this.servlet.setHandler(new AccelHandler(this.pipeline, this.rewriterRegistry, (AccelUriManager)accelUriManager, Boolean.valueOf(true)));
    }

    private void expectRequest(String extraPath, String url) {
        EasyMock.expect((Object)this.request.getMethod()).andReturn((Object)"GET").anyTimes();
        EasyMock.expect((Object)this.request.getServletPath()).andReturn((Object)SERVLET).anyTimes();
        EasyMock.expect((Object)this.request.getScheme()).andReturn((Object)"http").anyTimes();
        EasyMock.expect((Object)this.request.getServerName()).andReturn((Object)"apache.org").anyTimes();
        EasyMock.expect((Object)this.request.getServerPort()).andReturn((Object)-1).anyTimes();
        EasyMock.expect((Object)this.request.getRequestURI()).andReturn((Object)(SERVLET + extraPath)).anyTimes();
        EasyMock.expect((Object)this.request.getRequestURL()).andReturn((Object)new StringBuffer("apache.org/gadgets/accel" + extraPath)).anyTimes();
        String queryParams = url == null ? "" : "url=" + url + "&container=accel" + "&gadget=test";
        EasyMock.expect((Object)this.request.getQueryString()).andReturn((Object)queryParams).anyTimes();
        Vector headerNames = new Vector();
        EasyMock.expect((Object)this.request.getHeaderNames()).andReturn(headerNames.elements());
    }

    private void expectPostRequest(String extraPath, String url, final String data) throws IOException {
        EasyMock.expect((Object)this.request.getMethod()).andReturn((Object)"POST").anyTimes();
        EasyMock.expect((Object)this.request.getServletPath()).andReturn((Object)SERVLET).anyTimes();
        EasyMock.expect((Object)this.request.getScheme()).andReturn((Object)"http").anyTimes();
        EasyMock.expect((Object)this.request.getServerName()).andReturn((Object)"apache.org").anyTimes();
        EasyMock.expect((Object)this.request.getServerPort()).andReturn((Object)-1).anyTimes();
        EasyMock.expect((Object)this.request.getRequestURI()).andReturn((Object)(SERVLET + extraPath)).anyTimes();
        EasyMock.expect((Object)this.request.getRequestURL()).andReturn((Object)new StringBuffer("apache.org/gadgets/accel" + extraPath)).anyTimes();
        String queryParams = url == null ? "" : "url=" + url + "&container=accel" + "&gadget=test";
        EasyMock.expect((Object)this.request.getQueryString()).andReturn((Object)queryParams).anyTimes();
        ServletInputStream inputStream = (ServletInputStream)this.mock(ServletInputStream.class);
        EasyMock.expect((Object)this.request.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                byte[] byteArray = (byte[])EasyMock.getCurrentArguments()[0];
                System.arraycopy(data.getBytes(), 0, byteArray, 0, data.length());
                return data.length();
            }
        });
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andReturn((Object)-1);
        Vector headerNames = new Vector();
        EasyMock.expect((Object)this.request.getHeaderNames()).andReturn(headerNames.elements());
    }

    @Test
    public void testHtmlAccelNoData() throws Exception {
        String url = "http://example.org/data.html";
        HttpRequest req = new HttpRequest(Uri.parse((String)url));
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn(null).once();
        this.expectRequest("", url);
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        HtmlAccelServletTest.assertEquals((Object)"Error fetching data", (Object)this.recorder.getResponseAsString());
        HtmlAccelServletTest.assertEquals((long)404L, (long)this.recorder.getHttpStatusCode());
    }

    @Test
    public void testHtmlAccelRewriteSimple() throws Exception {
        String url = "http://example.org/data.html";
        String data = "<html><body>Hello World</body></html>";
        ((FakeCaptureRewriter)this.rewriter).setContentToRewrite(REWRITE_CONTENT);
        HttpRequest req = new HttpRequest(Uri.parse((String)url));
        HttpResponse resp = new HttpResponseBuilder().setResponse(data.getBytes()).setHeader("Content-Type", "text/html").setHttpStatusCode(200).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp).once();
        this.expectRequest("", url);
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        HtmlAccelServletTest.assertEquals((Object)REWRITE_CONTENT, (Object)this.recorder.getResponseAsString());
        HtmlAccelServletTest.assertEquals((long)200L, (long)this.recorder.getHttpStatusCode());
        HtmlAccelServletTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testHtmlAccelRewriteDoesNotFollowRedirects() throws Exception {
        String url = "http://example.org/data.html";
        String data = "<html><body>Moved to new page</body></html>";
        String redirectLocation = "http://example-redirected.org/data.html";
        ((FakeCaptureRewriter)this.rewriter).setContentToRewrite(data);
        HttpRequest req = new HttpRequest(Uri.parse((String)url));
        HttpResponse resp = new HttpResponseBuilder().setResponse(data.getBytes()).setHeader("Content-Type", "text/html").setHeader("Location", redirectLocation).setHttpStatusCode(302).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp).once();
        this.expectRequest("", url);
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        HtmlAccelServletTest.assertEquals((Object)data, (Object)this.recorder.getResponseAsString());
        HtmlAccelServletTest.assertEquals((Object)redirectLocation, (Object)this.recorder.getHeader("Location"));
        HtmlAccelServletTest.assertEquals((long)302L, (long)this.recorder.getHttpStatusCode());
        HtmlAccelServletTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testHtmlAccelReturnsOriginal404MessageAndCode() throws Exception {
        String url = "http://example.org/data.html";
        String data = "<html><body>This is error page</body></html>";
        ((FakeCaptureRewriter)this.rewriter).setContentToRewrite(REWRITE_CONTENT);
        HttpRequest req = new HttpRequest(Uri.parse((String)url));
        HttpResponse resp = new HttpResponseBuilder().setResponse(data.getBytes()).setHeader("Content-Type", "text/html").setHttpStatusCode(404).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp).once();
        this.expectRequest("", url);
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        HtmlAccelServletTest.assertEquals((Object)data, (Object)this.recorder.getResponseAsString());
        HtmlAccelServletTest.assertEquals((long)404L, (long)this.recorder.getHttpStatusCode());
        HtmlAccelServletTest.assertFalse((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testHtmlAccelRewriteInternalError() throws Exception {
        String url = "http://example.org/data.html";
        String data = "<html><body>This is error page</body></html>";
        ((FakeCaptureRewriter)this.rewriter).setContentToRewrite(data);
        HttpRequest req = new HttpRequest(Uri.parse((String)url));
        HttpResponse resp = new HttpResponseBuilder().setResponse(data.getBytes()).setHeader("Content-Type", "text/html").setHttpStatusCode(500).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp).once();
        this.expectRequest("", url);
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        HtmlAccelServletTest.assertEquals((Object)data, (Object)this.recorder.getResponseAsString());
        HtmlAccelServletTest.assertEquals((long)502L, (long)this.recorder.getHttpStatusCode());
        HtmlAccelServletTest.assertFalse((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testHtmlAccelHandlesPost() throws Exception {
        String url = "http://example.org/data.html";
        String data = "<html><body>This is error page</body></html>";
        ((FakeCaptureRewriter)this.rewriter).setContentToRewrite(data);
        Capture req = new Capture();
        HttpResponse resp = new HttpResponseBuilder().setResponse(data.getBytes()).setHeader("Content-Type", "text/html").create();
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.capture((Capture)req))).andReturn((Object)resp).once();
        this.expectPostRequest("", url, "hello=world");
        this.replay();
        this.servlet.doPost(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        HtmlAccelServletTest.assertEquals((Object)data, (Object)this.recorder.getResponseAsString());
        HtmlAccelServletTest.assertEquals((long)200L, (long)this.recorder.getHttpStatusCode());
        HtmlAccelServletTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
        HtmlAccelServletTest.assertEquals((Object)"POST", (Object)((HttpRequest)req.getValue()).getMethod());
        HtmlAccelServletTest.assertEquals((Object)"hello=world", (Object)((HttpRequest)req.getValue()).getPostBodyAsString());
    }

    @Test
    public void testHtmlAccelReturnsSameStatusCodeAndMessageWhenError() throws Exception {
        String url = "http://example.org/data.html";
        String data = "<html><body>This is error page</body></html>";
        ((FakeCaptureRewriter)this.rewriter).setContentToRewrite(data);
        HttpRequest req = new HttpRequest(Uri.parse((String)url));
        HttpResponse resp = new HttpResponseBuilder().setResponse(data.getBytes()).setHeader("Content-Type", "text/html").setHttpStatusCode(5001).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp).once();
        this.expectRequest("", url);
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        HtmlAccelServletTest.assertEquals((Object)data, (Object)this.recorder.getResponseAsString());
        HtmlAccelServletTest.assertEquals((long)5001L, (long)this.recorder.getHttpStatusCode());
        HtmlAccelServletTest.assertFalse((boolean)this.rewriter.responseWasRewritten());
    }

    private static class FakeCaptureRewriter
    extends CaptureRewriter {
        String contentToRewrite;

        private FakeCaptureRewriter() {
        }

        public void setContentToRewrite(String s) {
            this.contentToRewrite = s;
        }

        public void rewrite(HttpRequest request, HttpResponseBuilder original) {
            super.rewrite(request, original);
            if (!StringUtils.isEmpty((String)this.contentToRewrite)) {
                original.setResponse(this.contentToRewrite.getBytes());
            }
        }
    }

    private static class FakeContainerConfig
    extends AbstractContainerConfig {
        protected final Map<String, Object> data = ImmutableMap.builder().put((Object)"gadgets.uri.proxy.host", (Object)"apache.org").put((Object)"gadgets.uri.proxy.path", (Object)"/gadgets/accel").build();

        private FakeContainerConfig() {
        }

        public Object getProperty(String container, String name) {
            return this.data.get(name);
        }
    }
}

