/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import java.util.Locale;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.gadgets.servlet.HttpGadgetContext;
import org.apache.shindig.gadgets.servlet.ServletTestFixture;
import org.easymock.EasyMock;
import org.junit.Test;

public class HttpGadgetContextTest
extends ServletTestFixture {
    @Test
    public void testIgnoreCacheParam() {
        EasyMock.expect((Object)this.request.getParameter("nocache")).andReturn((Object)Integer.toString(Integer.MAX_VALUE));
        this.replay();
        HttpGadgetContext context = new HttpGadgetContext(this.request);
        HttpGadgetContextTest.assertTrue((boolean)context.getIgnoreCache());
    }

    @Test
    public void testLocale() {
        EasyMock.expect((Object)this.request.getParameter("lang")).andReturn((Object)Locale.CHINA.getLanguage());
        EasyMock.expect((Object)this.request.getParameter("country")).andReturn((Object)Locale.CHINA.getCountry());
        this.replay();
        HttpGadgetContext context = new HttpGadgetContext(this.request);
        HttpGadgetContextTest.assertEquals((Object)Locale.CHINA, (Object)context.getLocale());
    }

    @Test
    public void testDebug() {
        EasyMock.expect((Object)this.request.getParameter("debug")).andReturn((Object)"1");
        this.replay();
        HttpGadgetContext context = new HttpGadgetContext(this.request);
        HttpGadgetContextTest.assertTrue((boolean)context.getDebug());
    }

    @Test
    public void testGetParameter() {
        EasyMock.expect((Object)this.request.getParameter("foo")).andReturn((Object)"bar");
        this.replay();
        HttpGadgetContext context = new HttpGadgetContext(this.request);
        HttpGadgetContextTest.assertEquals((Object)"bar", (Object)context.getParameter("foo"));
    }

    @Test
    public void testGetHost() {
        EasyMock.expect((Object)this.request.getHeader("Host")).andReturn((Object)"foo.org");
        this.replay();
        HttpGadgetContext context = new HttpGadgetContext(this.request);
        HttpGadgetContextTest.assertEquals((Object)"foo.org", (Object)context.getHost());
    }

    @Test
    public void testGetUserIp() {
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)"2.3.4.5");
        this.replay();
        HttpGadgetContext context = new HttpGadgetContext(this.request);
        HttpGadgetContextTest.assertEquals((Object)"2.3.4.5", (Object)context.getUserIp());
    }

    @Test
    public void testGetSecurityToken() throws Exception {
        AnonymousSecurityToken expected = new AnonymousSecurityToken();
        EasyMock.expect((Object)this.request.getAttribute(AuthInfo.Attribute.SECURITY_TOKEN.getId())).andReturn((Object)expected);
        this.replay();
        HttpGadgetContext context = new HttpGadgetContext(this.request);
        HttpGadgetContextTest.assertEquals((Object)expected, (Object)context.getToken());
    }

    @Test
    public void testGetUserAgent() throws Exception {
        EasyMock.expect((Object)this.request.getHeader("User-Agent")).andReturn((Object)"Mozilla/4.0");
        this.replay();
        HttpGadgetContext context = new HttpGadgetContext(this.request);
        HttpGadgetContextTest.assertEquals((Object)"Mozilla/4.0", (Object)context.getUserAgent());
    }
}

