/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates.tags;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.templates.FakeTemplateProcessor;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.tags.RepeatTagHandler;
import org.apache.shindig.gadgets.templates.tags.TagHandler;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RepeatTagHandlerTest {
    private FakeTemplateProcessor processor;
    private DOMImplementation documentProvider;
    private TagHandler handler;

    @Before
    public void setUp() throws Exception {
        this.processor = (FakeTemplateProcessor)EasyMock.createMock(FakeTemplateProcessor.class);
        this.documentProvider = new ParseModule.DOMImplementationProvider().get();
        this.handler = new RepeatTagHandler();
    }

    @Test
    public void repeat() throws Exception {
        Document doc = this.documentProvider.createDocument(null, null, null);
        Element tag = doc.createElement("repeat");
        tag.setAttribute("expression", "fakeExpression");
        ImmutableList mockList = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        this.processor.expressionResults = ImmutableMap.of((Object)"fakeExpression", (Object)mockList);
        this.processor.processChildNodes(null, tag);
        EasyMock.expectLastCall().times(3);
        EasyMock.replay((Object[])new Object[]{this.processor});
        this.handler.process(null, tag, (TemplateProcessor)this.processor);
        EasyMock.verify((Object[])new Object[]{this.processor});
    }

    @Test
    public void repeatWithoutExpression() throws Exception {
        Document doc = this.documentProvider.createDocument(null, null, null);
        Element tag = doc.createElement("repeat");
        EasyMock.replay((Object[])new Object[]{this.processor});
        this.handler.process(null, tag, (TemplateProcessor)this.processor);
        EasyMock.verify((Object[])new Object[]{this.processor});
    }

    @Test
    public void repeatWithIf() throws Exception {
        Document doc = this.documentProvider.createDocument(null, null, null);
        Element tag = doc.createElement("repeat");
        tag.setAttribute("expression", "fakeExpression");
        tag.setAttribute("if", "fakeIf");
        ImmutableList mockList = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        this.processor.expressionResults = ImmutableMap.of((Object)"fakeExpression", (Object)mockList, (Object)"fakeIf", (Object)Lists.newArrayList((Object[])new Boolean[]{false, true, false}));
        this.processor.processChildNodes(null, tag);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.processor});
        this.handler.process(null, tag, (TemplateProcessor)this.processor);
        EasyMock.verify((Object[])new Object[]{this.processor});
    }
}

