/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates.tags;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Set;
import javax.el.ELResolver;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.expressions.RootELResolver;
import org.apache.shindig.gadgets.DefaultGuiceModule;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.oauth.OAuthModule;
import org.apache.shindig.gadgets.parse.DefaultHtmlSerializer;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.SocialDataTags;
import org.apache.shindig.gadgets.templates.TagRegistry;
import org.apache.shindig.gadgets.templates.TemplateContext;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.tags.DefaultTagRegistry;
import org.apache.shindig.gadgets.templates.tags.RepeatTagHandler;
import org.apache.shindig.gadgets.templates.tags.TemplateBasedTagHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateBasedTagHandlerTest {
    private TemplateContext context;
    private TemplateProcessor processor;
    private final ELResolver resolver = new RootELResolver();
    private GadgetHtmlParser parser;
    private static final String TEST_NS = "http://example.com";

    @Before
    public void setUp() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new DefaultGuiceModule(), new OAuthModule(), new PropertiesModule()});
        this.parser = (GadgetHtmlParser)injector.getInstance(GadgetHtmlParser.class);
        this.processor = (TemplateProcessor)injector.getInstance(TemplateProcessor.class);
        this.context = new TemplateContext(new Gadget(), null);
    }

    @Test
    public void attributeInMy() throws Exception {
        this.runTest("Bar", "${My.attr}", "<foo:Bar attr='Hello'/>", "Hello");
    }

    @Test
    public void elementContentInMy() throws Exception {
        this.runTest("Bar", "${My.element}", "<foo:Bar><foo:element>Hello</foo:element></foo:Bar>", "Hello");
    }

    @Test
    public void attrTakesPrecedenceInMy() throws Exception {
        this.runTest("Bar", "${My.attr}", "<foo:Bar attr='Hello'><foo:attr>Goodbye</foo:attr></foo:Bar>", "Hello");
    }

    @Test
    public void elementAttributeInMy() throws Exception {
        this.runTest("Bar", "${My.element.text}", "<foo:Bar><foo:element text='Hello'/></foo:Bar>", "Hello");
    }

    @Test
    public void descendantElementInMy() throws Exception {
        this.runTest("Bar", "${My.element.child}", "<foo:Bar><foo:element><foo:child>Hello</foo:child></foo:element></foo:Bar>", "Hello");
    }

    @Test
    public void descendantElementNotFoundIfNotFullReference() throws Exception {
        this.runTest("Bar", "${My.child}", "<foo:Bar><foo:element><foo:child>Hello</foo:child></foo:element></foo:Bar>", "");
    }

    @Test
    public void missingElementPropertyIsNull() throws Exception {
        this.runTest("Bar", "${My.element.foo == null}", "<foo:Bar><foo:element>Hello/foo:element></foo:Bar>", "true");
    }

    @Test
    @Ignore(value="This currently returns [Hello,Goodbye].  Check the spec, and consider changing the spec.")
    public void multipleElementContentInMy() throws Exception {
        this.runTest("Bar", "${My.element}", "<foo:Bar><foo:element>Hello</foo:element><foo:element>Goodbye</foo:element></foo:Bar>", "HelloGoodbye");
    }

    @Test
    public void elementListRepeat() throws Exception {
        this.runTest("Bar", "<os:Repeat expression='${My.element}'>${text}</os:Repeat>", "<foo:Bar><foo:element text='Hello'/><foo:element text='Goodbye'/></foo:Bar>", "HelloGoodbye");
    }

    @Test
    public void singleElementRepeat() throws Exception {
        this.runTest("Bar", "<os:Repeat expression='${My.element}'>${text}</os:Repeat>", "<foo:Bar><foo:element text='Hello'/></foo:Bar>", "Hello");
    }

    private void runTest(String tagName, String tagMarkup, String templateMarkup, String expectedResult) throws GadgetException, IOException {
        Element templateDef = this.parseTemplate(templateMarkup);
        Element tagInstance = this.parseTemplate(tagMarkup);
        templateDef.getOwnerDocument().adoptNode(tagInstance);
        TemplateBasedTagHandler tagHandler = new TemplateBasedTagHandler(tagInstance, TEST_NS, tagName);
        DefaultTagRegistry reg = new DefaultTagRegistry((Set)ImmutableSet.of((Object)tagHandler, (Object)new RepeatTagHandler()));
        DocumentFragment result = this.processor.processTemplate(templateDef, this.context, this.resolver, (TagRegistry)reg);
        String output = this.serialize(result);
        Assert.assertEquals((Object)expectedResult, (Object)output);
    }

    private Element parseTemplate(String markup) throws GadgetException {
        String content = "<script type=\"text/os-template\" xmlns:foo=\"http://example.com\" xmlns:os=\"http://ns.opensocial.org/2008/markup\">" + markup + "</script>";
        Document document = this.parser.parseDom(content);
        return (Element)SocialDataTags.getTags((Document)document, (String)"OSTemplate").get(0);
    }

    private String serialize(Node node) throws IOException {
        StringBuilder sb = new StringBuilder();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            new DefaultHtmlSerializer().serialize(child, (Appendable)sb);
        }
        return sb.toString();
    }
}

