/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.variables;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.render.FakeMessageBundleFactory;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.BidiSubstituter;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.junit.Assert;
import org.junit.Test;

public class BidiSubstituterTest
extends Assert {
    @Test
    public void testBidiWithRtl() throws Exception {
        this.assertRightToLeft("rtl");
    }

    @Test
    public void testBidiWithLtr() throws Exception {
        this.assertLeftToRight("ltr");
    }

    @Test(expected=SpecParserException.class)
    public void testBidiWithEmpty() throws Exception {
        this.assertLeftToRight("");
    }

    private void assertRightToLeft(String direction) throws Exception {
        this.assertSubstitutions(direction, "right", "left", "rtl", "ltr");
    }

    private void assertLeftToRight(String direction) throws Exception {
        this.assertSubstitutions(direction, "left", "right", "ltr", "rtl");
    }

    private void assertSubstitutions(String direction, String startEdge, String endEdge, String dir, String reverseDir) throws Exception {
        String xml = "<Module><ModulePrefs title=''>  <Locale language_direction='" + direction + "' />" + "</ModulePrefs>" + "<Content />" + "</Module>";
        GadgetSpec spec = new GadgetSpec(Uri.parse((String)"#"), xml);
        GadgetContext context = new GadgetContext();
        BidiSubstituter substituter = new BidiSubstituter((MessageBundleFactory)new FakeMessageBundleFactory());
        Substitutions substitutions = new Substitutions();
        substituter.addSubstitutions(substitutions, context, spec);
        BidiSubstituterTest.assertEquals((Object)startEdge, (Object)substitutions.getSubstitution(Substitutions.Type.BIDI, "START_EDGE"));
        BidiSubstituterTest.assertEquals((Object)endEdge, (Object)substitutions.getSubstitution(Substitutions.Type.BIDI, "END_EDGE"));
        BidiSubstituterTest.assertEquals((Object)dir, (Object)substitutions.getSubstitution(Substitutions.Type.BIDI, "DIR"));
        BidiSubstituterTest.assertEquals((Object)reverseDir, (Object)substitutions.getSubstitution(Substitutions.Type.BIDI, "REVERSE_DIR"));
    }
}

