/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.variables;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.render.FakeMessageBundleFactory;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.variables.MessageSubstituter;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.junit.Assert;
import org.junit.Test;

public class MessageSubstituterTest
extends Assert {
    private final FakeMessageBundleFactory messageBundleFactory = new FakeMessageBundleFactory();
    private final MessageSubstituter substituter = new MessageSubstituter((MessageBundleFactory)this.messageBundleFactory);
    private final GadgetContext context = new GadgetContext();

    @Test
    public void testMessageReplacements() throws Exception {
        String xml = "<Module> <ModulePrefs title=''>  <Locale>    <msg name='foo'>bar</msg>    <msg name='bar'>baz</msg>  </Locale> </ModulePrefs> <Content /></Module>";
        Substitutions substitutions = new Substitutions();
        this.substituter.addSubstitutions(substitutions, this.context, new GadgetSpec(Uri.parse((String)"#"), xml));
        MessageSubstituterTest.assertEquals((Object)"bar", (Object)substitutions.getSubstitution(Substitutions.Type.MESSAGE, "foo"));
        MessageSubstituterTest.assertEquals((Object)"baz", (Object)substitutions.getSubstitution(Substitutions.Type.MESSAGE, "bar"));
    }
}

