/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.FeatureParser;
import org.junit.Assert;
import org.junit.Test;

public class FeatureParserTest {
    @Test
    public void parseCompleteFeatureFile() throws Exception {
        Uri parent = Uri.parse((String)"scheme://host.com/root/path");
        String featureXml = "<feature>  <name>the_feature</name>  <dependency>myDep1</dependency>  <dependency>mySecondDep</dependency>  <gadget>    <ignored>This tag is ignored</ignored>    <script src=\"http://www.apache.org/file.js\"/>    <script src=\"relative/resource.js\" gadget_attrib=\"gadget_value\"/>  </gadget>  <gadget container=\"container1\">    <!-- No child values, testing outlier case -->  </gadget>  <container randomAttrib=\"randomValue\" secondAttrib=\"secondValue\">    <script src=\"/authority/relative.js\" r2_attr=\"r2_val\" r3_attr=\"r3_val\"></script>    <script>Inlined content</script>  </container>  <other_type>    <script src=\"http://www.apache.org/two.js\"/>    <script src=\"//extern/unchanged.dat\" inline=\"false\"/>  </other_type></feature>";
        FeatureParser.ParsedFeature parsed = new FeatureParser().parse(parent, featureXml);
        Assert.assertEquals((Object)"the_feature", (Object)parsed.getName());
        Assert.assertEquals((long)2L, (long)parsed.getDeps().size());
        Assert.assertEquals((Object)"myDep1", parsed.getDeps().get(0));
        Assert.assertEquals((Object)"mySecondDep", parsed.getDeps().get(1));
        Assert.assertEquals((long)4L, (long)parsed.getBundles().size());
        FeatureParser.ParsedFeature.Bundle bundle1 = (FeatureParser.ParsedFeature.Bundle)parsed.getBundles().get(0);
        Assert.assertEquals((Object)"gadget", (Object)bundle1.getType());
        Assert.assertEquals((long)0L, (long)bundle1.getAttribs().size());
        Assert.assertEquals((long)2L, (long)bundle1.getResources().size());
        Assert.assertNull((Object)((FeatureParser.ParsedFeature.Resource)bundle1.getResources().get(0)).getContent());
        Assert.assertEquals((Object)Uri.parse((String)"http://www.apache.org/file.js"), (Object)((FeatureParser.ParsedFeature.Resource)bundle1.getResources().get(0)).getSource());
        Assert.assertEquals((long)0L, (long)((FeatureParser.ParsedFeature.Resource)bundle1.getResources().get(0)).getAttribs().size());
        Assert.assertNull((Object)((FeatureParser.ParsedFeature.Resource)bundle1.getResources().get(1)).getContent());
        Assert.assertEquals((Object)Uri.parse((String)"scheme://host.com/root/relative/resource.js"), (Object)((FeatureParser.ParsedFeature.Resource)bundle1.getResources().get(1)).getSource());
        Assert.assertEquals((long)1L, (long)((FeatureParser.ParsedFeature.Resource)bundle1.getResources().get(1)).getAttribs().size());
        Assert.assertEquals((Object)"gadget_value", ((FeatureParser.ParsedFeature.Resource)bundle1.getResources().get(1)).getAttribs().get("gadget_attrib"));
        FeatureParser.ParsedFeature.Bundle bundle2 = (FeatureParser.ParsedFeature.Bundle)parsed.getBundles().get(1);
        Assert.assertEquals((Object)"gadget", (Object)bundle2.getType());
        Assert.assertEquals((long)1L, (long)bundle2.getAttribs().size());
        Assert.assertEquals((Object)"container1", bundle2.getAttribs().get("container"));
        Assert.assertEquals((long)0L, (long)bundle2.getResources().size());
        FeatureParser.ParsedFeature.Bundle bundle3 = (FeatureParser.ParsedFeature.Bundle)parsed.getBundles().get(2);
        Assert.assertEquals((Object)"container", (Object)bundle3.getType());
        Assert.assertEquals((long)2L, (long)bundle3.getAttribs().size());
        Assert.assertEquals((Object)"randomValue", bundle3.getAttribs().get("randomAttrib"));
        Assert.assertEquals((Object)"secondValue", bundle3.getAttribs().get("secondAttrib"));
        Assert.assertEquals((long)2L, (long)bundle3.getResources().size());
        Assert.assertNull((Object)((FeatureParser.ParsedFeature.Resource)bundle3.getResources().get(0)).getContent());
        Assert.assertEquals((Object)Uri.parse((String)"scheme://host.com/authority/relative.js"), (Object)((FeatureParser.ParsedFeature.Resource)bundle3.getResources().get(0)).getSource());
        Assert.assertEquals((long)2L, (long)((FeatureParser.ParsedFeature.Resource)bundle3.getResources().get(0)).getAttribs().size());
        Assert.assertEquals((Object)"r2_val", ((FeatureParser.ParsedFeature.Resource)bundle3.getResources().get(0)).getAttribs().get("r2_attr"));
        Assert.assertEquals((Object)"r3_val", ((FeatureParser.ParsedFeature.Resource)bundle3.getResources().get(0)).getAttribs().get("r3_attr"));
        Assert.assertNull((Object)((FeatureParser.ParsedFeature.Resource)bundle3.getResources().get(1)).getSource());
        Assert.assertEquals((Object)"Inlined content", (Object)((FeatureParser.ParsedFeature.Resource)bundle3.getResources().get(1)).getContent());
        Assert.assertEquals((long)0L, (long)((FeatureParser.ParsedFeature.Resource)bundle3.getResources().get(1)).getAttribs().size());
        FeatureParser.ParsedFeature.Bundle bundle4 = (FeatureParser.ParsedFeature.Bundle)parsed.getBundles().get(3);
        Assert.assertEquals((Object)"other_type", (Object)bundle4.getType());
        Assert.assertEquals((long)0L, (long)bundle4.getAttribs().size());
        Assert.assertEquals((long)2L, (long)bundle4.getResources().size());
        Assert.assertNull((Object)((FeatureParser.ParsedFeature.Resource)bundle4.getResources().get(0)).getContent());
        Assert.assertEquals((Object)Uri.parse((String)"http://www.apache.org/two.js"), (Object)((FeatureParser.ParsedFeature.Resource)bundle4.getResources().get(0)).getSource());
        Assert.assertNull((Object)((FeatureParser.ParsedFeature.Resource)bundle4.getResources().get(1)).getContent());
        Assert.assertEquals((Object)Uri.parse((String)"//extern/unchanged.dat"), (Object)((FeatureParser.ParsedFeature.Resource)bundle4.getResources().get(1)).getSource());
        Assert.assertEquals((long)0L, (long)((FeatureParser.ParsedFeature.Resource)bundle4.getResources().get(0)).getAttribs().size());
    }

    @Test(expected=GadgetException.class)
    public void parseInvalidXml() throws GadgetException {
        new FeatureParser().parse(Uri.parse((String)""), "This is not valid XML.");
    }
}

