/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.common.Pair;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.FakeTimeSource;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.features.FeatureResourceLoader;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureResourceLoaderTest {
    private static final String FILE_JS = "gadgets.test.pattern = function(){};";
    private static final String UPDATED_FILE_JS = "different.impl.completely = function(){};";
    private static final String UNCOMPRESSED_FILE_JS = "/** Some comments* /\ngadgets.test.pattern = function() {};";
    private static final String UPDATED_UNCOMPRESSED_FILE_JS = "/** Different comments* /\ndifferent.impl.completely = function() {};";
    private static final String URL_JS = "while(true){alert('hello');}";
    private TestFeatureResourceLoader loader;
    private FakeTimeSource timeSource;

    @Before
    public void setUp() {
        this.loader = new TestFeatureResourceLoader();
        this.timeSource = new FakeTimeSource();
        this.timeSource.setCurrentTimeMillis(0L);
        this.loader.setTimeSource((TimeSource)this.timeSource);
    }

    @Test
    public void loadFileOptOnlyAvailable() throws Exception {
        Pair<Uri, File> optUri = this.makeFile(".opt.js", FILE_JS);
        FeatureResource resource = this.loader.load((Uri)optUri.one, null);
        Assert.assertEquals((Object)FILE_JS, (Object)resource.getContent());
        Assert.assertEquals((Object)FILE_JS, (Object)resource.getDebugContent());
        Assert.assertFalse((boolean)resource.isExternal());
        Assert.assertTrue((boolean)resource.isProxyCacheable());
    }

    @Test
    public void loadFileDebugOnlyAvailable() throws Exception {
        Pair<Uri, File> dbgUri = this.makeFile(".js", UNCOMPRESSED_FILE_JS);
        FeatureResource resource = this.loader.load((Uri)dbgUri.one, null);
        Assert.assertEquals((Object)UNCOMPRESSED_FILE_JS, (Object)resource.getContent());
        Assert.assertEquals((Object)UNCOMPRESSED_FILE_JS, (Object)resource.getDebugContent());
        Assert.assertFalse((boolean)resource.isExternal());
        Assert.assertTrue((boolean)resource.isProxyCacheable());
    }

    @Test
    public void loadFileBothModesAvailable() throws Exception {
        Pair<Uri, File> optUri = this.makeFile(".opt.js", FILE_JS);
        File dbgFile = new File(((Uri)optUri.one).getPath().replace(".opt.js", ".js"));
        dbgFile.createNewFile();
        Pair<Uri, File> dbgUri = this.makeFile(dbgFile, UNCOMPRESSED_FILE_JS);
        FeatureResource resource = this.loader.load((Uri)dbgUri.one, null);
        Assert.assertEquals((Object)FILE_JS, (Object)resource.getContent());
        Assert.assertEquals((Object)UNCOMPRESSED_FILE_JS, (Object)resource.getDebugContent());
        Assert.assertFalse((boolean)resource.isExternal());
        Assert.assertTrue((boolean)resource.isProxyCacheable());
    }

    @Test(expected=IllegalArgumentException.class)
    public void loadFileNothingAvailable() throws Exception {
        Uri nilUri = new UriBuilder().setScheme("file").setPath("/does/not/exist.js").toUri();
        this.loader.load(nilUri, null);
        Assert.fail((String)("Should have failed indicating could not find: " + nilUri.toString()));
    }

    @Test
    public void loadFileNoOptPathCalculable() throws Exception {
        Pair<Uri, File> dbgUri = this.makeFile(".notjssuffix", UNCOMPRESSED_FILE_JS);
        FeatureResource resource = this.loader.load((Uri)dbgUri.one, null);
        Assert.assertEquals((Object)UNCOMPRESSED_FILE_JS, (Object)resource.getContent());
        Assert.assertEquals((Object)UNCOMPRESSED_FILE_JS, (Object)resource.getDebugContent());
        Assert.assertFalse((boolean)resource.isExternal());
        Assert.assertTrue((boolean)resource.isProxyCacheable());
    }

    @Test
    public void loadFileUpdateIgnoredIfUpdatesDisabled() throws Exception {
        Pair<Uri, File> optUri = this.makeFile(".opt.js", FILE_JS);
        FeatureResource resource = this.loader.load((Uri)optUri.one, null);
        Assert.assertEquals((Object)FILE_JS, (Object)resource.getContent());
        Assert.assertEquals((Object)FILE_JS, (Object)resource.getDebugContent());
        Assert.assertFalse((boolean)resource.isExternal());
        Assert.assertTrue((boolean)resource.isProxyCacheable());
        this.setFileContent((File)optUri.two, UPDATED_FILE_JS);
        this.timeSource.incrementSeconds(10);
        Assert.assertEquals((Object)FILE_JS, (Object)resource.getContent());
        Assert.assertEquals((Object)FILE_JS, (Object)resource.getDebugContent());
        Assert.assertFalse((boolean)resource.isExternal());
        Assert.assertTrue((boolean)resource.isProxyCacheable());
    }

    @Test
    public void loadFileUpdateBehavior() throws Exception {
        this.loader.setSupportFileUpdates(5000);
        Pair<Uri, File> optUri = this.makeFile(".opt.js", FILE_JS);
        File dbgFile = new File(((Uri)optUri.one).getPath().replace(".opt.js", ".js"));
        dbgFile.createNewFile();
        Pair<Uri, File> dbgUri = this.makeFile(dbgFile, UNCOMPRESSED_FILE_JS);
        FeatureResource resource = this.loader.load((Uri)dbgUri.one, null);
        Assert.assertEquals((Object)FILE_JS, (Object)resource.getContent());
        Assert.assertEquals((Object)UNCOMPRESSED_FILE_JS, (Object)resource.getDebugContent());
        Assert.assertFalse((boolean)resource.isExternal());
        Assert.assertTrue((boolean)resource.isProxyCacheable());
        this.setFileContent((File)optUri.two, UPDATED_FILE_JS);
        this.loader.forceFileChanged.put(((File)optUri.two).getAbsolutePath(), true);
        this.setFileContent((File)dbgUri.two, UPDATED_UNCOMPRESSED_FILE_JS);
        this.loader.forceFileChanged.put(((File)dbgUri.two).getAbsolutePath(), true);
        this.timeSource.incrementSeconds(4);
        Assert.assertEquals((Object)FILE_JS, (Object)resource.getContent());
        Assert.assertEquals((Object)UNCOMPRESSED_FILE_JS, (Object)resource.getDebugContent());
        Assert.assertFalse((boolean)resource.isExternal());
        Assert.assertTrue((boolean)resource.isProxyCacheable());
        this.timeSource.incrementSeconds(4);
        Assert.assertEquals((Object)UPDATED_FILE_JS, (Object)resource.getContent());
        Assert.assertEquals((Object)UPDATED_UNCOMPRESSED_FILE_JS, (Object)resource.getDebugContent());
        Assert.assertFalse((boolean)resource.isExternal());
        Assert.assertTrue((boolean)resource.isProxyCacheable());
    }

    @Test
    public void loadUriInline() throws Exception {
        Uri uri = Uri.parse((String)"http://apache.org/resource.js");
        HashMap attribs = Maps.newHashMap();
        attribs.put("inline", "true");
        HttpFetcher fetcher = this.mockFetcher(uri, URL_JS);
        this.loader.setHttpFetcher(fetcher);
        FeatureResource resource = this.loader.load(uri, attribs);
        Assert.assertEquals((Object)URL_JS, (Object)resource.getContent());
        Assert.assertEquals((Object)URL_JS, (Object)resource.getDebugContent());
        Assert.assertTrue((boolean)resource.isProxyCacheable());
        Assert.assertFalse((boolean)resource.isExternal());
    }

    @Test
    public void loadUriInlineNoFetcherSet() throws Exception {
        Uri uri = Uri.parse((String)"http://apache.org/resource.js");
        HashMap attribs = Maps.newHashMap();
        attribs.put("inline", "true");
        FeatureResource resource = this.loader.load(uri, attribs);
        Assert.assertNull((Object)resource.getContent());
        Assert.assertNull((Object)resource.getDebugContent());
        Assert.assertFalse((boolean)resource.isProxyCacheable());
        Assert.assertFalse((boolean)resource.isExternal());
    }

    @Test
    public void loadUriInlineFetcherFailure() throws Exception {
        Uri uri = Uri.parse((String)"http://apache.org/resource.js");
        HashMap attribs = Maps.newHashMap();
        attribs.put("inline", "true");
        HttpFetcher fetcher = (HttpFetcher)EasyMock.createMock(HttpFetcher.class);
        EasyMock.expect((Object)fetcher.fetch((HttpRequest)EasyMock.eq((Object)new HttpRequest(uri)))).andThrow((Throwable)new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT));
        EasyMock.replay((Object[])new Object[]{fetcher});
        this.loader.setHttpFetcher(fetcher);
        FeatureResource resource = this.loader.load(uri, attribs);
        Assert.assertNull((Object)resource.getContent());
        Assert.assertNull((Object)resource.getDebugContent());
        Assert.assertFalse((boolean)resource.isProxyCacheable());
        Assert.assertFalse((boolean)resource.isExternal());
    }

    @Test
    public void loadUriExtern() throws Exception {
        String theUrl = "http://apache.org/resource.js";
        Uri uri = Uri.parse((String)theUrl);
        HashMap attribs = Maps.newHashMap();
        HttpFetcher fetcher = this.mockFetcher(uri, URL_JS);
        this.loader.setHttpFetcher(fetcher);
        FeatureResource resource = this.loader.load(uri, attribs);
        Assert.assertEquals((Object)theUrl, (Object)resource.getContent());
        Assert.assertEquals((Object)theUrl, (Object)resource.getDebugContent());
        Assert.assertTrue((boolean)resource.isProxyCacheable());
        Assert.assertTrue((boolean)resource.isExternal());
    }

    private Pair<Uri, File> makeFile(String suffix, String content) throws Exception {
        File tmpFile = File.createTempFile("restmp", suffix);
        return this.makeFile(tmpFile, content);
    }

    private Pair<Uri, File> makeFile(File file, String content) throws Exception {
        file.deleteOnExit();
        this.setFileContent(file, content);
        return Pair.of((Object)new UriBuilder().setScheme("file").setPath(file.getPath()).toUri(), (Object)file);
    }

    private void setFileContent(File file, String content) throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write(content);
        out.close();
    }

    private HttpFetcher mockFetcher(Uri toFetch, String content) throws Exception {
        HttpFetcher fetcher = (HttpFetcher)EasyMock.createMock(HttpFetcher.class);
        HttpRequest req = new HttpRequest(toFetch);
        HttpResponse resp = new HttpResponseBuilder().setHttpStatusCode(200).setResponseString(content).create();
        EasyMock.expect((Object)fetcher.fetch((HttpRequest)EasyMock.eq((Object)req))).andReturn((Object)resp);
        EasyMock.replay((Object[])new Object[]{fetcher});
        return fetcher;
    }

    private static class TestFeatureResourceLoader
    extends FeatureResourceLoader {
        private Map<String, Boolean> forceFileChanged = Maps.newHashMap();

        private TestFeatureResourceLoader() {
        }

        protected boolean fileHasChanged(File file, long lastModified) {
            Boolean changeOverride = this.forceFileChanged.get(file.getAbsolutePath());
            return file.lastModified() > lastModified ? true : changeOverride != null && changeOverride != false;
        }
    }
}

