/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.auth.BasicSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.http.AbstractHttpCache;
import org.apache.shindig.gadgets.http.CacheKeyBuilder;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractHttpCacheTest {
    protected static final Uri DEFAULT_URI = Uri.parse((String)"http://example.org/file.txt");
    protected static final Uri IMAGE_URI = Uri.parse((String)"http://example.org/image.png");
    private static final Uri APP_URI = Uri.parse((String)"http://example.org/gadget.xml");
    private static final String MODULE_ID = "100";
    private static final String SERVICE_NAME = "service";
    private static final String TOKEN_NAME = "token";
    private static final String CONTAINER_NAME = "container";
    private final TestHttpCache cache = new TestHttpCache();

    @Test
    public void createKeySimple() {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setAuthType(AuthType.NONE);
        CacheKeyBuilder key = new CacheKeyBuilder().setLegacyParam(0, (Object)DEFAULT_URI).setLegacyParam(1, (Object)AuthType.NONE);
        Assert.assertEquals((Object)key.build(), (Object)this.cache.createKey(request));
    }

    private HttpRequest getMockImageRequest(String height, String width, String quality, String mimeType) {
        HttpRequest request = (HttpRequest)EasyMock.createMock(HttpRequest.class);
        EasyMock.expect((Object)request.getUri()).andReturn((Object)IMAGE_URI).anyTimes();
        EasyMock.expect((Object)request.getAuthType()).andReturn((Object)AuthType.NONE).anyTimes();
        EasyMock.expect((Object)request.getSecurityToken()).andReturn(null).anyTimes();
        EasyMock.expect((Object)request.getParam(UriCommon.Param.RESIZE_HEIGHT.getKey())).andReturn((Object)height).anyTimes();
        EasyMock.expect((Object)request.getParam(UriCommon.Param.RESIZE_WIDTH.getKey())).andReturn((Object)width).anyTimes();
        EasyMock.expect((Object)request.getParam(UriCommon.Param.RESIZE_QUALITY.getKey())).andReturn((Object)quality).anyTimes();
        EasyMock.expect((Object)request.getRewriteMimeType()).andReturn((Object)mimeType).anyTimes();
        EasyMock.replay((Object[])new Object[]{request});
        return request;
    }

    @Test
    public void createKeySimpleImageRequest() throws Exception {
        HttpRequest request = this.getMockImageRequest(MODULE_ID, "80", "70", null);
        CacheKeyBuilder key = new CacheKeyBuilder().setLegacyParam(0, (Object)IMAGE_URI).setLegacyParam(1, (Object)AuthType.NONE).setParam("rh", (Object)MODULE_ID).setParam("rw", (Object)"80").setParam("rq", (Object)"70");
        Assert.assertEquals((Object)key.build(), (Object)this.cache.createKey(request));
    }

    @Test
    public void createKeyImageRequestRewrite() throws Exception {
        HttpRequest request = this.getMockImageRequest(MODULE_ID, "80", "70", "image/jpg");
        CacheKeyBuilder key = new CacheKeyBuilder().setLegacyParam(0, (Object)IMAGE_URI).setLegacyParam(1, (Object)AuthType.NONE).setParam("rh", (Object)MODULE_ID).setParam("rw", (Object)"80").setParam("rq", (Object)"70").setParam("rm", (Object)"image/jpg");
        Assert.assertEquals((Object)key.build(), (Object)this.cache.createKey(request));
    }

    @Test
    public void createKeySignedOwner() throws Exception {
        RequestAuthenticationInfo authInfo = this.newMockAuthInfo(true, false, (Map<String, String>)ImmutableMap.of((Object)"OAUTH_SERVICE_NAME", (Object)SERVICE_NAME, (Object)"OAUTH_TOKEN_NAME", (Object)TOKEN_NAME));
        EasyMock.replay((Object[])new Object[]{authInfo});
        String ownerId = "owner eye dee";
        BasicSecurityToken securityToken = new BasicSecurityToken(ownerId, "", "", "", APP_URI.toString(), MODULE_ID, CONTAINER_NAME, null, null);
        HttpRequest request = new HttpRequest(DEFAULT_URI).setAuthType(AuthType.SIGNED).setOAuthArguments(new OAuthArguments(authInfo)).setSecurityToken((SecurityToken)securityToken);
        CacheKeyBuilder key = new CacheKeyBuilder().setLegacyParam(0, (Object)DEFAULT_URI).setLegacyParam(1, (Object)AuthType.SIGNED).setLegacyParam(2, (Object)ownerId).setLegacyParam(3, (Object)"").setLegacyParam(5, (Object)APP_URI).setLegacyParam(6, (Object)MODULE_ID).setLegacyParam(7, (Object)SERVICE_NAME).setLegacyParam(8, (Object)TOKEN_NAME);
        Assert.assertEquals((Object)key.build(), (Object)this.cache.createKey(request));
    }

    private RequestAuthenticationInfo newMockAuthInfo(boolean isSignOwner, boolean isSignViewer, Map<String, String> attributesMap) {
        RequestAuthenticationInfo authInfo = (RequestAuthenticationInfo)EasyMock.createNiceMock(RequestAuthenticationInfo.class);
        EasyMock.expect((Object)authInfo.getAttributes()).andReturn(attributesMap).anyTimes();
        EasyMock.expect((Object)authInfo.getAuthType()).andReturn((Object)AuthType.SIGNED).anyTimes();
        EasyMock.expect((Object)authInfo.getHref()).andReturn((Object)DEFAULT_URI).anyTimes();
        EasyMock.expect((Object)authInfo.isSignOwner()).andReturn((Object)isSignOwner).anyTimes();
        EasyMock.expect((Object)authInfo.isSignViewer()).andReturn((Object)isSignOwner).anyTimes();
        return authInfo;
    }

    @Test
    public void createKeySignedViewer() throws Exception {
        RequestAuthenticationInfo authInfo = this.newMockAuthInfo(false, true, (Map<String, String>)ImmutableMap.of((Object)"OAUTH_SERVICE_NAME", (Object)SERVICE_NAME, (Object)"OAUTH_TOKEN_NAME", (Object)TOKEN_NAME));
        EasyMock.replay((Object[])new Object[]{authInfo});
        String viewerId = "viewer eye dee";
        BasicSecurityToken securityToken = new BasicSecurityToken("", viewerId, "", "", APP_URI.toString(), MODULE_ID, CONTAINER_NAME, null, null);
        HttpRequest request = new HttpRequest(DEFAULT_URI).setAuthType(AuthType.SIGNED).setOAuthArguments(new OAuthArguments(authInfo)).setSecurityToken((SecurityToken)securityToken);
        CacheKeyBuilder key = new CacheKeyBuilder().setLegacyParam(0, (Object)DEFAULT_URI).setLegacyParam(1, (Object)AuthType.SIGNED).setLegacyParam(3, null).setLegacyParam(5, (Object)APP_URI).setLegacyParam(6, (Object)MODULE_ID).setLegacyParam(7, (Object)SERVICE_NAME).setLegacyParam(8, (Object)TOKEN_NAME);
        Assert.assertEquals((Object)key.build(), (Object)this.cache.createKey(request));
    }

    @Test
    public void createKeyWithTokenOwner() throws Exception {
        RequestAuthenticationInfo authInfo = this.newMockAuthInfo(true, true, (Map<String, String>)ImmutableMap.of((Object)"OAUTH_SERVICE_NAME", (Object)SERVICE_NAME, (Object)"OAUTH_TOKEN_NAME", (Object)TOKEN_NAME, (Object)"OAUTH_USE_TOKEN", (Object)"always"));
        EasyMock.replay((Object[])new Object[]{authInfo});
        String userId = "user id";
        BasicSecurityToken securityToken = new BasicSecurityToken(userId, userId, "", "", APP_URI.toString(), MODULE_ID, CONTAINER_NAME, null, null);
        HttpRequest request = new HttpRequest(DEFAULT_URI).setAuthType(AuthType.SIGNED).setOAuthArguments(new OAuthArguments(authInfo)).setSecurityToken((SecurityToken)securityToken);
        CacheKeyBuilder key = new CacheKeyBuilder().setLegacyParam(0, (Object)DEFAULT_URI).setLegacyParam(1, (Object)AuthType.SIGNED).setLegacyParam(2, (Object)userId).setLegacyParam(3, (Object)userId).setLegacyParam(4, (Object)userId).setLegacyParam(5, (Object)APP_URI).setLegacyParam(6, (Object)MODULE_ID).setLegacyParam(7, (Object)SERVICE_NAME).setLegacyParam(8, (Object)TOKEN_NAME);
        Assert.assertEquals((Object)key.build(), (Object)this.cache.createKey(request));
    }

    @Test(expected=IllegalArgumentException.class)
    public void createKeyWithoutSecurityToken() throws Exception {
        RequestAuthenticationInfo authInfo = this.newMockAuthInfo(true, false, (Map<String, String>)ImmutableMap.of());
        EasyMock.replay((Object[])new Object[]{authInfo});
        HttpRequest request = new HttpRequest(DEFAULT_URI).setAuthType(AuthType.SIGNED).setOAuthArguments(new OAuthArguments(authInfo));
        this.cache.createKey(request);
    }

    @Test
    public void getResponse() {
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        String key = this.cache.createKey(request);
        HttpResponse response = new HttpResponse("result");
        this.cache.map.put(key, response);
        Assert.assertEquals((Object)response, (Object)this.cache.getResponse(request));
    }

    @Test
    public void getResponseUsingPost() {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setMethod("POST");
        String key = this.cache.createKey(request);
        HttpResponse response = new HttpResponse("result");
        this.cache.map.put(key, response);
        Assert.assertNull((String)"Did not return null when method was POST", (Object)this.cache.getResponse(request));
    }

    @Test
    public void getResponseUsingMethodOverride() {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setMethod("POST").addHeader("X-Method-Override", "GET");
        String key = this.cache.createKey(request);
        HttpResponse response = new HttpResponse("result");
        this.cache.map.put(key, response);
        Assert.assertEquals((Object)response, (Object)this.cache.getResponse(request));
    }

    @Test
    public void getResponseIgnoreCache() {
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        String key = this.cache.createKey(request);
        HttpResponse response = new HttpResponse("result");
        this.cache.map.put(key, response);
        request.setIgnoreCache(true);
        Assert.assertNull((String)"Did not return null when ignoreCache was true", (Object)this.cache.getResponse(request));
    }

    @Test
    public void getResponseNotCacheable() {
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        HttpResponse response = new HttpResponseBuilder().setStrictNoCache().create();
        this.cache.addResponse(request, response);
        Assert.assertNull((String)"Did not return null when response was uncacheable", (Object)this.cache.getResponse(request));
    }

    @Test
    public void addResponse() {
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        HttpResponse response = new HttpResponse("normal");
        String key = this.cache.createKey(request);
        Assert.assertTrue((String)"response should have been cached", (boolean)this.cache.addResponse(request, response));
        Assert.assertEquals((Object)response, (Object)this.cache.map.get(key));
    }

    @Test
    public void addResponseIgnoreCache() {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setIgnoreCache(true);
        HttpResponse response = new HttpResponse("does not matter");
        Assert.assertFalse((String)"response should not have been cached", (boolean)this.cache.addResponse(request, response));
        Assert.assertEquals((long)0L, (long)this.cache.map.size());
    }

    @Test
    public void addResponseNotCacheable() {
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        HttpResponse response = new HttpResponseBuilder().setStrictNoCache().create();
        Assert.assertFalse((boolean)this.cache.addResponse(request, response));
        Assert.assertEquals((long)0L, (long)this.cache.map.size());
    }

    @Test
    public void addResponseIfModifiedSince() {
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        HttpResponse response = new HttpResponseBuilder().setHttpStatusCode(304).create();
        Assert.assertFalse((boolean)this.cache.addResponse(request, response));
        Assert.assertEquals((long)0L, (long)this.cache.map.size());
    }

    @Test
    public void addResponseUsingPost() {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setMethod("POST");
        HttpResponse response = new HttpResponse("does not matter");
        Assert.assertFalse((boolean)this.cache.addResponse(request, response));
        Assert.assertEquals((long)0L, (long)this.cache.map.size());
    }

    @Test
    public void addResponseUsingMethodOverride() {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setMethod("POST").addHeader("X-Method-Override", "GET");
        HttpResponse response = new HttpResponse("normal");
        String key = this.cache.createKey(request);
        Assert.assertTrue((boolean)this.cache.addResponse(request, response));
        Assert.assertEquals((Object)response, (Object)this.cache.map.get(key));
    }

    @Test
    public void addResponseWithForcedTtl() {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setCacheTtl(10);
        String key = this.cache.createKey(request);
        HttpResponse response = new HttpResponse("result");
        Assert.assertTrue((boolean)this.cache.addResponse(request, response));
        Assert.assertEquals((Object)"public,max-age=10", (Object)this.cache.map.get(key).getHeader("Cache-Control"));
    }

    @Test
    public void addResponseWithForcedTtlAndStrictNoCache() {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setCacheTtl(10);
        String key = this.cache.createKey(request);
        HttpResponse response = new HttpResponseBuilder().setResponseString("result").setStrictNoCache().create();
        Assert.assertTrue((boolean)this.cache.addResponse(request, response));
        Assert.assertEquals((Object)"public,max-age=10", (Object)this.cache.map.get(key).getHeader("Cache-Control"));
    }

    @Test
    public void addResponseWithNoCachingHeaders() {
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        String key = this.cache.createKey(request);
        HttpResponse response = new HttpResponse("no headers");
        Assert.assertTrue((boolean)this.cache.addResponse(request, response));
        Assert.assertEquals((Object)"no headers", (Object)this.cache.map.get(key).getResponseAsString());
    }

    @Test
    public void removeResponse() {
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        String key = this.cache.createKey(request);
        HttpResponse response = new HttpResponse("result");
        this.cache.map.put(key, response);
        Assert.assertEquals((Object)response, (Object)this.cache.removeResponse(request));
        Assert.assertEquals((long)0L, (long)this.cache.map.size());
    }

    @Test
    public void removeResponseIsStaled() {
        long expiration = System.currentTimeMillis() + 1000L;
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        String key = this.cache.createKey(request);
        HttpResponse response = new HttpResponseBuilder().setExpirationTime(expiration).create();
        this.cache.map.put(key, response);
        Assert.assertEquals((Object)response, (Object)this.cache.removeResponse(request));
        Assert.assertEquals((long)0L, (long)this.cache.map.size());
    }

    private static class TestHttpCache
    extends AbstractHttpCache {
        protected final Map<String, HttpResponse> map = Maps.newHashMap();

        public void addResponseImpl(String key, HttpResponse response) {
            this.map.put(key, response);
        }

        public HttpResponse getResponseImpl(String key) {
            return this.map.get(key);
        }

        public HttpResponse removeResponseImpl(String key) {
            return this.map.remove(key);
        }
    }
}

