/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provider;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCacheProvider;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.http.DefaultHttpCache;
import org.apache.shindig.gadgets.http.DefaultInvalidationService;
import org.apache.shindig.gadgets.http.DefaultRequestPipeline;
import org.apache.shindig.gadgets.http.DefaultRequestPipelineTest;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.HttpResponseMetadataHelper;
import org.apache.shindig.gadgets.http.InvalidationService;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.rewrite.DefaultResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultInvalidationServiceTest
extends Assert {
    private static final Uri URI = Uri.parse((String)"http://www.example.org/spec.xml");
    private static final HttpResponse CACHEABLE = new HttpResponseBuilder().setResponseString("ORIGINALCONTENT").setHeader("Cache-Control", "max-age=1000").create();
    IMocksControl control;
    HttpCache cache;
    DefaultInvalidationService service;
    LruCacheProvider cacheProvider;
    FakeGadgetToken appxToken;
    FakeGadgetToken appyToken;
    DefaultRequestPipelineTest.FakeHttpFetcher fetcher;
    DefaultRequestPipelineTest.FakeOAuthRequestProvider oauth;
    DefaultRequestPipeline requestPipeline;
    HttpRequest signedRequest;

    @Before
    public void setUp() {
        this.cacheProvider = new LruCacheProvider(100);
        this.cache = new DefaultHttpCache((CacheProvider)this.cacheProvider);
        this.service = new DefaultInvalidationService(this.cache, (CacheProvider)this.cacheProvider, new AtomicLong());
        this.appxToken = new FakeGadgetToken();
        this.appxToken.setAppId("AppX");
        this.appxToken.setOwnerId("OwnerX");
        this.appxToken.setViewerId("ViewerX");
        this.appyToken = new FakeGadgetToken();
        this.appyToken.setAppId("AppY");
        this.appyToken.setOwnerId("OwnerY");
        this.appyToken.setViewerId("ViewerY");
        this.signedRequest = new HttpRequest(URI);
        this.signedRequest.setAuthType(AuthType.SIGNED);
        this.signedRequest.setSecurityToken((SecurityToken)this.appxToken);
        this.signedRequest.setOAuthArguments(new OAuthArguments());
        this.signedRequest.getOAuthArguments().setUseToken(OAuthArguments.UseToken.NEVER);
        this.signedRequest.getOAuthArguments().setSignOwner(true);
        this.signedRequest.getOAuthArguments().setSignViewer(true);
        this.fetcher = new DefaultRequestPipelineTest.FakeHttpFetcher();
        this.oauth = new DefaultRequestPipelineTest.FakeOAuthRequestProvider();
        this.requestPipeline = new DefaultRequestPipeline((HttpFetcher)this.fetcher, this.cache, (Provider)this.oauth, (ResponseRewriterRegistry)new DefaultResponseRewriterRegistry(null, null), (InvalidationService)this.service, new HttpResponseMetadataHelper());
    }

    @Test
    public void testInvalidateUrl() throws Exception {
        this.cache.addResponse(new HttpRequest(URI), CACHEABLE);
        DefaultInvalidationServiceTest.assertEquals((long)1L, (long)this.cacheProvider.createCache("httpResponses").getSize());
        this.service.invalidateApplicationResources((Set)ImmutableSet.of((Object)URI), (SecurityToken)this.appxToken);
        DefaultInvalidationServiceTest.assertEquals((long)0L, (long)this.cacheProvider.createCache("httpResponses").getSize());
    }

    @Test
    public void testInvalidateUsers() throws Exception {
        this.service.invalidateUserResources((Set)ImmutableSet.of((Object)"example.org:1", (Object)"example.org:2"), (SecurityToken)this.appxToken);
        this.service.invalidateUserResources((Set)ImmutableSet.of((Object)"example.org:1", (Object)"example.org:2"), (SecurityToken)this.appyToken);
        DefaultInvalidationServiceTest.assertEquals((long)4L, (long)this.cacheProvider.createCache("invalidatedUsers").getSize());
        DefaultInvalidationServiceTest.assertNotNull((Object)this.cacheProvider.createCache("invalidatedUsers").getElement((Object)"INV_TOK:AppX:1"));
        DefaultInvalidationServiceTest.assertNotNull((Object)this.cacheProvider.createCache("invalidatedUsers").getElement((Object)"INV_TOK:AppX:2"));
        DefaultInvalidationServiceTest.assertNotNull((Object)this.cacheProvider.createCache("invalidatedUsers").getElement((Object)"INV_TOK:AppY:1"));
        DefaultInvalidationServiceTest.assertNotNull((Object)this.cacheProvider.createCache("invalidatedUsers").getElement((Object)"INV_TOK:AppY:2"));
    }

    @Test
    public void testFetchWithInvalidationEnabled() throws Exception {
        this.cache.addResponse(new HttpRequest(URI), CACHEABLE);
        DefaultInvalidationServiceTest.assertEquals((Object)CACHEABLE, (Object)this.requestPipeline.execute(new HttpRequest(URI)));
    }

    @Test
    public void testFetchInvalidatedContent() throws Exception {
        this.cache.addResponse(new HttpRequest(URI), CACHEABLE);
        this.service.invalidateApplicationResources((Set)ImmutableSet.of((Object)URI), (SecurityToken)this.appxToken);
        this.fetcher.response = new HttpResponseBuilder(CACHEABLE).setResponseString("NEWCONTENT1").create();
        DefaultInvalidationServiceTest.assertEquals((Object)this.requestPipeline.execute(new HttpRequest(URI)), (Object)this.fetcher.response);
    }

    @Test
    public void testFetchContentWithMarker() throws Exception {
        this.oauth.httpResponse = CACHEABLE;
        HttpResponse httpResponse = this.requestPipeline.execute(this.signedRequest);
        DefaultInvalidationServiceTest.assertEquals((Object)CACHEABLE, (Object)httpResponse);
        DefaultInvalidationServiceTest.assertEquals((long)1L, (long)this.cacheProvider.createCache("httpResponses").getSize());
        this.service.invalidateUserResources((Set)ImmutableSet.of((Object)"OwnerX"), (SecurityToken)this.appxToken);
        this.oauth.httpResponse = new HttpResponseBuilder(CACHEABLE).setResponseString("NEWCONTENT1").create();
        httpResponse = this.requestPipeline.execute(this.signedRequest);
        DefaultInvalidationServiceTest.assertEquals((Object)"NEWCONTENT1", (Object)httpResponse.getResponseAsString());
        DefaultInvalidationServiceTest.assertEquals((Object)"o=1;", (Object)httpResponse.getHeader("X-Shindig-Invalidation"));
        DefaultInvalidationServiceTest.assertEquals((long)1L, (long)this.cacheProvider.createCache("httpResponses").getSize());
        this.service.invalidateUserResources((Set)ImmutableSet.of((Object)"ViewerX"), (SecurityToken)this.appxToken);
        this.oauth.httpResponse = new HttpResponseBuilder(CACHEABLE).setResponseString("NEWCONTENT2").create();
        httpResponse = this.requestPipeline.execute(this.signedRequest);
        DefaultInvalidationServiceTest.assertEquals((Object)"NEWCONTENT2", (Object)httpResponse.getResponseAsString());
        DefaultInvalidationServiceTest.assertEquals((Object)"o=1;v=2;", (Object)httpResponse.getHeader("X-Shindig-Invalidation"));
        DefaultInvalidationServiceTest.assertEquals((long)1L, (long)this.cacheProvider.createCache("httpResponses").getSize());
    }

    @Test
    public void testFetchContentSignedOwner() throws Exception {
        this.oauth.httpResponse = CACHEABLE;
        this.signedRequest.getOAuthArguments().setSignViewer(false);
        HttpResponse httpResponse = this.requestPipeline.execute(this.signedRequest);
        DefaultInvalidationServiceTest.assertEquals((Object)CACHEABLE, (Object)httpResponse);
        DefaultInvalidationServiceTest.assertEquals((long)1L, (long)this.cacheProvider.createCache("httpResponses").getSize());
        this.service.invalidateUserResources((Set)ImmutableSet.of((Object)"OwnerX"), (SecurityToken)this.appxToken);
        this.oauth.httpResponse = new HttpResponseBuilder(CACHEABLE).setResponseString("NEWCONTENT1").create();
        httpResponse = this.requestPipeline.execute(this.signedRequest);
        DefaultInvalidationServiceTest.assertEquals((Object)"NEWCONTENT1", (Object)httpResponse.getResponseAsString());
        DefaultInvalidationServiceTest.assertEquals((Object)"o=1;", (Object)httpResponse.getHeader("X-Shindig-Invalidation"));
        DefaultInvalidationServiceTest.assertEquals((long)1L, (long)this.cacheProvider.createCache("httpResponses").getSize());
        this.service.invalidateUserResources((Set)ImmutableSet.of((Object)"ViewerX"), (SecurityToken)this.appxToken);
        this.oauth.httpResponse = new HttpResponseBuilder(CACHEABLE).setResponseString("NEWCONTENT2").create();
        httpResponse = this.requestPipeline.execute(this.signedRequest);
        DefaultInvalidationServiceTest.assertEquals((Object)"NEWCONTENT1", (Object)httpResponse.getResponseAsString());
        DefaultInvalidationServiceTest.assertEquals((Object)"o=1;", (Object)httpResponse.getHeader("X-Shindig-Invalidation"));
        DefaultInvalidationServiceTest.assertEquals((long)1L, (long)this.cacheProvider.createCache("httpResponses").getSize());
    }

    @Test
    public void testFetchContentSignedViewer() throws Exception {
        this.oauth.httpResponse = CACHEABLE;
        this.signedRequest.getOAuthArguments().setSignOwner(false);
        HttpResponse httpResponse = this.requestPipeline.execute(this.signedRequest);
        DefaultInvalidationServiceTest.assertEquals((Object)CACHEABLE, (Object)httpResponse);
        DefaultInvalidationServiceTest.assertEquals((long)1L, (long)this.cacheProvider.createCache("httpResponses").getSize());
        this.service.invalidateUserResources((Set)ImmutableSet.of((Object)"OwnerX"), (SecurityToken)this.appxToken);
        this.oauth.httpResponse = new HttpResponseBuilder(CACHEABLE).setResponseString("NEWCONTENT1").create();
        httpResponse = this.requestPipeline.execute(this.signedRequest);
        DefaultInvalidationServiceTest.assertEquals((Object)CACHEABLE, (Object)httpResponse);
        this.service.invalidateUserResources((Set)ImmutableSet.of((Object)"ViewerX"), (SecurityToken)this.appxToken);
        this.oauth.httpResponse = new HttpResponseBuilder(CACHEABLE).setResponseString("NEWCONTENT2").create();
        httpResponse = this.requestPipeline.execute(this.signedRequest);
        DefaultInvalidationServiceTest.assertEquals((Object)"NEWCONTENT2", (Object)httpResponse.getResponseAsString());
        DefaultInvalidationServiceTest.assertEquals((Object)"v=2;", (Object)httpResponse.getHeader("X-Shindig-Invalidation"));
        DefaultInvalidationServiceTest.assertEquals((long)1L, (long)this.cacheProvider.createCache("httpResponses").getSize());
    }

    @Test
    public void testServeInvalidatedContentWithFetcherError() throws Exception {
        this.oauth.httpResponse = CACHEABLE;
        HttpResponse httpResponse = this.requestPipeline.execute(this.signedRequest);
        this.service.invalidateUserResources((Set)ImmutableSet.of((Object)"OwnerX"), (SecurityToken)this.appxToken);
        this.oauth.httpResponse = HttpResponse.error();
        httpResponse = this.requestPipeline.execute(this.signedRequest);
        DefaultInvalidationServiceTest.assertEquals((Object)CACHEABLE, (Object)httpResponse);
    }
}

