/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.oauth.BasicOAuthStore;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerKeyAndSecret;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicOAuthStoreTest {
    private static final String SAMPLE_FILE = "{'http://localhost:8080/samplecontainer/examples/oauth.xml' : {'' : {'consumer_key' : 'gadgetConsumer','consumer_secret' : 'gadgetSecret','key_type' : 'HMAC_SYMMETRIC'}},'http://rsagadget/test.xml' : {'' : {'consumer_key' : 'rsaconsumer','consumer_secret' : 'rsaprivate','callback_url' : 'callback','key_type' : 'RSA_PRIVATE'}}}";
    private BasicOAuthStore store;

    @Before
    public void setUp() throws Exception {
        this.store = new BasicOAuthStore();
        this.store.initFromConfigString(SAMPLE_FILE);
        this.store.setDefaultCallbackUrl("default callback");
    }

    @Test
    public void testInit() throws Exception {
        FakeGadgetToken t = new FakeGadgetToken();
        t.setAppUrl("http://localhost:8080/samplecontainer/examples/oauth.xml");
        OAuthServiceProvider provider = new OAuthServiceProvider("req", "authorize", "access");
        OAuthStore.ConsumerInfo consumerInfo = this.store.getConsumerKeyAndSecret((SecurityToken)t, "", provider);
        OAuthConsumer consumer = consumerInfo.getConsumer();
        Assert.assertEquals((Object)"gadgetConsumer", (Object)consumer.consumerKey);
        Assert.assertEquals((Object)"gadgetSecret", (Object)consumer.consumerSecret);
        Assert.assertEquals((Object)"HMAC-SHA1", (Object)consumer.getProperty("oauth_signature_method"));
        Assert.assertEquals((Object)provider, (Object)consumer.serviceProvider);
        Assert.assertNull((Object)consumerInfo.getKeyName());
        Assert.assertEquals((Object)"default callback", (Object)consumerInfo.getCallbackUrl());
        t.setAppUrl("http://rsagadget/test.xml");
        consumerInfo = this.store.getConsumerKeyAndSecret((SecurityToken)t, "", provider);
        consumer = consumerInfo.getConsumer();
        Assert.assertEquals((Object)"rsaconsumer", (Object)consumer.consumerKey);
        Assert.assertNull((Object)consumer.consumerSecret);
        Assert.assertEquals((Object)"RSA-SHA1", (Object)consumer.getProperty("oauth_signature_method"));
        Assert.assertEquals((Object)provider, (Object)consumer.serviceProvider);
        Assert.assertEquals((Object)"rsaprivate", (Object)consumer.getProperty("RSA-SHA1.PrivateKey"));
        Assert.assertNull((Object)consumerInfo.getKeyName());
        Assert.assertEquals((Object)"callback", (Object)consumerInfo.getCallbackUrl());
    }

    @Test
    public void testGetAndSetAndRemoveToken() {
        FakeGadgetToken t = new FakeGadgetToken();
        OAuthStore.ConsumerInfo consumer = new OAuthStore.ConsumerInfo(null, null, null);
        t.setAppUrl("http://localhost:8080/samplecontainer/examples/oauth.xml");
        t.setViewerId("viewer-one");
        Assert.assertNull((Object)this.store.getTokenInfo((SecurityToken)t, consumer, "", ""));
        OAuthStore.TokenInfo info = new OAuthStore.TokenInfo("token", "secret", null, 0L);
        this.store.setTokenInfo((SecurityToken)t, consumer, "service", "token", info);
        info = this.store.getTokenInfo((SecurityToken)t, consumer, "service", "token");
        Assert.assertEquals((Object)"token", (Object)info.getAccessToken());
        Assert.assertEquals((Object)"secret", (Object)info.getTokenSecret());
        FakeGadgetToken t2 = new FakeGadgetToken();
        t2.setAppUrl("http://localhost:8080/samplecontainer/examples/oauth.xml");
        t2.setViewerId("viewer-two");
        Assert.assertNull((Object)this.store.getTokenInfo((SecurityToken)t2, consumer, "service", "token"));
        this.store.removeToken((SecurityToken)t, consumer, "service", "token");
        Assert.assertNull((Object)this.store.getTokenInfo((SecurityToken)t, consumer, "service", "token"));
    }

    @Test
    public void testDefaultKey() throws Exception {
        FakeGadgetToken t = new FakeGadgetToken();
        t.setAppUrl("http://localhost:8080/not-in-store.xml");
        OAuthServiceProvider provider = new OAuthServiceProvider("req", "authorize", "access");
        try {
            this.store.getConsumerKeyAndSecret((SecurityToken)t, "", provider);
            Assert.fail();
        }
        catch (GadgetException e) {
            // empty catch block
        }
        BasicOAuthStoreConsumerKeyAndSecret cks = new BasicOAuthStoreConsumerKeyAndSecret("somekey", "default", BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE, "keyname", null);
        this.store.setDefaultKey(cks);
        OAuthStore.ConsumerInfo consumer = this.store.getConsumerKeyAndSecret((SecurityToken)t, "", provider);
        Assert.assertEquals((Object)"somekey", (Object)consumer.getConsumer().consumerKey);
        Assert.assertNull((Object)consumer.getConsumer().consumerSecret);
        Assert.assertEquals((Object)"RSA-SHA1", (Object)consumer.getConsumer().getProperty("oauth_signature_method"));
        Assert.assertEquals((Object)"default", (Object)consumer.getConsumer().getProperty("RSA-SHA1.PrivateKey"));
        Assert.assertEquals((Object)provider, (Object)consumer.getConsumer().serviceProvider);
        Assert.assertEquals((Object)"keyname", (Object)consumer.getKeyName());
        Assert.assertEquals((Object)"default callback", (Object)consumer.getCallbackUrl());
        cks = new BasicOAuthStoreConsumerKeyAndSecret("somekey", "default", BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE, "keyname", "callback");
        this.store.setDefaultKey(cks);
        consumer = this.store.getConsumerKeyAndSecret((SecurityToken)t, "", provider);
        Assert.assertEquals((Object)"callback", (Object)consumer.getCallbackUrl());
    }

    @Test
    public void testNullCallback() throws Exception {
        this.store = new BasicOAuthStore();
        this.store.initFromConfigString(SAMPLE_FILE);
        FakeGadgetToken t = new FakeGadgetToken();
        t.setAppUrl("http://localhost:8080/samplecontainer/examples/oauth.xml");
        OAuthServiceProvider provider = new OAuthServiceProvider("req", "authorize", "access");
        OAuthStore.ConsumerInfo consumerInfo = this.store.getConsumerKeyAndSecret((SecurityToken)t, "", provider);
        OAuthConsumer consumer = consumerInfo.getConsumer();
        Assert.assertEquals((Object)"gadgetConsumer", (Object)consumer.consumerKey);
        Assert.assertNull((Object)consumerInfo.getKeyName());
        Assert.assertNull((Object)consumerInfo.getCallbackUrl());
    }
}

