/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import java.util.List;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCacheProvider;
import org.apache.shindig.gadgets.parse.caja.CajaCssLexerParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CajaCssLexerParserTest
extends Assert {
    private CajaCssLexerParser cajaCssParser;
    private static final String CSS = "@import url('www.example.org/someother.css');\n.xyz { background-image : url(http://www.example.org/someimage.gif); }\nA { color : #7f7f7f }\n";

    @Before
    public void setUp() throws Exception {
        this.cajaCssParser = new CajaCssLexerParser();
    }

    @Test
    public void testBasicCssParse() throws Exception {
        String css = ".xyz { font : bold; } A { color : #7f7f7f }";
        List styleSheet = this.cajaCssParser.parse(css);
        CajaCssLexerParserTest.assertEquals((Object)this.cajaCssParser.serialize(styleSheet), (Object)css);
    }

    @Test
    public void testClone() throws Exception {
        this.cajaCssParser.setCacheProvider((CacheProvider)new LruCacheProvider(100));
        List styleSheet = this.cajaCssParser.parseImpl(CSS);
        List styleSheet2 = this.cajaCssParser.parse(CSS);
        CajaCssLexerParserTest.assertEquals((Object)this.cajaCssParser.serialize(styleSheet), (Object)this.cajaCssParser.serialize(styleSheet2));
    }

    @Test
    public void testCache() throws Exception {
        this.cajaCssParser.setCacheProvider((CacheProvider)new LruCacheProvider(100));
        List styleSheet = this.cajaCssParser.parse(CSS);
        List styleSheet2 = this.cajaCssParser.parse(CSS);
        CajaCssLexerParserTest.assertFalse((boolean)((Object)styleSheet).equals(styleSheet2));
        CajaCssLexerParserTest.assertEquals((Object)this.cajaCssParser.serialize(styleSheet), (Object)this.cajaCssParser.serialize(styleSheet2));
    }
}

