/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.shindig.gadgets.preload.ConcurrentPreloads;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentPreloadsTest {
    @Test
    public void getData() throws Exception {
        ConcurrentPreloads preloads = new ConcurrentPreloads();
        preloads.add((Future)TestFuture.returnsNormal("foo"));
        preloads.add((Future)TestFuture.returnsNormal("bar"));
        Assert.assertEquals((long)2L, (long)preloads.size());
        Iterator iterator = preloads.iterator();
        Assert.assertEquals(TestFuture.expectedResult("foo"), (Object)((PreloadedData)iterator.next()).toJson());
        Assert.assertEquals(TestFuture.expectedResult("bar"), (Object)((PreloadedData)iterator.next()).toJson());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void getDataWithRuntimeException() throws Exception {
        ConcurrentPreloads preloads = new ConcurrentPreloads();
        preloads.add((Future)TestFuture.throwsExecution());
        preloads.add((Future)TestFuture.returnsNormal("foo"));
        Assert.assertEquals((long)2L, (long)preloads.size());
        Iterator iterator = preloads.iterator();
        PreloadedData withError = (PreloadedData)iterator.next();
        try {
            withError.toJson();
            Assert.fail();
        }
        catch (PreloadException pe) {
            Assert.assertSame(pe.getCause().getClass(), RuntimeException.class);
        }
        Assert.assertEquals(TestFuture.expectedResult("foo"), (Object)((PreloadedData)iterator.next()).toJson());
    }

    @Test
    public void getDataWithPreloadException() throws Exception {
        ConcurrentPreloads preloads = new ConcurrentPreloads();
        preloads.add((Future)TestFuture.throwsExecutionWrapped());
        preloads.add((Future)TestFuture.returnsNormal("foo"));
        Assert.assertEquals((long)2L, (long)preloads.size());
        Iterator iterator = preloads.iterator();
        PreloadedData withError = (PreloadedData)iterator.next();
        try {
            withError.toJson();
            Assert.fail();
        }
        catch (PreloadException pe) {
            Assert.assertNull((Object)pe.getCause());
        }
        Assert.assertEquals(TestFuture.expectedResult("foo"), (Object)((PreloadedData)iterator.next()).toJson());
    }

    @Test(expected=RuntimeException.class)
    public void getDataThrowsInterruped() throws Exception {
        ConcurrentPreloads preloads = new ConcurrentPreloads();
        preloads.add((Future)TestFuture.throwsInterrupted());
        preloads.add((Future)TestFuture.returnsNormal("foo"));
        Assert.assertEquals((long)2L, (long)preloads.size());
        Iterator iterator = preloads.iterator();
        iterator.next();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestFuture
    implements Future<PreloadedData> {
        private boolean throwsInterrupted;
        private boolean throwsExecution;
        private boolean throwsExecutionWrapped;
        protected final String key;

        private TestFuture(String key) {
            this.key = key;
        }

        public static TestFuture returnsNormal(String key) {
            return new TestFuture(key);
        }

        public static TestFuture throwsInterrupted() {
            TestFuture future = new TestFuture(null);
            future.throwsInterrupted = true;
            return future;
        }

        public static TestFuture throwsExecution() {
            TestFuture future = new TestFuture(null);
            future.throwsExecution = true;
            return future;
        }

        public static TestFuture throwsExecutionWrapped() {
            TestFuture future = new TestFuture(null);
            future.throwsExecutionWrapped = true;
            return future;
        }

        public static Collection<Object> expectedResult(String key) {
            return ImmutableList.of((Object)ImmutableMap.of((Object)key, (Object)"Preloaded"));
        }

        @Override
        public PreloadedData get() throws InterruptedException, ExecutionException {
            if (this.throwsInterrupted) {
                throw new InterruptedException("Interrupted!");
            }
            if (this.throwsExecution) {
                throw new ExecutionException(new RuntimeException("Fail"));
            }
            if (this.throwsExecutionWrapped) {
                throw new ExecutionException((Throwable)new PreloadException("Preload failed."));
            }
            return new PreloadedData(){

                public Collection<Object> toJson() {
                    return TestFuture.expectedResult(TestFuture.this.key);
                }
            };
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public PreloadedData get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

