/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.caja.CajaCssParser;
import org.apache.shindig.gadgets.parse.caja.CajaCssSanitizer;
import org.apache.shindig.gadgets.parse.caja.CajaHtmlParser;
import org.apache.shindig.gadgets.render.SanitizingGadgetRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewriterTestBase;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.uri.PassthruManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SanitizingGadgetRewriterTest
extends RewriterTestBase {
    private static final Set<String> DEFAULT_TAGS = ImmutableSet.of((Object)"html", (Object)"head", (Object)"body");
    private static final Pattern BODY_REGEX = Pattern.compile(".*<body>(.+)</body>.*");
    private final GadgetContext sanitaryGadgetContext = new GadgetContext(){

        public String getParameter(String name) {
            return UriCommon.Param.SANITIZE.getKey().equals(name) ? "1" : null;
        }

        public String getContainer() {
            return "mock";
        }
    };
    private final GadgetContext unsanitaryGadgetContext = new GadgetContext();
    private final GadgetContext unsanitaryGadgetContextNoCacheAndDebug = new GadgetContext(){

        public boolean getIgnoreCache() {
            return true;
        }

        public boolean getDebug() {
            return true;
        }
    };
    private Gadget gadget;
    private Gadget gadgetNoCacheAndDebug;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.gadget = new Gadget().setContext(this.unsanitaryGadgetContext);
        this.gadget.setSpec(new GadgetSpec(Uri.parse((String)"http://www.example.org/gadget.xml"), "<Module><ModulePrefs title=''/><Content type='x-html-sanitized'/></Module>"));
        this.gadget.setCurrentView((View)this.gadget.getSpec().getViews().values().iterator().next());
        this.gadgetNoCacheAndDebug = new Gadget().setContext(this.unsanitaryGadgetContextNoCacheAndDebug);
        this.gadgetNoCacheAndDebug.setSpec(new GadgetSpec(Uri.parse((String)"http://www.example.org/gadget.xml"), "<Module><ModulePrefs title=''/><Content type='x-html-sanitized'/></Module>"));
        this.gadgetNoCacheAndDebug.setCurrentView((View)this.gadgetNoCacheAndDebug.getSpec().getViews().values().iterator().next());
    }

    @Override
    protected Class<? extends GadgetHtmlParser> getParserClass() {
        return CajaHtmlParser.class;
    }

    private String rewrite(Gadget gadget, String content, Set<String> tags, Set<String> attributes) throws Exception {
        GadgetRewriter rewriter = this.createRewriter(tags, attributes);
        MutableContent mc = new MutableContent(this.parser, content);
        rewriter.rewrite(gadget, mc);
        Matcher matcher = BODY_REGEX.matcher(mc.getContent());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return mc.getContent();
    }

    private static Set<String> set(String ... items) {
        return Sets.newHashSet((Object[])items);
    }

    private GadgetRewriter createRewriter(Set<String> tags, Set<String> attributes) {
        HashSet<String> newTags = new HashSet<String>(tags);
        newTags.addAll(DEFAULT_TAGS);
        ContentRewriterFeature.Factory rewriterFeatureFactory = new ContentRewriterFeature.Factory(null, new ContentRewriterFeature.DefaultConfig(".*", "", "HTTP", "embed,img,script,link,style", false, false));
        return new SanitizingGadgetRewriter(newTags, attributes, rewriterFeatureFactory, new CajaCssSanitizer(new CajaCssParser()), (ProxyUriManager)new PassthruManager("host.com", "/proxy"));
    }

    @Test
    public void enforceTagWhiteList() throws Exception {
        String markup = "<p><style type=\"text/css\">A { font : bold }</style>text <b>bold text</b></p><b>Bold text</b><i>Italic text<b>Bold text</b></i>";
        String sanitized = "<p>text <b>bold text</b></p><b>Bold text</b>";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(this.gadget, markup, SanitizingGadgetRewriterTest.set("p", "b"), SanitizingGadgetRewriterTest.set(new String[0])));
    }

    @Test
    public void enforceStyleSanitized() throws Exception {
        String markup = "<p><style type=\"text/css\">A { font : bold; behavior : bad }</style>text <b>bold text</b></p><b>Bold text</b><i>Italic text<b>Bold text</b></i>";
        String sanitized = "<html><head></head><body><p><style>A {\n  font: bold\n}</style>text <b>bold text</b></p><b>Bold text</b></body></html>";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(this.gadget, markup, SanitizingGadgetRewriterTest.set("p", "b", "style"), SanitizingGadgetRewriterTest.set(new String[0])));
    }

    @Test
    public void enforceStyleLinkRewritten() throws Exception {
        String markup = "<link rel=\"stylesheet\" href=\"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.evil.com%2Fx.css&gadget=www.example.org%2Fgadget.xml&fp=45508&rewriteMime=text/css\"/>";
        String sanitized = "<html><head><link href=\"http://host.com/proxy?url=http%3A%2F%2Fwww.test.com%2Fdir%2Fproxy%3Furl%3Dhttp%253A%252F%252Fwww.evil.com%252Fx.css%26gadget%3Dwww.example.org%252Fgadget.xml%26fp%3D45508%26rewriteMime%3Dtext%2Fcss&amp;sanitize=1&amp;rewriteMime=text%2Fcss\" rel=\"stylesheet\"></head><body></body></html>";
        String rewritten = this.rewrite(this.gadget, markup, SanitizingGadgetRewriterTest.set("link"), SanitizingGadgetRewriterTest.set("rel", "href"));
        Assert.assertEquals((Object)sanitized, (Object)rewritten);
    }

    @Test
    public void enforceStyleLinkRewrittenNoCacheAndDebug() throws Exception {
        String markup = "<link rel=\"stylesheet\" href=\"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.evil.com%2Fx.css&gadget=www.example.org%2Fgadget.xml&fp=45508&rewriteMime=text/css\"/>";
        String sanitized = "<html><head><link href=\"http://host.com/proxy?url=http%3A%2F%2Fwww.test.com%2Fdir%2Fproxy%3Furl%3Dhttp%253A%252F%252Fwww.evil.com%252Fx.css%26gadget%3Dwww.example.org%252Fgadget.xml%26fp%3D45508%26rewriteMime%3Dtext%2Fcss&amp;sanitize=1&amp;rewriteMime=text%2Fcss\" rel=\"stylesheet\"></head><body></body></html>";
        String rewritten = this.rewrite(this.gadgetNoCacheAndDebug, markup, SanitizingGadgetRewriterTest.set("link"), SanitizingGadgetRewriterTest.set("rel", "href"));
        Assert.assertEquals((Object)sanitized, (Object)rewritten);
    }

    @Test
    public void enforceNonStyleLinkStripped() throws Exception {
        String markup = "<link rel=\"script\" href=\"www.exmaple.org/evil.js\"/>";
        String rewritten = this.rewrite(this.gadget, markup, SanitizingGadgetRewriterTest.set("link"), SanitizingGadgetRewriterTest.set("rel", "href", "type"));
        Assert.assertEquals((Object)"<html><head></head><body></body></html>", (Object)rewritten);
    }

    @Test
    public void enforceNonStyleLinkStrippedNoCacheAndDebug() throws Exception {
        String markup = "<link rel=\"script\" href=\"www.exmaple.org/evil.js\"/>";
        String rewritten = this.rewrite(this.gadgetNoCacheAndDebug, markup, SanitizingGadgetRewriterTest.set("link"), SanitizingGadgetRewriterTest.set("rel", "href", "type"));
        Assert.assertEquals((Object)"<html><head></head><body></body></html>", (Object)rewritten);
    }

    @Test
    public void enforceCssImportLinkRewritten() throws Exception {
        String markup = "<style type=\"text/css\">@import url('www.evil.com/x.js');</style>";
        String sanitized = "<html><head><style>@import url('http://host.com/proxy?url=http%3A%2F%2Fwww.example.org%2Fwww.evil.com%2Fx.js&sanitize=1&rewriteMime=text%2Fcss');</style></head><body></body></html>";
        String rewritten = this.rewrite(this.gadget, markup, SanitizingGadgetRewriterTest.set("style"), SanitizingGadgetRewriterTest.set(new String[0]));
        Assert.assertEquals((Object)sanitized, (Object)rewritten);
    }

    @Test
    public void enforceCssImportLinkRewrittenNoCacheAndDebug() throws Exception {
        String markup = "<style type=\"text/css\">@import url('www.evil.com/x.js');</style>";
        String sanitized = "<html><head><style>@import url('http://host.com/proxy?url=http%3A%2F%2Fwww.example.org%2Fwww.evil.com%2Fx.js&sanitize=1&rewriteMime=text%2Fcss');</style></head><body></body></html>";
        String rewritten = this.rewrite(this.gadgetNoCacheAndDebug, markup, SanitizingGadgetRewriterTest.set("style"), SanitizingGadgetRewriterTest.set(new String[0]));
        Assert.assertEquals((Object)sanitized, (Object)rewritten);
    }

    @Test
    public void enforceCssImportBadLinkStripped() throws Exception {
        String markup = "<style type=\"text/css\">@import url('javascript:doevil()'); A { font : bold }</style>";
        String sanitized = "<html><head><style>A {\n  font: bold\n}</style></head><body></body></html>";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(this.gadget, markup, SanitizingGadgetRewriterTest.set("style"), SanitizingGadgetRewriterTest.set(new String[0])));
    }

    @Test
    public void enforceAttributeWhiteList() throws Exception {
        String markup = "<p foo=\"bar\" bar=\"baz\">Paragraph</p>";
        String sanitized = "<p bar=\"baz\">Paragraph</p>";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(this.gadget, markup, SanitizingGadgetRewriterTest.set("p"), SanitizingGadgetRewriterTest.set("bar")));
    }

    @Test
    public void enforceImageSrcProxied() throws Exception {
        String markup = "<img src='http://www.evil.com/x.js'>Evil happens</img>";
        String sanitized = "<img src=\"http://host.com/proxy?url=http%3A%2F%2Fwww.evil.com%2Fx.js&amp;sanitize=1&amp;rewriteMime=image%2F*\">Evil happens";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(this.gadget, markup, SanitizingGadgetRewriterTest.set("img"), SanitizingGadgetRewriterTest.set("src")));
    }

    @Test
    public void enforceImageSrcProxiedNoCacheAndDebug() throws Exception {
        String markup = "<img src='http://www.evil.com/x.js'>Evil happens</img>";
        String sanitized = "<img src=\"http://host.com/proxy?url=http%3A%2F%2Fwww.evil.com%2Fx.js&amp;sanitize=1&amp;rewriteMime=image%2F*\">Evil happens";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(this.gadgetNoCacheAndDebug, markup, SanitizingGadgetRewriterTest.set("img"), SanitizingGadgetRewriterTest.set("src")));
    }

    @Test
    public void enforceBadImageUrlStripped() throws Exception {
        String markup = "<img src='java\\ script:evil()'>Evil happens</img>";
        String sanitized = "<img>Evil happens";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(this.gadget, markup, SanitizingGadgetRewriterTest.set("img"), SanitizingGadgetRewriterTest.set("src")));
    }

    @Test
    public void enforceTargetTopRestricted() throws Exception {
        String markup = "<a href=\"http://www.example.com\" target=\"_top\">x</a>";
        String sanitized = "<a href=\"http://www.example.com\">x</a>";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(this.gadget, markup, SanitizingGadgetRewriterTest.set("a"), SanitizingGadgetRewriterTest.set("href", "target")));
    }

    @Test
    public void enforceTargetSelfAllowed() throws Exception {
        String markup = "<a href=\"http://www.example.com\" target=\"_self\">x</a>";
        Assert.assertEquals((Object)markup, (Object)this.rewrite(this.gadget, markup, SanitizingGadgetRewriterTest.set("a"), SanitizingGadgetRewriterTest.set("href", "target")));
    }

    @Test
    public void enforceTargetBlankAllowed() throws Exception {
        String markup = "<a href=\"http://www.example.com\" target=\"_BlAnK\">x</a>";
        Assert.assertEquals((Object)markup, (Object)this.rewrite(this.gadget, markup, SanitizingGadgetRewriterTest.set("a"), SanitizingGadgetRewriterTest.set("href", "target")));
    }

    @Test
    public void sanitizationBypassAllowed() throws Exception {
        String markup = "<p foo=\"bar\"><b>Parag</b><!--raph--></p>";
        GadgetRewriter rewriter = this.createRewriter(SanitizingGadgetRewriterTest.set(new String[0]), SanitizingGadgetRewriterTest.set(new String[0]));
        MutableContent mc = new MutableContent(this.parser, markup);
        Document document = mc.getDocument();
        MutableContent.notifyEdit((Document)document);
        String fullMarkup = mc.getContent();
        Element paragraphTag = (Element)document.getElementsByTagName("p").item(0);
        SanitizingGadgetRewriter.bypassSanitization((Element)paragraphTag, (boolean)true);
        rewriter.rewrite(this.gadget, mc);
        Assert.assertEquals((Object)fullMarkup, (Object)mc.getContent());
    }

    @Test
    public void sanitizationBypassOnlySelf() throws Exception {
        String markup = "<p foo=\"bar\"><b>Parag</b><!--raph--></p>";
        GadgetRewriter rewriter = this.createRewriter(SanitizingGadgetRewriterTest.set(new String[0]), SanitizingGadgetRewriterTest.set(new String[0]));
        MutableContent mc = new MutableContent(this.parser, markup);
        Document document = mc.getDocument();
        Element paragraphTag = (Element)document.getElementsByTagName("p").item(0);
        SanitizingGadgetRewriter.bypassSanitization((Element)paragraphTag, (boolean)false);
        rewriter.rewrite(this.gadget, mc);
        String content = mc.getContent();
        Matcher matcher = BODY_REGEX.matcher(content);
        matcher.matches();
        Assert.assertEquals((Object)"<p foo=\"bar\"></p>", (Object)matcher.group(1));
    }

    @Test
    public void sanitizationBypassPreservedAcrossClone() throws Exception {
        String markup = "<p foo=\"bar\"><b>Parag</b><!--raph--></p>";
        GadgetRewriter rewriter = this.createRewriter(SanitizingGadgetRewriterTest.set(new String[0]), SanitizingGadgetRewriterTest.set(new String[0]));
        MutableContent mc = new MutableContent(this.parser, markup);
        Document document = mc.getDocument();
        Element paragraphTag = (Element)document.getElementsByTagName("p").item(0);
        SanitizingGadgetRewriter.bypassSanitization((Element)paragraphTag, (boolean)false);
        Element cloned = (Element)paragraphTag.cloneNode(true);
        paragraphTag.getParentNode().replaceChild(cloned, paragraphTag);
        rewriter.rewrite(this.gadget, mc);
        String content = mc.getContent();
        Matcher matcher = BODY_REGEX.matcher(content);
        matcher.matches();
        Assert.assertEquals((Object)"<p foo=\"bar\"></p>", (Object)matcher.group(1));
    }

    @Test
    public void allCommentsStripped() throws Exception {
        String markup = "<b>Hello, world</b><!--<b>evil</b>-->";
        Assert.assertEquals((Object)"<b>Hello, world</b>", (Object)this.rewrite(this.gadget, markup, SanitizingGadgetRewriterTest.set("b"), SanitizingGadgetRewriterTest.set(new String[0])));
    }

    @Test
    public void doesNothingWhenNotSanitized() throws Exception {
        String markup = "<script src=\"http://evil.org/evil\"></script> <b>hello</b>";
        Gadget gadget = new Gadget().setContext(this.unsanitaryGadgetContext);
        gadget.setSpec(new GadgetSpec(Uri.parse((String)"www.example.org/gadget.xml"), "<Module><ModulePrefs title=''/><Content type='html'/></Module>"));
        gadget.setCurrentView((View)gadget.getSpec().getViews().values().iterator().next());
        Assert.assertEquals((Object)markup, (Object)this.rewrite(gadget, markup, SanitizingGadgetRewriterTest.set("b"), SanitizingGadgetRewriterTest.set(new String[0])));
    }

    @Test
    public void forceSanitizeUnsanitaryGadget() throws Exception {
        String markup = "<p><style type=\"text/css\">A { font : bold; behavior : bad }</style>text <b>bold text</b></p><b>Bold text</b><i>Italic text<b>Bold text</b></i>";
        String sanitized = "<html><head></head><body><p><style>A {\n  font: bold\n}</style>text <b>bold text</b></p><b>Bold text</b></body></html>";
        Gadget gadget = new Gadget().setContext(this.sanitaryGadgetContext);
        gadget.setSpec(new GadgetSpec(Uri.parse((String)"http://www.example.org/gadget.xml"), "<Module><ModulePrefs title=''/><Content type='html'/></Module>"));
        gadget.setCurrentView((View)gadget.getSpec().getViews().values().iterator().next());
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(gadget, markup, SanitizingGadgetRewriterTest.set("p", "b", "style"), SanitizingGadgetRewriterTest.set(new String[0])));
    }
}

