/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.caja.CajaCssParser;
import org.apache.shindig.gadgets.parse.caja.CajaCssSanitizer;
import org.apache.shindig.gadgets.render.SanitizingResponseRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterTestBase;
import org.apache.shindig.gadgets.uri.PassthruManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SanitizingResponseRewriterTest
extends RewriterTestBase {
    private static final Uri CONTENT_URI = Uri.parse((String)"http://www.example.org/content");

    private String rewrite(HttpRequest request, HttpResponse response) throws Exception {
        request.setSanitizationRequested(true);
        ResponseRewriter rewriter = this.createRewriter(Collections.<String>emptySet(), Collections.<String>emptySet());
        HttpResponseBuilder hrb = new HttpResponseBuilder(this.parser, response);
        rewriter.rewrite(request, hrb);
        if (hrb.getNumChanges() == 0) {
            return null;
        }
        return hrb.getContent();
    }

    private ResponseRewriter createRewriter(Set<String> tags, Set<String> attributes) {
        ContentRewriterFeature.Factory rewriterFeatureFactory = new ContentRewriterFeature.Factory(null, new ContentRewriterFeature.DefaultConfig(".*", "", "HTTP", "embed,img,script,link,style", false, false));
        return new SanitizingResponseRewriter(rewriterFeatureFactory, new CajaCssSanitizer(new CajaCssParser()), (ProxyUriManager)new PassthruManager());
    }

    @Test
    public void enforceInvalidProxedCssRejected() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType("text/css");
        HttpResponse response = new HttpResponseBuilder().setResponseString("doEvil()").create();
        String sanitized = "";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(req, response));
    }

    @Test
    public void enforceValidProxedCssAccepted() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType("text/css");
        HttpResponse response = new HttpResponseBuilder().setResponseString("@import url('http://www.evil.com/more.css'); A { font : BOLD }").create();
        String sanitized = "@import url('http://www.evil.com/more.css?sanitize=1&rewriteMime=text%2Fcss');\nA {\n  font: BOLD\n}";
        String rewritten = this.rewrite(req, response);
        Assert.assertEquals((Object)sanitized, (Object)rewritten);
    }

    @Test
    public void enforceValidProxedCssAcceptedNoCache() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType("text/css");
        req.setIgnoreCache(true);
        HttpResponse response = new HttpResponseBuilder().setResponseString("@import url('http://www.evil.com/more.css'); A { font : BOLD }").create();
        String sanitized = "@import url('http://www.evil.com/more.css?sanitize=1&rewriteMime=text%2Fcss');\nA {\n  font: BOLD\n}";
        String rewritten = this.rewrite(req, response);
        Assert.assertEquals((Object)sanitized, (Object)rewritten);
    }

    @Test
    public void enforceInvalidProxedImageRejected() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType("image/*");
        HttpResponse response = new HttpResponseBuilder().setResponse("NOTIMAGE".getBytes()).create();
        String sanitized = "";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(req, response));
    }

    @Test
    public void validProxiedImageAccepted() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType("image/*");
        HttpResponse response = new HttpResponseBuilder().setResponse(IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/image/inefficient.png"))).create();
        Assert.assertNull((Object)this.rewrite(req, response));
    }

    @Test
    public void enforceUnknownMimeTypeRejected() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType("text/foo");
        HttpResponse response = new HttpResponseBuilder().setResponseString("doEvil()").create();
        String sanitized = "";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(req, response));
    }

    @Test
    public void enforceMissingMimeTypeRejected() throws Exception {
        HttpRequest req = new HttpRequest(CONTENT_URI);
        req.setRewriteMimeType(null);
        HttpResponse response = new HttpResponseBuilder().setResponseString("doEvil()").create();
        String sanitized = "";
        Assert.assertEquals((Object)sanitized, (Object)this.rewrite(req, response));
    }
}

