/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import java.util.HashMap;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.rewrite.AbsolutePathReferenceVisitor;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.DomWalkerTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AbsolutePathReferenceVisitorTest
extends DomWalkerTestBase {
    private static final Uri ABSOLUTE_URI = Uri.parse((String)"http://host.com/path");
    private static final String JS_URI_STR = "javascript:foo();";
    private static final Uri RELATIVE_URI = Uri.parse((String)"/host/relative");
    private static final Uri RELATIVE_RESOLVED_URI = GADGET_URI.resolve(RELATIVE_URI);
    private static final Uri PATH_RELATIVE_URI = Uri.parse((String)"path/relative");
    private static final Uri PATH_RELATIVE_RESOLVED_URI = GADGET_URI.resolve(PATH_RELATIVE_URI);
    private static final String INVALID_URI_STRING = "!^|BAD URI|^!";

    AbsolutePathReferenceVisitor visitorForAllTags() {
        return new AbsolutePathReferenceVisitor(new AbsolutePathReferenceVisitor.Tags[]{AbsolutePathReferenceVisitor.Tags.RESOURCES, AbsolutePathReferenceVisitor.Tags.HYPERLINKS});
    }

    AbsolutePathReferenceVisitor visitorForHyperlinks() {
        return new AbsolutePathReferenceVisitor(new AbsolutePathReferenceVisitor.Tags[]{AbsolutePathReferenceVisitor.Tags.HYPERLINKS});
    }

    AbsolutePathReferenceVisitor visitorForResources() {
        return new AbsolutePathReferenceVisitor(new AbsolutePathReferenceVisitor.Tags[]{AbsolutePathReferenceVisitor.Tags.RESOURCES});
    }

    @Test
    public void bypassComment() throws Exception {
        Comment comment = this.doc.createComment("howdy pardner");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(comment));
    }

    @Test
    public void bypassText() throws Exception {
        Text text = this.doc.createTextNode("back scratchah! get ya back scratcha he'yah!");
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(text));
    }

    @Test
    public void bypassNonSupportedTag() throws Exception {
        Element div = this.elem("div", "src", RELATIVE_URI.toString(), "href", RELATIVE_URI.toString());
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(div));
    }

    @Test
    public void bypassObjectTag() throws Exception {
        Element objectElement = this.elem("object", "src", RELATIVE_URI.toString());
        Assert.assertEquals((String)"Element with object tag should be bypassed", (Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(objectElement));
    }

    @Test
    public void bypassTagWithoutAttrib() throws Exception {
        Element a = this.elem("a", new String[0]);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(a));
    }

    @Test
    public void absolutifyTagA() throws Exception {
        this.checkAbsolutifyStates("a");
    }

    @Test
    public void absolutifyTagImg() throws Exception {
        this.checkAbsolutifyStates("img");
    }

    @Test
    public void absolutifyTagInput() throws Exception {
        this.checkAbsolutifyStates("input");
    }

    @Test
    public void absolutifyTagBody() throws Exception {
        this.checkAbsolutifyStates("body");
    }

    @Test
    public void absolutifyTagLink() throws Exception {
        Element cssLink = this.elem("link", "href", RELATIVE_URI.toString(), "rel", "stylesheet", "type", "text/css");
        Assert.assertEquals((String)"CSS link tag should not be bypassed", (Object)DomWalker.Visitor.VisitStatus.MODIFY, (Object)this.getVisitStatus(cssLink));
    }

    @Test
    public void bypassTagLinkWithNoRel() throws Exception {
        Element cssLink = this.elem("link", "href", RELATIVE_URI.toString(), "type", "text/css");
        Assert.assertEquals((String)"CSS link tag should be bypassed", (Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(cssLink));
    }

    @Test
    public void bypassTagLinkWithNoType() throws Exception {
        Element cssLink = this.elem("link", "href", RELATIVE_URI.toString(), "rel", "stylesheet");
        Assert.assertEquals((String)"CSS link tag should be bypassed", (Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(cssLink));
    }

    @Test
    public void bypassTagLinkAlternate() throws Exception {
        Element cssLink = this.elem("link", "href", RELATIVE_URI.toString(), "rel", "alternate", "hreflang", "el");
        Assert.assertEquals((String)"CSS link tag should be bypassed", (Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(cssLink));
    }

    @Test
    public void absolutifyTagScript() throws Exception {
        this.checkAbsolutifyStates("script");
    }

    @Test
    public void revisitDoesNothing() throws Exception {
        Assert.assertFalse((boolean)this.visitorForAllTags().revisit(this.gadget(), null));
    }

    @Test
    public void resolveRelativeToBaseTagIfPresent() throws Exception {
        Element baseTag = this.elem("base", "href", "http://www.example.org");
        Element img = this.elem("img", "src", RELATIVE_URI.toString());
        Element html = this.htmlDoc(null, baseTag, img);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(baseTag));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.MODIFY, (Object)this.getVisitStatus(img));
        Assert.assertEquals((Object)("http://www.example.org" + RELATIVE_URI.toString()), (Object)img.getAttribute("src"));
    }

    @Test
    public void getBaseHrefReturnsNullIfBaseTagWithoutHrefAttribute() throws Exception {
        Element baseTag = this.elem("base", new String[0]);
        Element img = this.elem("img", "src", RELATIVE_URI.toString());
        Element html = this.htmlDoc(null, baseTag, img);
        AbsolutePathReferenceVisitor visitor = this.visitorForAllTags();
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(baseTag));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.MODIFY, (Object)this.getVisitStatus(img));
        Assert.assertEquals((Object)RELATIVE_RESOLVED_URI.toString(), (Object)img.getAttribute("src"));
    }

    @Test
    public void testGetBaseUri() throws Exception {
        Element baseTag1 = this.elem("base", "href", "http://www.example1.org");
        Element baseTag2 = this.elem("base", "href", "http://www.example2.org");
        Element img = this.elem("img", "src", RELATIVE_URI.toString());
        Element a = this.elem("a", "href", RELATIVE_URI.toString());
        Node[] headNodes = new Node[]{baseTag1};
        Element html = this.htmlDoc(headNodes, baseTag2, img, a);
        AbsolutePathReferenceVisitor visitor = this.visitorForAllTags();
        Assert.assertEquals((Object)"http://www.example1.org", (Object)visitor.getBaseHref(html.getOwnerDocument()));
        Assert.assertEquals((Object)"http://www.example1.org", (Object)visitor.getBaseUri(html.getOwnerDocument()).toString());
    }

    private void checkAbsolutifyStates(String tagName) throws Exception {
        String lcTag = tagName.toLowerCase();
        String ucTag = tagName.toUpperCase();
        HashMap resourceTags = new HashMap();
        resourceTags.putAll(AbsolutePathReferenceVisitor.Tags.RESOURCES.getResourceTags());
        resourceTags.putAll(AbsolutePathReferenceVisitor.Tags.HYPERLINKS.getResourceTags());
        String validAttr = (String)resourceTags.get(lcTag);
        String invalidAttr = validAttr + "whoknows";
        Element lcValidRelative = this.elem(lcTag, validAttr, RELATIVE_URI.toString());
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.MODIFY, (Object)this.getVisitStatus(lcValidRelative));
        Assert.assertEquals((Object)RELATIVE_RESOLVED_URI.toString(), (Object)lcValidRelative.getAttribute(validAttr));
        Element lcValidPathRelative = this.elem(lcTag, validAttr, PATH_RELATIVE_URI.toString());
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.MODIFY, (Object)this.getVisitStatus(lcValidPathRelative));
        Assert.assertEquals((Object)PATH_RELATIVE_RESOLVED_URI.toString(), (Object)lcValidPathRelative.getAttribute(validAttr));
        Element ucValidRelative = this.elem(ucTag, validAttr, RELATIVE_URI.toString());
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.MODIFY, (Object)this.getVisitStatus(ucValidRelative));
        Assert.assertEquals((Object)RELATIVE_RESOLVED_URI.toString(), (Object)ucValidRelative.getAttribute(validAttr));
        Element ucValidPathRelative = this.elem(ucTag, validAttr, PATH_RELATIVE_URI.toString());
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.MODIFY, (Object)this.getVisitStatus(ucValidPathRelative));
        Assert.assertEquals((Object)PATH_RELATIVE_RESOLVED_URI.toString(), (Object)ucValidPathRelative.getAttribute(validAttr));
        Element lcValidInvalid = this.elem(lcTag, validAttr, INVALID_URI_STRING);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(lcValidRelative));
        Assert.assertEquals((Object)INVALID_URI_STRING, (Object)lcValidInvalid.getAttribute(validAttr));
        Element lcValidAbsolute = this.elem(lcTag, validAttr, ABSOLUTE_URI.toString());
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(lcValidAbsolute));
        Assert.assertEquals((Object)ABSOLUTE_URI.toString(), (Object)lcValidAbsolute.getAttribute(validAttr));
        Element lcInvalidRelative = this.elem(lcTag, invalidAttr, RELATIVE_URI.toString());
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(lcInvalidRelative));
        Assert.assertEquals((Object)RELATIVE_URI.toString(), (Object)lcInvalidRelative.getAttribute(invalidAttr));
        Element lcValidJs = this.elem(lcTag, validAttr, JS_URI_STR);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatus(lcValidJs));
        Assert.assertEquals((Object)JS_URI_STR, (Object)lcValidJs.getAttribute(validAttr));
    }

    private DomWalker.Visitor.VisitStatus getVisitStatus(Node node) throws Exception {
        return this.visitorForAllTags().visit(this.gadget(), node);
    }
}

