/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.parse.DefaultHtmlSerializer;
import org.apache.shindig.gadgets.parse.caja.CajaHtmlSerializer;
import org.apache.shindig.gadgets.rewrite.ConcatVisitor;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.DomWalkerTestBase;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.uri.ConcatUriManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcatVisitorTest
extends DomWalkerTestBase {
    private static final String JS1_URL_STR = "http://one.com/foo.js?test=1&ui=2";
    private Node js1;
    private static final String JS2_URL_STR = "http://two.com/foo.js";
    private Node js2;
    private static final String JS3_URL_STR = "http://three.com/foo.js";
    private Node js3;
    private static final String JS4_URL_STR = "http://four.com/foo.js";
    private Node js4;
    private static final String JS5_URL_STR = "http://~^|BAD |^/foo.js";
    private Node js5;
    private static final String JS6_URL_STR = "http://six.com/foo.js";
    private Node js6;
    private static final String CSS1_URL_STR = "http://one.com/foo.js";
    private Node css1;
    private static final String CSS2_URL_STR = "http://two.com/foo.js";
    private Node css2;
    private static final String CSS3_URL_STR = "http://three.com/foo.js";
    private Node css3;
    private static final String CSS4_URL_STR = "http://four.com/foo.js";
    private Node css4;
    private static final String CSS5_URL_STR = "http://five.com/foo.js";
    private Node css5;
    private static final String CSS6_URL_STR = "http://six.com/foo.js";
    private Node css6;
    private static final String CSS7_URL_STR = "http://seven.com/foo.js";
    private Node css7;
    private static final String CSS8_URL_STR = "http://eight.com/foo.js";
    private Node css8;
    private static final String CSS9_URL_STR = "http://nine.com/foo.js";
    private Node css9;
    private static final String CSS10_URL_STR = "http://ten.com/foo.js";
    private Node css10;
    private static final String CSS11_URL_STR = "http://eleven.com/foo.js";
    private Node css11;
    private static final String CSS12_URL_STR = "http://twelve.com/foo.js";
    private Node css12;
    private static final Uri CONCAT_BASE_URI = Uri.parse((String)"http://test.com/proxy");

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.js1 = this.elem("script", "src", JS1_URL_STR);
        this.js2 = this.elem("script", "src", "http://two.com/foo.js");
        this.js3 = this.elem("script", "src", "http://three.com/foo.js");
        this.js4 = this.elem("script", "src", "http://four.com/foo.js");
        this.js5 = this.elem("script", "src", JS5_URL_STR);
        this.js6 = this.elem("script", "src", "http://six.com/foo.js");
        this.css1 = this.elem("link", "rel", "Stylesheet", "type", "Text/css", "href", CSS1_URL_STR);
        this.css2 = this.elem("link", "rel", "stylesheet", "type", "text/css", "href", "http://two.com/foo.js");
        this.css3 = this.elem("link", "rel", "stylesheet", "type", "text/css", "href", "http://three.com/foo.js");
        this.css4 = this.elem("link", "rel", "stylesheet", "type", "text/css", "href", "http://four.com/foo.js");
        this.css5 = this.elem("link", "rel", "stylesheet", "type", "text/css", "media", "print", "href", CSS5_URL_STR);
        this.css6 = this.elem("link", "rel", "stylesheet", "type", "text/css", "media", "print", "href", "http://six.com/foo.js");
        this.css7 = this.elem("link", "rel", "stylesheet", "type", "text/css", "media", "screen", "href", CSS7_URL_STR);
        this.css8 = this.elem("link", "rel", "stylesheet", "type", "text/css", "media", "screen", "href", CSS8_URL_STR);
        this.css9 = this.elem("link", "rel", "stylesheet", "type", "text/css", "href", CSS9_URL_STR);
        this.css10 = this.elem("link", "rel", "stylesheet", "type", "text/css", "media", "all", "href", CSS10_URL_STR);
        this.css11 = this.elem("link", "rel", "stylesheet", "type", "text/css", "media", "all", "href", CSS11_URL_STR);
        this.css12 = this.elem("link", "rel", "stylesheet", "type", "text/css", "media", "all", "href", CSS12_URL_STR);
    }

    @Test
    public void dontVisitSingleJs() throws Exception {
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusJs(this.js1, null, false));
    }

    @Test
    public void dontVisitSingleCss() throws Exception {
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusCss(this.css1, null));
    }

    @Test
    public void dontVisitJsWithoutSrc() throws Exception {
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusJs(this.elem("script", new String[0]), null, false));
    }

    @Test
    public void dontVisitUnknown() throws Exception {
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusJs(this.elem("div", new String[0]), null, true));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusCss(this.elem("div", new String[0]), null));
    }

    @Test
    public void dontVisitContigJsMiddleNotRewritable() throws Exception {
        ContentRewriterFeature.Config config = this.config(".*two.*", false);
        this.seqNodes(this.js1, this.js2, this.js3);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusJs(config, this.js1));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusJs(config, this.js2));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusJs(config, this.js3));
    }

    @Test
    public void dontVisitContigCssMiddleNotRewritable() throws Exception {
        ContentRewriterFeature.Config config = this.config(".*two.*", true);
        this.seqNodes(this.css1, this.css2, this.css3);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusCss(config, this.css1));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusCss(config, this.css2));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusCss(config, this.css3));
    }

    @Test
    public void dontVisitSeparatedJsNotSplit() throws Exception {
        ContentRewriterFeature.Config config = this.config(null, false);
        Element sep1 = this.elem("div", new String[0]);
        Element sep2 = this.elem("span", new String[0]);
        this.seqNodes(this.js1, sep1, this.js2, sep2, this.js3);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusJs(config, this.js1));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusJs(config, sep1));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusJs(config, this.js2));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusJs(config, sep2));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusJs(config, this.js3));
    }

    @Test
    public void visitValidCss() throws Exception {
        Text textNode = this.doc.createTextNode("");
        Element node = this.elem("link", "type", "text/css", "rel", "stylesheet", "href", CSS1_URL_STR);
        this.seqNodes(node, textNode, this.css1);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusCss(node, null));
    }

    @Test
    public void visitCssSeperatedByTextNode() throws Exception {
        Text textNode = this.doc.createTextNode("Data\n");
        Element node = this.elem("link", "type", "text/css", "rel", "stylesheet", "href", CSS1_URL_STR);
        this.seqNodes(node, textNode, this.css1);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusCss(node, null));
    }

    @Test
    public void visitCssSeperatedByNormalComment() throws Exception {
        Comment commentNode = this.doc.createComment("This is a comment");
        Element node = this.elem("link", "type", "text/css", "rel", "stylesheet", "href", CSS1_URL_STR);
        this.seqNodes(node, commentNode, this.css1);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusCss(node, null));
    }

    @Test
    public void dontVisitCssSeperatedByConditionalComment() throws Exception {
        Comment commentNode = this.doc.createComment("[if IE]");
        Element node = this.elem("link", "type", "text/css", "rel", "stylesheet", "href", CSS1_URL_STR);
        this.seqNodes(node, commentNode, this.css1);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusCss(node, null));
    }

    @Test
    public void dontVisitRelFreeCss() throws Exception {
        Element node = this.elem("link", "type", "text/css", "href", CSS1_URL_STR);
        this.seqNodes(node, this.css1);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusCss(node, null));
    }

    @Test
    public void dontVisitTypeCssFreeCss() throws Exception {
        Element node = this.elem("link", "rel", "stylesheet", "href", CSS1_URL_STR);
        this.seqNodes(node, this.css1);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusCss(node, null));
    }

    @Test
    public void dontVisitTypeCssWrongRelAttributes() throws Exception {
        Element node = this.elem("link", "rel", "alternate", "type", "text/css", "href", CSS1_URL_STR);
        this.seqNodes(node, this.css1);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusCss(node, null));
    }

    @Test
    public void dontVisitTypeCssWrongTypeAttributes() throws Exception {
        Element node = this.elem("link", "rel", "stylesheet", "type", "text/javascript", "href", CSS1_URL_STR);
        this.seqNodes(node, this.css1);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusCss(node, null));
    }

    @Test
    public void dontVisitCssWithoutAttribs() throws Exception {
        Element node = this.elem("link", "href", CSS1_URL_STR);
        this.seqNodes(node, this.css1);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.BYPASS, (Object)this.getVisitStatusCss(node, null));
    }

    @Test
    public void visitContigJs() throws Exception {
        this.seqNodes(this.js1, this.js2, this.js3);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusJs(this.js1, null, false));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusJs(this.js2, null, false));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusJs(this.js3, null, false));
    }

    @Test
    public void visitContigCss() throws Exception {
        this.seqNodes(this.css1, this.css2, this.css3);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusCss(this.css1, null));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusCss(this.css2, null));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusCss(this.css3, null));
    }

    @Test
    public void visitSplitJsSingle() throws Exception {
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusJs(this.js1, null, true));
    }

    @Test
    public void visitSplitJsSeparated() throws Exception {
        this.seqNodes(this.js1, this.elem("span", new String[0]), this.js2, this.elem("div", new String[0]), this.js3);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusJs(this.js1, null, true));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusJs(this.js2, null, true));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusJs(this.js3, null, true));
    }

    @Test
    public void visitSplitJsContiguous() throws Exception {
        this.seqNodes(this.js1, this.js2, this.js3);
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusJs(this.js1, null, true));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusJs(this.js2, null, true));
        Assert.assertEquals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE, (Object)this.getVisitStatusJs(this.js3, null, true));
    }

    @Test
    public void concatSingleBatchJs() throws Exception {
        List<Node> nodes = this.seqNodes(this.js1, this.js2, this.js3);
        Node parent = this.js1.getParentNode();
        Assert.assertEquals((long)3L, (long)parent.getChildNodes().getLength());
        SimpleConcatUriManager mgr = this.simpleMgr();
        ConcatVisitor.Js rewriter = new ConcatVisitor.Js(this.config(null, false), (ConcatUriManager)mgr);
        Assert.assertTrue((boolean)rewriter.revisit(this.gadget(), nodes));
        Assert.assertEquals((long)1L, (long)parent.getChildNodes().getLength());
        Element concatNode = (Element)parent.getChildNodes().item(0);
        Uri concatUri = Uri.parse((String)concatNode.getAttribute("src"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri.getPath());
        Assert.assertEquals((Object)JS1_URL_STR, (Object)concatUri.getQueryParameter("1"));
        Assert.assertEquals((Object)"http://two.com/foo.js", (Object)concatUri.getQueryParameter("2"));
        Assert.assertEquals((Object)"http://three.com/foo.js", (Object)concatUri.getQueryParameter("3"));
    }

    @Test
    public void concatSingleBatchCss() throws Exception {
        List<Node> nodes = this.seqNodes(this.css1, this.css2, this.css3);
        Node parent = this.css1.getParentNode();
        Assert.assertEquals((long)3L, (long)parent.getChildNodes().getLength());
        SimpleConcatUriManager mgr = this.simpleMgr();
        ConcatVisitor.Css rewriter = new ConcatVisitor.Css(this.config(null, false), (ConcatUriManager)mgr);
        Assert.assertTrue((boolean)rewriter.revisit(this.gadget(), nodes));
        Assert.assertEquals((long)1L, (long)parent.getChildNodes().getLength());
        Element concatNode = (Element)parent.getChildNodes().item(0);
        Uri concatUri = Uri.parse((String)concatNode.getAttribute("href"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri.getPath());
        Assert.assertEquals((Object)CSS1_URL_STR, (Object)concatUri.getQueryParameter("1"));
        Assert.assertEquals((Object)"http://two.com/foo.js", (Object)concatUri.getQueryParameter("2"));
        Assert.assertEquals((Object)"http://three.com/foo.js", (Object)concatUri.getQueryParameter("3"));
    }

    protected Element elemWithNameSpace(String namespace, String tag, String ... attrStrs) {
        Element elem = this.doc.createElementNS(namespace, tag);
        for (int i = 0; attrStrs != null && i < attrStrs.length; i += 2) {
            Attr attr = this.doc.createAttribute(attrStrs[i]);
            attr.setValue(attrStrs[i + 1]);
            elem.setAttributeNode(attr);
        }
        return elem;
    }

    @Test
    public void concatSingleBatchCssWithNamespace() throws Exception {
        String namespace = "http://www.w3.org/1999/xhtml";
        this.css1 = this.elemWithNameSpace(namespace, "link", "rel", "Stylesheet", "type", "Text/css", "href", CSS1_URL_STR);
        this.css2 = this.elemWithNameSpace(namespace, "link", "rel", "stylesheet", "type", "text/css", "href", "http://two.com/foo.js");
        this.css3 = this.elemWithNameSpace(namespace, "link", "rel", "stylesheet", "type", "text/css", "href", "http://three.com/foo.js");
        List<Node> nodes = this.seqNodes(this.css1, this.css2, this.css3);
        Node parent = this.css1.getParentNode();
        Assert.assertEquals((long)3L, (long)parent.getChildNodes().getLength());
        SimpleConcatUriManager mgr = this.simpleMgr();
        ConcatVisitor.Css rewriter = new ConcatVisitor.Css(this.config(null, false), (ConcatUriManager)mgr);
        Assert.assertTrue((boolean)rewriter.revisit(this.gadget(), nodes));
        Assert.assertEquals((long)1L, (long)parent.getChildNodes().getLength());
        Element concatNode = (Element)parent.getChildNodes().item(0);
        Uri concatUri = Uri.parse((String)concatNode.getAttribute("href"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri.getPath());
        Assert.assertEquals((Object)CSS1_URL_STR, (Object)concatUri.getQueryParameter("1"));
        Assert.assertEquals((Object)"http://two.com/foo.js", (Object)concatUri.getQueryParameter("2"));
        Assert.assertEquals((Object)"http://three.com/foo.js", (Object)concatUri.getQueryParameter("3"));
        Assert.assertFalse((boolean)concatUri.toString().contains("&amp;"));
        this.doc.appendChild(concatNode);
        DefaultHtmlSerializer serializer = new DefaultHtmlSerializer();
        String html = serializer.serialize(this.doc);
        Assert.assertTrue((boolean)html.contains(concatUri.toString().replace("&", "&amp;")));
        serializer = new CajaHtmlSerializer();
        html = serializer.serialize(this.doc);
        Assert.assertTrue((boolean)html.contains(concatUri.toString().replace("&", "&amp;")));
    }

    @Test
    public void concatMultiBatchJs() throws Exception {
        ArrayList fullListJs = Lists.newArrayList();
        fullListJs.addAll(this.seqNodes(this.js1, this.js2));
        Node parent1 = this.js1.getParentNode();
        Assert.assertEquals((long)2L, (long)parent1.getChildNodes().getLength());
        fullListJs.addAll(this.seqNodes(this.js3, this.js4));
        Node parent2 = this.js3.getParentNode();
        Assert.assertEquals((long)2L, (long)this.js3.getParentNode().getChildNodes().getLength());
        SimpleConcatUriManager mgr = this.simpleMgr();
        ConcatVisitor.Js rewriter = new ConcatVisitor.Js(this.config(null, false), (ConcatUriManager)mgr);
        Assert.assertTrue((boolean)rewriter.revisit(this.gadget(), (List)fullListJs));
        Assert.assertEquals((long)1L, (long)parent1.getChildNodes().getLength());
        Element cn1 = (Element)parent1.getChildNodes().item(0);
        Uri concatUri1 = Uri.parse((String)cn1.getAttribute("src"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri1.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri1.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri1.getPath());
        Assert.assertEquals((Object)JS1_URL_STR, (Object)concatUri1.getQueryParameter("1"));
        Assert.assertEquals((Object)"http://two.com/foo.js", (Object)concatUri1.getQueryParameter("2"));
        Assert.assertNull((Object)concatUri1.getQueryParameter("3"));
        Assert.assertEquals((long)1L, (long)parent2.getChildNodes().getLength());
        Element cn2 = (Element)parent2.getChildNodes().item(0);
        Uri concatUri2 = Uri.parse((String)cn2.getAttribute("src"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri2.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri2.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri2.getPath());
        Assert.assertEquals((Object)"http://three.com/foo.js", (Object)concatUri2.getQueryParameter("1"));
        Assert.assertEquals((Object)"http://four.com/foo.js", (Object)concatUri2.getQueryParameter("2"));
        Assert.assertNull((Object)concatUri2.getQueryParameter("3"));
    }

    @Test
    public void concatMultiBatchCss() throws Exception {
        ArrayList fullListCss = Lists.newArrayList();
        fullListCss.addAll(this.seqNodes(this.css1, this.css2));
        Node parent1 = this.css1.getParentNode();
        Assert.assertEquals((long)2L, (long)parent1.getChildNodes().getLength());
        fullListCss.addAll(this.seqNodes(this.css3, this.css4, this.css5, this.css7, this.css6, this.css8, this.css9));
        Node parent2 = this.css3.getParentNode();
        Assert.assertEquals((long)7L, (long)this.css3.getParentNode().getChildNodes().getLength());
        SimpleConcatUriManager mgr = this.simpleMgr();
        ConcatVisitor.Css rewriter = new ConcatVisitor.Css(this.config(null, false), (ConcatUriManager)mgr);
        Assert.assertTrue((boolean)rewriter.revisit(this.gadget(), (List)fullListCss));
        Assert.assertEquals((long)1L, (long)parent1.getChildNodes().getLength());
        Element cn1 = (Element)parent1.getChildNodes().item(0);
        Uri concatUri1 = Uri.parse((String)cn1.getAttribute("href"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri1.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri1.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri1.getPath());
        Assert.assertEquals((Object)CSS1_URL_STR, (Object)concatUri1.getQueryParameter("1"));
        Assert.assertEquals((Object)"http://two.com/foo.js", (Object)concatUri1.getQueryParameter("2"));
        Assert.assertNull((Object)concatUri1.getQueryParameter("3"));
        Assert.assertEquals((long)2L, (long)parent2.getChildNodes().getLength());
        Element cn2 = (Element)parent2.getChildNodes().item(0);
        Uri concatUri2 = Uri.parse((String)cn2.getAttribute("href"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri2.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri2.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri2.getPath());
        Assert.assertEquals((Object)"http://three.com/foo.js", (Object)concatUri2.getQueryParameter("1"));
        Assert.assertEquals((Object)"http://four.com/foo.js", (Object)concatUri2.getQueryParameter("2"));
        Assert.assertEquals((Object)CSS7_URL_STR, (Object)concatUri2.getQueryParameter("3"));
        Assert.assertEquals((Object)CSS8_URL_STR, (Object)concatUri2.getQueryParameter("4"));
        Assert.assertEquals((Object)CSS9_URL_STR, (Object)concatUri2.getQueryParameter("5"));
        Assert.assertNull((Object)concatUri2.getQueryParameter("6"));
        Assert.assertEquals((Object)"", (Object)cn2.getAttribute("media"));
        Element cn3 = (Element)parent2.getChildNodes().item(1);
        Uri concatUri3 = Uri.parse((String)cn3.getAttribute("href"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri3.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri3.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri3.getPath());
        Assert.assertEquals((Object)CSS5_URL_STR, (Object)concatUri3.getQueryParameter("1"));
        Assert.assertEquals((Object)"http://six.com/foo.js", (Object)concatUri3.getQueryParameter("2"));
        Assert.assertNull((Object)concatUri3.getQueryParameter("3"));
        Assert.assertEquals((Object)"print", (Object)cn3.getAttribute("media"));
    }

    @Test
    public void concatMultiBatchCssWithAllMediaTypeAndTitle() throws Exception {
        ArrayList fullListCss = Lists.newArrayList();
        ((Element)this.css2).setAttribute("title", "one");
        ((Element)this.css3).setAttribute("title", "two");
        ((Element)this.css4).setAttribute("title", "two");
        ((Element)this.css10).setAttribute("title", "two");
        fullListCss.addAll(this.seqNodes(this.css1, this.css2, this.css3, this.css4, this.css10, this.css11, this.css12, this.css7, this.css8, this.css9));
        Node parent1 = this.css1.getParentNode();
        Assert.assertEquals((long)10L, (long)parent1.getChildNodes().getLength());
        SimpleConcatUriManager mgr = this.simpleMgr();
        ConcatVisitor.Css rewriter = new ConcatVisitor.Css(this.config(null, false), (ConcatUriManager)mgr);
        Assert.assertTrue((boolean)rewriter.revisit(this.gadget(), (List)fullListCss));
        Element cn1 = (Element)parent1.getChildNodes().item(0);
        Uri concatUri1 = Uri.parse((String)cn1.getAttribute("href"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri1.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri1.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri1.getPath());
        Assert.assertEquals((Object)CSS1_URL_STR, (Object)concatUri1.getQueryParameter("1"));
        Assert.assertNull((Object)concatUri1.getQueryParameter("2"));
        Assert.assertEquals((Object)"", (Object)cn1.getAttribute("media"));
        Element cn2 = (Element)parent1.getChildNodes().item(1);
        Uri concatUri2 = Uri.parse((String)cn2.getAttribute("href"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri2.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri2.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri2.getPath());
        Assert.assertEquals((Object)"http://two.com/foo.js", (Object)concatUri2.getQueryParameter("1"));
        Assert.assertNull((Object)concatUri2.getQueryParameter("2"));
        Assert.assertEquals((Object)"", (Object)cn2.getAttribute("media"));
        Assert.assertEquals((Object)"one", (Object)cn2.getAttribute("title"));
        Element cn3 = (Element)parent1.getChildNodes().item(2);
        Uri concatUri3 = Uri.parse((String)cn3.getAttribute("href"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri3.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri3.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri3.getPath());
        Assert.assertEquals((Object)"http://three.com/foo.js", (Object)concatUri3.getQueryParameter("1"));
        Assert.assertEquals((Object)"http://four.com/foo.js", (Object)concatUri3.getQueryParameter("2"));
        Assert.assertNull((Object)concatUri3.getQueryParameter("3"));
        Assert.assertEquals((Object)"", (Object)cn3.getAttribute("media"));
        Assert.assertEquals((Object)"two", (Object)cn3.getAttribute("title"));
        Element cn4 = (Element)parent1.getChildNodes().item(3);
        Uri concatUri4 = Uri.parse((String)cn4.getAttribute("href"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri4.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri4.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri4.getPath());
        Assert.assertEquals((Object)CSS10_URL_STR, (Object)concatUri4.getQueryParameter("1"));
        Assert.assertNull((Object)concatUri4.getQueryParameter("2"));
        Assert.assertEquals((Object)"all", (Object)cn4.getAttribute("media"));
        Assert.assertEquals((Object)"two", (Object)cn4.getAttribute("title"));
        Element cn5 = (Element)parent1.getChildNodes().item(4);
        Uri concatUri5 = Uri.parse((String)cn5.getAttribute("href"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri5.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri5.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri5.getPath());
        Assert.assertEquals((Object)CSS11_URL_STR, (Object)concatUri5.getQueryParameter("1"));
        Assert.assertEquals((Object)CSS12_URL_STR, (Object)concatUri5.getQueryParameter("2"));
        Assert.assertNull((Object)concatUri5.getQueryParameter("3"));
        Assert.assertEquals((Object)"all", (Object)cn5.getAttribute("media"));
        Assert.assertEquals((Object)"", (Object)cn5.getAttribute("title"));
        Element cn6 = (Element)parent1.getChildNodes().item(5);
        Uri concatUri6 = Uri.parse((String)cn6.getAttribute("href"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri6.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri6.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri6.getPath());
        Assert.assertEquals((Object)CSS7_URL_STR, (Object)concatUri6.getQueryParameter("1"));
        Assert.assertEquals((Object)CSS8_URL_STR, (Object)concatUri6.getQueryParameter("2"));
        Assert.assertEquals((Object)CSS9_URL_STR, (Object)concatUri6.getQueryParameter("3"));
        Assert.assertNull((Object)concatUri6.getQueryParameter("4"));
        Assert.assertEquals((Object)"screen", (Object)cn6.getAttribute("media"));
        Assert.assertEquals((Object)"", (Object)cn6.getAttribute("title"));
    }

    @Test
    public void concatMultiBatchJsBadBatch() throws Exception {
        ArrayList fullListJs = Lists.newArrayList();
        fullListJs.addAll(this.seqNodes(this.js1, this.js2));
        Node parent1 = this.js1.getParentNode();
        Assert.assertEquals((long)2L, (long)parent1.getChildNodes().getLength());
        fullListJs.addAll(this.seqNodes(this.js5, this.js6));
        Node parent3 = this.js5.getParentNode();
        Assert.assertEquals((long)2L, (long)parent3.getChildNodes().getLength());
        fullListJs.addAll(this.seqNodes(this.js3, this.js4));
        Node parent2 = this.js3.getParentNode();
        Assert.assertEquals((long)2L, (long)this.js3.getParentNode().getChildNodes().getLength());
        SimpleConcatUriManager mgr = this.simpleMgr();
        ConcatVisitor.Js rewriter = new ConcatVisitor.Js(this.config(null, false), (ConcatUriManager)mgr);
        Assert.assertTrue((boolean)rewriter.revisit(this.gadget(), (List)fullListJs));
        Assert.assertEquals((long)1L, (long)parent1.getChildNodes().getLength());
        Element cn1 = (Element)parent1.getChildNodes().item(0);
        Uri concatUri1 = Uri.parse((String)cn1.getAttribute("src"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri1.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri1.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri1.getPath());
        Assert.assertEquals((Object)JS1_URL_STR, (Object)concatUri1.getQueryParameter("1"));
        Assert.assertEquals((Object)"http://two.com/foo.js", (Object)concatUri1.getQueryParameter("2"));
        Assert.assertEquals((long)2L, (long)parent3.getChildNodes().getLength());
        Assert.assertSame((Object)this.js5, (Object)parent3.getChildNodes().item(0));
        Assert.assertSame((Object)this.js6, (Object)parent3.getChildNodes().item(1));
        Assert.assertEquals((long)1L, (long)parent2.getChildNodes().getLength());
        Element cn2 = (Element)parent2.getChildNodes().item(0);
        Uri concatUri2 = Uri.parse((String)cn2.getAttribute("src"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri2.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri2.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri2.getPath());
        Assert.assertEquals((Object)"http://three.com/foo.js", (Object)concatUri2.getQueryParameter("1"));
        Assert.assertEquals((Object)"http://four.com/foo.js", (Object)concatUri2.getQueryParameter("2"));
    }

    @Test
    public void concatSplitJsSingleBatch() throws Exception {
        List<Node> nodes = this.seqNodes(this.js1, this.js2);
        Node parent = this.js1.getParentNode();
        Assert.assertEquals((long)2L, (long)parent.getChildNodes().getLength());
        SimpleConcatUriManager mgr = this.simpleMgr();
        ConcatVisitor.Js rewriter = new ConcatVisitor.Js(this.config(null, true), (ConcatUriManager)mgr);
        Assert.assertTrue((boolean)rewriter.revisit(this.gadget(), nodes));
        Assert.assertEquals((long)3L, (long)parent.getChildNodes().getLength());
        Element jsConcat = (Element)parent.getChildNodes().item(0);
        Assert.assertEquals((Object)"script", (Object)jsConcat.getTagName());
        Uri concatUri = Uri.parse((String)jsConcat.getAttribute("src"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri.getPath());
        Assert.assertEquals((Object)JS1_URL_STR, (Object)concatUri.getQueryParameter("1"));
        Assert.assertEquals((Object)"http://two.com/foo.js", (Object)concatUri.getQueryParameter("2"));
        Assert.assertNull((Object)concatUri.getQueryParameter("3"));
        Assert.assertEquals((Object)"1", (Object)concatUri.getQueryParameter("SPLIT"));
        Element splitEval1 = (Element)parent.getChildNodes().item(1);
        Assert.assertEquals((Object)"script", (Object)splitEval1.getTagName());
        Assert.assertNull((Object)splitEval1.getAttributeNode("src"));
        Assert.assertEquals((Object)JS1_URL_STR, (Object)splitEval1.getTextContent());
        Element splitEval2 = (Element)parent.getChildNodes().item(2);
        Assert.assertEquals((Object)"script", (Object)splitEval2.getTagName());
        Assert.assertNull((Object)splitEval2.getAttributeNode("src"));
        Assert.assertEquals((Object)"http://two.com/foo.js", (Object)splitEval2.getTextContent());
    }

    @Test
    public void concatSplitJsSplitNodes() throws Exception {
        Element parent = this.doc.createElement("container");
        parent.appendChild(this.doc.createElement("div"));
        parent.appendChild(this.js1);
        parent.appendChild(this.doc.createTextNode("text"));
        parent.appendChild(this.doc.createComment("comment"));
        parent.appendChild(this.js2);
        parent.appendChild(this.doc.createElement("span"));
        ImmutableList nodes = ImmutableList.of((Object)this.js1, (Object)this.js2);
        Assert.assertEquals((long)6L, (long)parent.getChildNodes().getLength());
        SimpleConcatUriManager mgr = this.simpleMgr();
        ConcatVisitor.Js rewriter = new ConcatVisitor.Js(this.config(null, true), (ConcatUriManager)mgr);
        Assert.assertTrue((boolean)rewriter.revisit(this.gadget(), (List)nodes));
        Assert.assertEquals((long)7L, (long)parent.getChildNodes().getLength());
        Element jsConcat = (Element)parent.getChildNodes().item(1);
        Assert.assertEquals((Object)"script", (Object)jsConcat.getTagName());
        Uri concatUri = Uri.parse((String)jsConcat.getAttribute("src"));
        Assert.assertEquals((Object)CONCAT_BASE_URI.getScheme(), (Object)concatUri.getScheme());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getAuthority(), (Object)concatUri.getAuthority());
        Assert.assertEquals((Object)CONCAT_BASE_URI.getPath(), (Object)concatUri.getPath());
        Assert.assertEquals((Object)JS1_URL_STR, (Object)concatUri.getQueryParameter("1"));
        Assert.assertEquals((Object)"http://two.com/foo.js", (Object)concatUri.getQueryParameter("2"));
        Assert.assertNull((Object)concatUri.getQueryParameter("3"));
        Assert.assertEquals((Object)"1", (Object)concatUri.getQueryParameter("SPLIT"));
        Element splitEval1 = (Element)parent.getChildNodes().item(2);
        Assert.assertEquals((Object)"script", (Object)splitEval1.getTagName());
        Assert.assertNull((Object)splitEval1.getAttributeNode("src"));
        Assert.assertEquals((Object)JS1_URL_STR, (Object)splitEval1.getTextContent());
        Element splitEval2 = (Element)parent.getChildNodes().item(5);
        Assert.assertEquals((Object)"script", (Object)splitEval2.getTagName());
        Assert.assertNull((Object)splitEval2.getAttributeNode("src"));
        Assert.assertEquals((Object)"http://two.com/foo.js", (Object)splitEval2.getTextContent());
    }

    private DomWalker.Visitor.VisitStatus getVisitStatusJs(ContentRewriterFeature.Config config, Node node) throws RewritingException {
        return new ConcatVisitor.Js(config, null).visit(this.gadget(), node);
    }

    private DomWalker.Visitor.VisitStatus getVisitStatusJs(Node node, String rewriteRegex, boolean splitJs) throws Exception {
        ContentRewriterFeature.Config config = this.config(rewriteRegex, splitJs);
        return this.getVisitStatusJs(config, node);
    }

    private DomWalker.Visitor.VisitStatus getVisitStatusCss(ContentRewriterFeature.Config config, Node node) throws RewritingException {
        return new ConcatVisitor.Css(config, null).visit(this.gadget(), node);
    }

    private DomWalker.Visitor.VisitStatus getVisitStatusCss(Node node, String rewriteRegex) throws Exception {
        ContentRewriterFeature.Config config = this.config(rewriteRegex, true);
        return this.getVisitStatusCss(config, node);
    }

    private ContentRewriterFeature.Config config(String exclude, boolean splitJs) {
        return new ContentRewriterFeature.DefaultConfig(".*", exclude == null ? "" : exclude, "0", "", false, splitJs);
    }

    private List<Node> seqNodes(Node ... nodes) {
        Element container = this.doc.createElement("container");
        ArrayList seq = Lists.newArrayListWithCapacity((int)nodes.length);
        for (Node node : nodes) {
            container.appendChild(node);
            seq.add(node);
        }
        return seq;
    }

    private SimpleConcatUriManager simpleMgr() {
        return new SimpleConcatUriManager(CONCAT_BASE_URI);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleConcatUriManager
    implements ConcatUriManager {
        private final Uri base;

        private SimpleConcatUriManager(Uri base) {
            this.base = base;
        }

        public List<ConcatUriManager.ConcatData> make(List<ConcatUriManager.ConcatUri> batches, boolean isAdjacent) {
            ArrayList results = Lists.newArrayListWithCapacity((int)batches.size());
            for (ConcatUriManager.ConcatUri batch : batches) {
                UriBuilder uriBuilder = new UriBuilder(this.base);
                Integer i = 1;
                for (Uri uri : batch.getBatch()) {
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                    uriBuilder.addQueryParameter(n.toString(), uri.toString());
                }
                HashMap snippets = Maps.newHashMap();
                if (!isAdjacent) {
                    for (Uri uri : batch.getBatch()) {
                        snippets.put(uri, uri.toString());
                    }
                    uriBuilder.addQueryParameter("SPLIT", "1");
                }
                results.add(new ConcatUriManager.ConcatData(uriBuilder.toUri(), (Map)snippets));
            }
            return results;
        }

        public ConcatUriManager.ConcatUri process(Uri uri) {
            throw new UnsupportedOperationException();
        }
    }
}

