/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.CaptureRewriter;
import org.apache.shindig.gadgets.rewrite.DefaultResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultContentRewriterRegistryTest
extends BaseRewriterTestCase {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/gadget.xml");
    private List<CaptureRewriter> rewriters;
    private List<ResponseRewriter> contentRewriters;
    private ResponseRewriterRegistry registry;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rewriters = Lists.newArrayList((Object[])new CaptureRewriter[]{new CaptureRewriter(), new CaptureRewriter()});
        this.contentRewriters = Lists.newArrayList(this.rewriters);
        this.registry = new DefaultResponseRewriterRegistry(this.contentRewriters, this.parser);
    }

    @Test
    public void testRewriteHttpResponse() throws Exception {
        String body = "Hello, world";
        HttpRequest request = new HttpRequest(SPEC_URL);
        HttpResponse response = new HttpResponse(body);
        HttpResponse rewritten = this.registry.rewriteHttpResponse(request, response);
        Assert.assertTrue((String)"First rewriter not invoked.", (boolean)this.rewriters.get(0).responseWasRewritten());
        Assert.assertTrue((String)"Second rewriter not invoked.", (boolean)this.rewriters.get(1).responseWasRewritten());
        Assert.assertEquals((Object)response, (Object)rewritten);
    }

    @Test
    public void testNoDecodeHttpResponseForUnRewriteableMimeTypes() throws Exception {
        ArrayList rewriters = Lists.newArrayList();
        rewriters.add(new ResponseRewriter(){

            public void rewrite(HttpRequest request, HttpResponseBuilder response) throws RewritingException {
            }
        });
        this.registry = new DefaultResponseRewriterRegistry((List)rewriters, this.parser);
        HttpRequest req = (HttpRequest)this.control.createMock(HttpRequest.class);
        EasyMock.expect((Object)req.getRewriteMimeType()).andStubReturn((Object)"unknown");
        this.control.replay();
        HttpResponse rewritten = this.registry.rewriteHttpResponse(req, this.fakeResponse.create());
        Assert.assertSame((Object)rewritten, (Object)this.fakeResponse.create());
        this.control.verify();
    }
}

