/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.image.BaseOptimizerTest;
import org.apache.shindig.gadgets.rewrite.image.GIFOptimizer;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;
import org.junit.Test;

public class GIFOptimizerTest
extends BaseOptimizerTest {
    @Test
    public void testEfficientGIF() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/unanimated.gif", "image/gif");
        HttpResponse httpResponse = this.rewrite(resp);
        GIFOptimizerTest.assertSame((Object)resp, (Object)httpResponse);
    }

    @Test
    public void testBadPaletteGIFToPNG() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/large.gif", "image/gif");
        HttpResponse httpResponse = this.rewrite(resp);
        GIFOptimizerTest.assertTrue((httpResponse.getContentLength() <= resp.getContentLength() ? 1 : 0) != 0);
        GIFOptimizerTest.assertEquals((Object)"image/png", (Object)httpResponse.getHeader("Content-Type"));
    }

    @Test
    public void testDirectColorModelGif() throws Exception {
        HttpResponse resp = this.createResponse("org/apache/shindig/gadgets/rewrite/image/directcolor.gif", "image/gif");
        HttpResponse httpResponse = this.rewrite(resp);
        GIFOptimizerTest.assertTrue((httpResponse.getContentLength() <= resp.getContentLength() ? 1 : 0) != 0);
        GIFOptimizerTest.assertEquals((Object)"image/gif", (Object)httpResponse.getHeader("Content-Type"));
    }

    protected HttpResponse rewrite(HttpResponse original) throws IOException, ImageReadException {
        HttpResponseBuilder builder = new HttpResponseBuilder(original);
        new GIFOptimizer(new OptimizerConfig(), builder).rewrite(Sanselan.getBufferedImage((InputStream)original.getResponse()));
        return builder.create();
    }
}

