/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.servlet.HttpServletResponseRecorder;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.render.Renderer;
import org.apache.shindig.gadgets.render.RenderingResults;
import org.apache.shindig.gadgets.servlet.GadgetRenderingServlet;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GadgetRenderingServletTest {
    private static final String NON_ASCII_STRING = "Games, HQ, Mang\u00e1, Anime e tudo que um bom nerd ama";
    private final IMocksControl control = EasyMock.createNiceControl();
    private final HttpServletRequest request = GadgetRenderingServletTest.makeRequestMock(this);
    private final HttpServletResponse response = (HttpServletResponse)this.control.createMock(HttpServletResponse.class);
    private final Renderer renderer = (Renderer)this.control.createMock(Renderer.class);
    public final HttpServletResponseRecorder recorder = new HttpServletResponseRecorder(this.response);
    private final GadgetRenderingServlet servlet = new GadgetRenderingServlet();
    private final IframeUriManager iframeUriManager = (IframeUriManager)this.control.createMock(IframeUriManager.class);

    @Before
    public void setUpUrlGenerator() {
        EasyMock.expect((Object)this.iframeUriManager.validateRenderingUri((Uri)EasyMock.isA(Uri.class))).andReturn((Object)UriStatus.VALID_UNVERSIONED);
        EasyMock.expect((Object)this.request.getRequestURL()).andReturn((Object)new StringBuffer("http://foo.com"));
        EasyMock.expect((Object)this.request.getQueryString()).andReturn((Object)"?q=a");
        this.servlet.setIframeUriManager(this.iframeUriManager);
    }

    @Test
    public void dosHeaderRejected() throws Exception {
        EasyMock.expect((Object)this.request.getHeader("X-shindig-dos")).andReturn((Object)"foo");
        this.control.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        Assert.assertEquals((long)403L, (long)this.recorder.getHttpStatusCode());
    }

    @Test
    public void renderWithTtl() throws Exception {
        this.servlet.setRenderer(this.renderer);
        EasyMock.expect((Object)this.renderer.render((GadgetContext)EasyMock.isA(GadgetContext.class))).andReturn((Object)RenderingResults.ok((String)"working"));
        EasyMock.expect((Object)this.request.getParameter(UriCommon.Param.REFRESH.getKey())).andReturn((Object)"120");
        this.control.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        Assert.assertEquals((Object)"private,max-age=120", (Object)this.recorder.getHeader("Cache-Control"));
    }

    @Test
    public void renderWithBadTtl() throws Exception {
        this.servlet.setRenderer(this.renderer);
        EasyMock.expect((Object)this.renderer.render((GadgetContext)EasyMock.isA(GadgetContext.class))).andReturn((Object)RenderingResults.ok((String)"working"));
        EasyMock.expect((Object)this.request.getParameter(UriCommon.Param.REFRESH.getKey())).andReturn((Object)"");
        this.control.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        Assert.assertEquals((Object)"private,max-age=300", (Object)this.recorder.getHeader("Cache-Control"));
    }

    @Test
    public void normalResponse() throws Exception {
        this.servlet.setRenderer(this.renderer);
        EasyMock.expect((Object)this.renderer.render((GadgetContext)EasyMock.isA(GadgetContext.class))).andReturn((Object)RenderingResults.ok((String)"working"));
        this.control.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        Assert.assertEquals((long)200L, (long)this.recorder.getHttpStatusCode());
        Assert.assertEquals((Object)"private,max-age=300", (Object)this.recorder.getHeader("Cache-Control"));
        Assert.assertEquals((Object)"working", (Object)this.recorder.getResponseAsString());
    }

    @Test
    public void errorsPassedThrough() throws Exception {
        this.servlet.setRenderer(this.renderer);
        EasyMock.expect((Object)this.renderer.render((GadgetContext)EasyMock.isA(GadgetContext.class))).andReturn((Object)RenderingResults.error((String)"busted", (int)500));
        this.control.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        Assert.assertEquals((long)500L, (long)this.recorder.getHttpStatusCode());
        Assert.assertNull((String)"Cache-Control header passed where it should not be.", (Object)this.recorder.getHeader("Cache-Control"));
        Assert.assertEquals((Object)"busted", (Object)this.recorder.getResponseAsString());
    }

    @Test
    public void errorsAreEscaped() throws Exception {
        this.servlet.setRenderer(this.renderer);
        EasyMock.expect((Object)this.renderer.render((GadgetContext)EasyMock.isA(GadgetContext.class))).andReturn((Object)RenderingResults.error((String)"busted<script>alert(document.domain)</script>", (int)500));
        this.control.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        Assert.assertEquals((Object)"busted&lt;script&gt;alert(document.domain)&lt;/script&gt;", (Object)this.recorder.getResponseAsString());
        Assert.assertEquals((long)500L, (long)this.recorder.getHttpStatusCode());
    }

    @Test
    public void outputEncodingIsUtf8() throws Exception {
        this.servlet.setRenderer(this.renderer);
        EasyMock.expect((Object)this.renderer.render((GadgetContext)EasyMock.isA(GadgetContext.class))).andReturn((Object)RenderingResults.ok((String)NON_ASCII_STRING));
        this.control.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        Assert.assertEquals((Object)"UTF-8", (Object)this.recorder.getCharacterEncoding());
        Assert.assertEquals((Object)"text/html", (Object)this.recorder.getContentType());
        Assert.assertEquals((Object)NON_ASCII_STRING, (Object)this.recorder.getResponseAsString());
    }

    @Test
    public void refreshParameter_specified() throws Exception {
        this.servlet.setRenderer(this.renderer);
        EasyMock.expect((Object)this.request.getParameter("refresh")).andReturn((Object)"1000");
        EasyMock.expect((Object)this.renderer.render((GadgetContext)EasyMock.isA(GadgetContext.class))).andReturn((Object)RenderingResults.ok((String)"working"));
        this.control.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        Assert.assertEquals((Object)"private,max-age=1000", (Object)this.recorder.getHeader("Cache-Control"));
    }

    @Test
    public void refreshParameter_default() throws Exception {
        this.servlet.setRenderer(this.renderer);
        EasyMock.expect((Object)this.renderer.render((GadgetContext)EasyMock.isA(GadgetContext.class))).andReturn((Object)RenderingResults.ok((String)"working"));
        this.control.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        Assert.assertEquals((Object)"private,max-age=300", (Object)this.recorder.getHeader("Cache-Control"));
    }

    private static HttpServletRequest makeRequestMock(GadgetRenderingServletTest testcase) {
        HttpServletRequest req = (HttpServletRequest)testcase.control.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getScheme()).andReturn((Object)"http").anyTimes();
        EasyMock.expect((Object)req.getServerPort()).andReturn((Object)80).anyTimes();
        EasyMock.expect((Object)req.getServerName()).andReturn((Object)"example.com").anyTimes();
        EasyMock.expect((Object)req.getRequestURI()).andReturn((Object)"/path").anyTimes();
        return req;
    }
}

