/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.shindig.common.testing.TestExecutorService;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.servlet.FakeIframeUriManager;
import org.apache.shindig.gadgets.servlet.FakeProcessor;
import org.apache.shindig.gadgets.servlet.JsonRpcHandler;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonRpcHandlerTest {
    private final FakeProcessor processor = new FakeProcessor();
    private final FakeIframeUriManager urlGenerator = new FakeIframeUriManager();
    private final JsonRpcHandler jsonRpcHandler = new JsonRpcHandler((ExecutorService)new TestExecutorService(), (Processor)this.processor, (IframeUriManager)this.urlGenerator);

    private JSONObject createContext(String lang, String country) throws JSONException {
        return new JSONObject().put("language", (Object)lang).put("country", (Object)country);
    }

    private JSONObject createGadget(String url, int moduleId, Map<String, String> prefs) throws JSONException {
        return new JSONObject().put("url", (Object)url).put("moduleId", moduleId).put("prefs", prefs == null ? Collections.emptySet() : prefs);
    }

    @Test
    public void testSimpleRequest() throws Exception {
        JSONArray gadgets = new JSONArray().put((Object)this.createGadget(FakeProcessor.SPEC_URL.toString(), 0, null));
        JSONObject input = new JSONObject().put("context", (Object)this.createContext("en", "US")).put("gadgets", (Object)gadgets);
        this.urlGenerator.iframeUrl = FakeProcessor.SPEC_URL;
        JSONObject response = this.jsonRpcHandler.process(input);
        JSONArray outGadgets = response.getJSONArray("gadgets");
        JSONObject gadget = outGadgets.getJSONObject(0);
        Assert.assertEquals((Object)FakeProcessor.SPEC_URL.toString(), (Object)gadget.getString("iframeUrl"));
        Assert.assertEquals((Object)"JSON-TEST", (Object)gadget.getString("title"));
        Assert.assertEquals((long)0L, (long)gadget.getInt("moduleId"));
        JSONObject view = gadget.getJSONObject("views").getJSONObject("default");
        Assert.assertEquals((long)100L, (long)view.getInt("preferredHeight"));
        Assert.assertEquals((long)242L, (long)view.getInt("preferredWidth"));
        Assert.assertEquals((Object)"http://example.org/foo", (Object)gadget.getJSONObject("links").getString("rel"));
        JSONObject userPrefs = gadget.getJSONObject("userPrefs");
        Assert.assertNotNull((Object)userPrefs);
        JSONObject userPrefData = userPrefs.getJSONObject("up_one");
        Assert.assertNotNull((Object)userPrefData);
        JSONObject upEnums = userPrefData.getJSONObject("enumValues");
        Assert.assertNotNull((Object)upEnums);
        Assert.assertEquals((Object)"disp1", (Object)upEnums.get("val1"));
        Assert.assertEquals((Object)"disp2", (Object)upEnums.get("abc"));
        Assert.assertEquals((Object)"disp3", (Object)upEnums.get("z_xabc"));
        Assert.assertEquals((Object)"disp4", (Object)upEnums.get("foo"));
        JSONArray orderedEnums = userPrefData.getJSONArray("orderedEnumValues");
        Assert.assertNotNull((Object)orderedEnums);
        Assert.assertEquals((long)4L, (long)orderedEnums.length());
        Assert.assertEquals((Object)"val1", (Object)orderedEnums.getJSONObject(0).getString("value"));
        Assert.assertEquals((Object)"abc", (Object)orderedEnums.getJSONObject(1).getString("value"));
        Assert.assertEquals((Object)"z_xabc", (Object)orderedEnums.getJSONObject(2).getString("value"));
        Assert.assertEquals((Object)"foo", (Object)orderedEnums.getJSONObject(3).getString("value"));
    }

    @Test
    public void testUnexpectedError() throws Exception {
        JSONArray gadgets = new JSONArray().put((Object)this.createGadget(FakeProcessor.SPEC_URL.toString(), 0, null));
        JSONObject input = new JSONObject().put("context", (Object)this.createContext("en", "US")).put("gadgets", (Object)gadgets);
        this.urlGenerator.throwRandomFault = true;
        JSONObject resp = this.jsonRpcHandler.process(input);
        String actual = resp.getJSONArray("gadgets").getJSONObject(0).getJSONArray("errors").getString(0);
        Assert.assertEquals((Object)"BROKEN", (Object)actual);
    }

    @Test
    public void testMultipleGadgets() throws Exception {
        JSONArray gadgets = new JSONArray().put((Object)this.createGadget(FakeProcessor.SPEC_URL.toString(), 0, null)).put((Object)this.createGadget(FakeProcessor.SPEC_URL2.toString(), 1, null));
        JSONObject input = new JSONObject().put("context", (Object)this.createContext("en", "US")).put("gadgets", (Object)gadgets);
        JSONObject response = this.jsonRpcHandler.process(input);
        JSONArray outGadgets = response.getJSONArray("gadgets");
        boolean first = false;
        boolean second = false;
        int j = outGadgets.length();
        for (int i = 0; i < j; ++i) {
            JSONObject gadget = outGadgets.getJSONObject(i);
            if (gadget.getString("url").equals(FakeProcessor.SPEC_URL.toString())) {
                Assert.assertEquals((Object)"JSON-TEST", (Object)gadget.getString("title"));
                Assert.assertEquals((long)0L, (long)gadget.getInt("moduleId"));
                first = true;
                continue;
            }
            Assert.assertEquals((Object)"JSON-TEST2", (Object)gadget.getString("title"));
            Assert.assertEquals((long)1L, (long)gadget.getInt("moduleId"));
            second = true;
        }
        Assert.assertTrue((String)"First gadget not returned!", (boolean)first);
        Assert.assertTrue((String)"Second gadget not returned!", (boolean)second);
    }

    @Test
    public void testMultipleGadgetsWithAnError() throws Exception {
        JSONArray gadgets = new JSONArray().put((Object)this.createGadget(FakeProcessor.SPEC_URL.toString(), 0, null)).put((Object)this.createGadget(FakeProcessor.SPEC_URL2.toString(), 1, null));
        JSONObject input = new JSONObject().put("context", (Object)this.createContext("en", "US")).put("gadgets", (Object)gadgets);
        this.processor.exceptions.put(FakeProcessor.SPEC_URL2, new ProcessingException("broken", 400));
        JSONObject response = this.jsonRpcHandler.process(input);
        JSONArray outGadgets = response.getJSONArray("gadgets");
        boolean first = false;
        boolean second = false;
        int j = outGadgets.length();
        for (int i = 0; i < j; ++i) {
            JSONObject gadget = outGadgets.getJSONObject(i);
            if (gadget.getString("url").equals(FakeProcessor.SPEC_URL.toString())) {
                Assert.assertEquals((Object)"JSON-TEST", (Object)gadget.getString("title"));
                Assert.assertEquals((long)0L, (long)gadget.getInt("moduleId"));
                first = true;
                continue;
            }
            JSONArray errors = gadget.getJSONArray("errors");
            Assert.assertEquals((long)1L, (long)errors.length());
            Assert.assertEquals((Object)"broken", (Object)errors.optString(0));
            second = true;
        }
        Assert.assertTrue((String)"First gadget not returned!", (boolean)first);
        Assert.assertTrue((String)"Second gadget not returned!", (boolean)second);
    }
}

