/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.rewrite.CaptureRewriter;
import org.apache.shindig.gadgets.rewrite.DefaultResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.servlet.ProxyHandler;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyHandlerTest
extends EasyMockTestCase {
    private static final String URL_ONE = "http://www.example.org/test.html";
    private static final String DATA_ONE = "hello world";
    public final RequestPipeline pipeline = (RequestPipeline)this.mock(RequestPipeline.class);
    public CaptureRewriter rewriter = new CaptureRewriter();
    public ResponseRewriterRegistry rewriterRegistry = new DefaultResponseRewriterRegistry(Arrays.asList(this.rewriter), null);
    private ProxyUriManager.ProxyUri request;
    private final ProxyHandler proxyHandler = new ProxyHandler(this.pipeline, this.rewriterRegistry, Boolean.valueOf(true));

    private void expectGetAndReturnData(String url, byte[] data) throws Exception {
        HttpRequest req = new HttpRequest(Uri.parse((String)url));
        HttpResponse resp = new HttpResponseBuilder().setResponse(data).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp);
    }

    private void expectGetAndReturnHeaders(String url, Map<String, List<String>> headers) throws Exception {
        HttpRequest req = new HttpRequest(Uri.parse((String)url));
        HttpResponse resp = new HttpResponseBuilder().addAllHeaders(headers).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp);
    }

    private void setupProxyRequestMock(String host, String url, boolean noCache, int refresh, String rewriteMime, String fallbackUrl) throws Exception {
        this.request = new ProxyUriManager.ProxyUri(Integer.valueOf(refresh), false, noCache, "default", null, Uri.parse((String)url));
        this.request.setFallbackUrl(fallbackUrl);
        this.request.setRewriteMimeType(rewriteMime);
    }

    private void setupNoArgsProxyRequestMock(String host, String url) throws Exception {
        this.request = new ProxyUriManager.ProxyUri(Integer.valueOf(-1), false, false, "default", null, url != null ? Uri.parse((String)url) : null);
    }

    private ResponseRewriter getResponseRewriterThatThrowsExceptions(final StringBuilder stringBuilder) {
        return new DomWalker.Rewriter(){

            public void rewrite(Gadget gadget, MutableContent content) throws RewritingException {
                stringBuilder.append("exceptionThrown");
                throw new RewritingException("sad", 404);
            }

            public void rewrite(HttpRequest request, HttpResponseBuilder builder) throws RewritingException {
                stringBuilder.append("exceptionThrown");
                throw new RewritingException("sad", 404);
            }
        };
    }

    @Test
    public void testInvalidHeaderDropped() throws Exception {
        String url = "http://example.org/mypage.html";
        String domain = "example.org";
        this.setupProxyRequestMock(domain, url, true, -1, null, null);
        HttpRequest req = new HttpRequest(Uri.parse((String)url)).setIgnoreCache(true);
        String contentType = "text/html; charset=UTF-8";
        HttpResponse resp = new HttpResponseBuilder().setResponseString("Hello").addHeader("Content-Type", contentType).addHeader("Content-Length", "200").addHeader(":", "someDummyValue").create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp);
        this.replay();
        HttpResponse recorder = this.proxyHandler.fetch(this.request);
        this.verify();
        ProxyHandlerTest.assertNull((Object)recorder.getHeader(":"));
        ProxyHandlerTest.assertNull((Object)recorder.getHeader("Content-Length"));
        ProxyHandlerTest.assertEquals((Object)recorder.getHeader("Content-Type"), (Object)contentType);
    }

    @Test
    public void testLockedDomainEmbed() throws Exception {
        this.setupNoArgsProxyRequestMock("www.example.com", URL_ONE);
        this.expectGetAndReturnData(URL_ONE, DATA_ONE.getBytes());
        this.replay();
        HttpResponse response = this.proxyHandler.fetch(this.request);
        this.verify();
        ProxyHandlerTest.assertEquals((Object)DATA_ONE, (Object)response.getResponseAsString());
        ProxyHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test(expected=GadgetException.class)
    public void testNoUrl() throws Exception {
        this.setupNoArgsProxyRequestMock("www.example.com", null);
        this.replay();
        this.proxyHandler.fetch(this.request);
        ProxyHandlerTest.fail((String)"Proxy should raise exception if there is no url");
    }

    @Test
    public void testHttpRequestFillsParentAndContainer() throws Exception {
        this.setupNoArgsProxyRequestMock("www.example.com", URL_ONE);
        HttpResponse resp = new HttpResponseBuilder().setResponse(DATA_ONE.getBytes()).create();
        Capture httpRequest = new Capture();
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.capture((Capture)httpRequest))).andReturn((Object)resp);
        this.replay();
        HttpResponse response = this.proxyHandler.fetch(this.request);
        this.verify();
        ProxyHandlerTest.assertEquals((Object)"default", (Object)((HttpRequest)httpRequest.getValue()).getContainer());
        ProxyHandlerTest.assertEquals((Object)Uri.parse((String)URL_ONE), (Object)((HttpRequest)httpRequest.getValue()).getUri());
        ProxyHandlerTest.assertEquals((Object)DATA_ONE, (Object)response.getResponseAsString());
        ProxyHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testHeadersPreserved() throws Exception {
        String url = "http://example.org/file.evil";
        String domain = "example.org";
        String contentType = "text/evil; charset=UTF-8";
        String magicGarbage = "fadfdfdfd";
        HashMap headers = Maps.newHashMap();
        headers.put("Content-Type", Arrays.asList(contentType));
        headers.put("X-Magic-Garbage", Arrays.asList(magicGarbage));
        this.setupNoArgsProxyRequestMock(domain, url);
        this.expectGetAndReturnHeaders(url, headers);
        this.replay();
        HttpResponse response = this.proxyHandler.fetch(this.request);
        this.verify();
        ProxyHandlerTest.assertEquals((Object)contentType, (Object)response.getHeader("Content-Type"));
        ProxyHandlerTest.assertEquals((Object)magicGarbage, (Object)response.getHeader("X-Magic-Garbage"));
        ProxyHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testOctetSetOnNullContentType() throws Exception {
        String url = "http://example.org/file.evil";
        String domain = "example.org";
        this.setupNoArgsProxyRequestMock(domain, url);
        this.expectGetAndReturnHeaders(url, Maps.newHashMap());
        this.replay();
        HttpResponse response = this.proxyHandler.fetch(this.request);
        this.verify();
        ProxyHandlerTest.assertEquals((Object)"application/octet-stream", (Object)response.getHeader("Content-Type"));
        ProxyHandlerTest.assertNotNull((Object)response.getHeader("Content-Disposition"));
        ProxyHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testNoContentDispositionForFlash() throws Exception {
        this.assertNoContentDispositionForFlash("application/x-shockwave-flash");
    }

    @Test
    public void testNoContentDispositionForFlashUtf8() throws Exception {
        this.assertNoContentDispositionForFlash("application/x-shockwave-flash;charset=utf-8");
    }

    private void assertNoContentDispositionForFlash(String contentType) throws Exception {
        String url = "http://example.org/file.evil";
        String domain = "example.org";
        ImmutableMap headers = ImmutableMap.of((Object)"Content-Type", Arrays.asList(contentType));
        this.setupNoArgsProxyRequestMock(domain, url);
        this.expectGetAndReturnHeaders(url, (Map<String, List<String>>)headers);
        this.replay();
        HttpResponse response = this.proxyHandler.fetch(this.request);
        this.verify();
        ProxyHandlerTest.assertEquals((Object)contentType, (Object)response.getHeader("Content-Type"));
        ProxyHandlerTest.assertNull((Object)response.getHeader("Content-Disposition"));
        ProxyHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testGetFallback() throws Exception {
        String url = "http://example.org/file.evil";
        String domain = "example.org";
        String fallback_url = "http://fallback.com/fallback.png";
        this.setupProxyRequestMock(domain, url, true, -1, null, fallback_url);
        HttpRequest req = new HttpRequest(Uri.parse((String)url)).setIgnoreCache(true);
        HttpResponse resp = HttpResponse.error();
        HttpResponse fallback_resp = new HttpResponse("Fallback");
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp);
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn((Object)fallback_resp);
        this.replay();
        this.proxyHandler.fetch(this.request);
        this.verify();
    }

    @Test
    public void testNoCache() throws Exception {
        String url = "http://example.org/file.evil";
        String domain = "example.org";
        this.setupProxyRequestMock(domain, url, true, -1, null, null);
        HttpRequest req = new HttpRequest(Uri.parse((String)url)).setIgnoreCache(true);
        HttpResponse resp = new HttpResponse("Hello");
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp);
        this.replay();
        this.proxyHandler.fetch(this.request);
        this.verify();
    }

    @Test
    public void testRecoverableRewritingException() throws Exception {
        String url = "http://example.org/mypage.html";
        String domain = "example.org";
        this.setupProxyRequestMock(domain, url, true, -1, null, null);
        String contentType = "text/html; charset=UTF-8";
        HttpResponse resp = new HttpResponseBuilder().setResponseString("Hello").addHeader("Content-Type", contentType).create();
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.anyObject())).andReturn((Object)resp);
        this.replay();
        StringBuilder stringBuilder = new StringBuilder("");
        ResponseRewriter rewriter = this.getResponseRewriterThatThrowsExceptions(stringBuilder);
        DefaultResponseRewriterRegistry rewriterRegistry = new DefaultResponseRewriterRegistry(Arrays.asList(rewriter), null);
        ProxyHandler proxyHandler = new ProxyHandler(this.pipeline, (ResponseRewriterRegistry)rewriterRegistry, Boolean.valueOf(true));
        this.request.setReturnOriginalContentOnError(true);
        HttpResponse recorder = proxyHandler.fetch(this.request);
        this.verify();
        ProxyHandlerTest.assertEquals((Object)recorder.getHeader("Content-Type"), (Object)contentType);
        ProxyHandlerTest.assertEquals((Object)"Hello", (Object)recorder.getResponseAsString());
        ProxyHandlerTest.assertEquals((Object)"exceptionThrown", (Object)stringBuilder.toString());
    }

    @Test
    public void testThrowExceptionIfReturnOriginalContentOnErrorNotSet() throws Exception {
        String url = "http://example.org/mypage.html";
        String domain = "example.org";
        this.setupProxyRequestMock(domain, url, true, -1, null, null);
        String contentType = "text/html; charset=UTF-8";
        HttpResponse resp = new HttpResponseBuilder().setResponseString("Hello").addHeader("Content-Type", contentType).create();
        EasyMock.expect((Object)this.pipeline.execute((HttpRequest)EasyMock.anyObject())).andReturn((Object)resp);
        this.replay();
        StringBuilder stringBuilder = new StringBuilder("");
        ResponseRewriter rewriter = this.getResponseRewriterThatThrowsExceptions(stringBuilder);
        DefaultResponseRewriterRegistry rewriterRegistry = new DefaultResponseRewriterRegistry(Arrays.asList(rewriter), null);
        ProxyHandler proxyHandler = new ProxyHandler(this.pipeline, (ResponseRewriterRegistry)rewriterRegistry, Boolean.valueOf(true));
        boolean exceptionCaught = false;
        try {
            proxyHandler.fetch(this.request);
        }
        catch (GadgetException e) {
            exceptionCaught = true;
            ProxyHandlerTest.assertEquals((long)404L, (long)e.getHttpStatusCode());
        }
        ProxyHandlerTest.assertTrue((boolean)exceptionCaught);
        ProxyHandlerTest.assertEquals((Object)"exceptionThrown", (Object)stringBuilder.toString());
    }

    @Test
    public void testWithCache() throws Exception {
        String url = "http://example.org/file.evil";
        String domain = "example.org";
        this.setupProxyRequestMock(domain, url, false, 120, null, null);
        HttpRequest req = new HttpRequestCache(Uri.parse((String)url)).setCacheTtl(120).setIgnoreCache(false);
        HttpResponse resp = new HttpResponse("Hello");
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp);
        this.replay();
        this.proxyHandler.fetch(this.request);
        this.verify();
    }

    @Test
    public void testWithBadTtl() throws Exception {
        String url = "http://example.org/file.evil";
        String domain = "example.org";
        this.setupProxyRequestMock(domain, url, false, -1, null, null);
        HttpRequest req = new HttpRequestCache(Uri.parse((String)url)).setCacheTtl(-1).setIgnoreCache(false);
        HttpResponse resp = new HttpResponse("Hello");
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp);
        this.replay();
        this.proxyHandler.fetch(this.request);
        this.verify();
    }

    private void expectMime(String expectedMime, String contentMime, String outputMime) throws Exception {
        String url = "http://example.org/file.img?" + UriCommon.Param.REWRITE_MIME_TYPE.getKey() + '=' + expectedMime;
        String domain = "example.org";
        this.setupProxyRequestMock(domain, url, false, -1, expectedMime, null);
        HttpRequest req = new HttpRequest(Uri.parse((String)url)).setRewriteMimeType(expectedMime);
        HttpResponse resp = new HttpResponseBuilder().setResponseString("Hello").addHeader("Content-Type", contentMime).create();
        EasyMock.expect((Object)this.pipeline.execute(req)).andReturn((Object)resp);
        this.replay();
        HttpResponse response = this.proxyHandler.fetch(this.request);
        this.verify();
        ProxyHandlerTest.assertEquals((Object)outputMime, (Object)response.getHeader("Content-Type"));
        this.reset();
    }

    @Test
    public void testMimeMatchPass() throws Exception {
        this.expectMime("text/css", "text/css", "text/css; charset=UTF-8");
    }

    @Test
    public void testMimeMatchPassWithAdditionalAttributes() throws Exception {
        this.expectMime("text/css", "text/css", "text/css; charset=UTF-8");
    }

    @Test
    public void testMimeMatchOverrideNonMatch() throws Exception {
        this.expectMime("text/css", "image/png", "text/css; charset=UTF-8");
    }

    @Test
    public void testMimeMatchVarySupport() throws Exception {
        this.expectMime("image/*", "image/gif", "image/gif");
    }

    static class HttpRequestCache
    extends HttpRequest {
        public HttpRequestCache(Uri uri) {
            super(uri);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof HttpRequest)) {
                return false;
            }
            HttpRequest req = (HttpRequest)obj;
            return super.equals(obj) && req.getCacheTtl() == this.getCacheTtl() && req.getIgnoreCache() == this.getIgnoreCache();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.getCacheTtl(), this.getIgnoreCache()});
        }
    }
}

