/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import javax.servlet.http.HttpServletResponse;
import junitx.framework.StringAssert;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.servlet.ProxyHandler;
import org.apache.shindig.gadgets.servlet.ProxyServlet;
import org.apache.shindig.gadgets.servlet.ServletTestFixture;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class ProxyServletTest
extends ServletTestFixture {
    private static final Uri REQUEST_URL = Uri.parse((String)"http://example.org/file");
    private static final String BASIC_SYNTAX_URL = "http://opensocial.org/proxy?foo=bar&url=" + REQUEST_URL;
    private static final String RESPONSE_BODY = "Hello, world!";
    private static final String ERROR_MESSAGE = "Broken!";
    private final ProxyUriManager proxyUriManager = (ProxyUriManager)this.mock(ProxyUriManager.class);
    private final LockedDomainService lockedDomainService = (LockedDomainService)this.mock(LockedDomainService.class);
    private final ProxyHandler proxyHandler = (ProxyHandler)this.mock(ProxyHandler.class);
    private final ProxyServlet servlet = new ProxyServlet();
    private final ProxyUriManager.ProxyUri proxyUri = (ProxyUriManager.ProxyUri)this.mock(ProxyUriManager.ProxyUri.class);

    @Before
    public void setUp() throws Exception {
        this.servlet.setProxyHandler(this.proxyHandler);
        this.servlet.setProxyUriManager(this.proxyUriManager);
        this.servlet.setLockedDomainService(this.lockedDomainService);
    }

    private void setupRequest(String str) throws Exception {
        this.setupRequest(str, true);
    }

    private void setupRequest(String str, boolean ldSafe) throws Exception {
        Uri uri = Uri.parse((String)str);
        EasyMock.expect((Object)this.request.getScheme()).andReturn((Object)uri.getScheme());
        EasyMock.expect((Object)this.request.getServerName()).andReturn((Object)uri.getAuthority());
        EasyMock.expect((Object)this.request.getServerPort()).andReturn((Object)80);
        EasyMock.expect((Object)this.request.getRequestURI()).andReturn((Object)uri.getPath());
        EasyMock.expect((Object)this.request.getQueryString()).andReturn((Object)uri.getQuery());
        EasyMock.expect((Object)this.request.getHeader("Host")).andReturn((Object)uri.getAuthority());
        EasyMock.expect((Object)this.proxyUriManager.process(uri)).andReturn((Object)this.proxyUri);
        EasyMock.expect((Object)this.lockedDomainService.isSafeForOpenProxy(uri.getAuthority())).andReturn((Object)ldSafe);
    }

    private void assertResponseOk(int expectedStatus, String expectedBody) {
        ProxyServletTest.assertEquals((long)expectedStatus, (long)this.recorder.getHttpStatusCode());
        ProxyServletTest.assertEquals((Object)expectedBody, (Object)this.recorder.getResponseAsString());
    }

    @Test
    public void testIfModifiedSinceAlwaysReturnsEarly() throws Exception {
        EasyMock.expect((Object)this.request.getHeader("If-Modified-Since")).andReturn((Object)"Yes, this is an invalid header");
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        ProxyServletTest.assertEquals((long)304L, (long)this.recorder.getHttpStatusCode());
        ProxyServletTest.assertFalse((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testDoGetNormal() throws Exception {
        this.setupRequest(BASIC_SYNTAX_URL);
        EasyMock.expect((Object)this.proxyHandler.fetch(this.proxyUri)).andReturn((Object)new HttpResponse(RESPONSE_BODY));
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        this.assertResponseOk(200, RESPONSE_BODY);
    }

    @Test
    public void testDoGetHttpError() throws Exception {
        this.setupRequest(BASIC_SYNTAX_URL);
        EasyMock.expect((Object)this.proxyHandler.fetch(this.proxyUri)).andReturn((Object)HttpResponse.notFound());
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        this.assertResponseOk(404, "");
    }

    @Test
    public void testDoGetException() throws Exception {
        this.setupRequest(BASIC_SYNTAX_URL);
        EasyMock.expect((Object)this.proxyHandler.fetch(this.proxyUri)).andThrow((Throwable)new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, ERROR_MESSAGE));
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        ProxyServletTest.assertEquals((long)400L, (long)this.recorder.getHttpStatusCode());
        StringAssert.assertContains((String)ERROR_MESSAGE, (String)this.recorder.getResponseAsString());
    }

    @Test
    public void testDoGetNormalWithLockedDomainUnsafe() throws Exception {
        this.setupRequest(BASIC_SYNTAX_URL, false);
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        ProxyServletTest.assertEquals((long)400L, (long)this.recorder.getHttpStatusCode());
        StringAssert.assertContains((String)"wrong domain", (String)this.recorder.getResponseAsString());
    }
}

