/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.OAuthService;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OAuthServiceTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/g.xml");
    private OAuthService service;

    @Before
    public void setUp() {
        this.service = new OAuthService();
    }

    @Test
    public void testParseAuthorizeUrl() throws Exception {
        String xml = "<Authorization url='http://azn.example.com'/>";
        Uri url = this.service.parseAuthorizationUrl(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)"http://azn.example.com", (Object)url.toString());
    }

    @Test(expected=SpecParserException.class)
    public void testParseAuthorizeUrl_nourl() throws Exception {
        String xml = "<Authorization/>";
        this.service.parseAuthorizationUrl(XmlUtil.parse((String)xml), SPEC_URL);
    }

    @Test
    public void testParseAuthorizeUrl_extraAttr() throws Exception {
        String xml = "<Authorization url='http://www.example.com' foo='bar'/>";
        Uri url = this.service.parseAuthorizationUrl(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)"http://www.example.com", (Object)url.toString());
    }

    @Test
    public void testParseAuthorizeUrl_notHttp() throws Exception {
        OAuthService service = new OAuthService();
        String xml = "<Authorization url='ftp://www.example.com'/>";
        try {
            service.parseAuthorizationUrl(XmlUtil.parse((String)xml), SPEC_URL);
            Assert.fail((String)"Should have rejected malformed Authorization element");
        }
        catch (SpecParserException e) {
            Assert.assertEquals((Object)"OAuth/Service/Authorization @url is not valid: ftp://www.example.com", (Object)e.getMessage());
        }
    }

    @Test
    public void testParseEndPoint() throws Exception {
        String xml = "<Request url='http://www.example.com'/>";
        OAuthService.EndPoint ep = this.service.parseEndPoint("Request", XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)"http://www.example.com", (Object)ep.url.toString());
        Assert.assertEquals((Object)OAuthService.Location.HEADER, (Object)ep.location);
        Assert.assertEquals((Object)OAuthService.Method.GET, (Object)ep.method);
    }

    @Test
    public void testParseEndPoint_badlocation() throws Exception {
        try {
            String xml = "<Request url='http://www.example.com' method='GET' param_location='body'/>";
            this.service.parseEndPoint("Request", XmlUtil.parse((String)xml), SPEC_URL);
            Assert.fail((String)"Should have thrown");
        }
        catch (SpecParserException e) {
            Assert.assertEquals((Object)"Unknown OAuth param_location: body", (Object)e.getMessage());
        }
    }

    @Test
    public void testParseEndPoint_nodefaults() throws Exception {
        String xml = "<Request url='http://www.example.com' method='GET' param_location='post-body'/>";
        OAuthService.EndPoint ep = this.service.parseEndPoint("Request", XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)"http://www.example.com", (Object)ep.url.toString());
        Assert.assertEquals((Object)OAuthService.Location.BODY, (Object)ep.location);
        Assert.assertEquals((Object)OAuthService.Method.GET, (Object)ep.method);
    }

    @Test(expected=SpecParserException.class)
    public void testParseEndPoint_nourl() throws Exception {
        String xml = "<Request method='GET' param_location='post-body'/>";
        this.service.parseEndPoint("Request", XmlUtil.parse((String)xml), SPEC_URL);
    }

    @Test(expected=SpecParserException.class)
    public void testParseEndPoint_badurl() throws Exception {
        String xml = "<Request url='ftp://www.example.com' />";
        this.service.parseEndPoint("Request", XmlUtil.parse((String)xml), SPEC_URL);
    }

    @Test
    public void testParseService() throws Exception {
        String xml = "<Service name='thename'>   <Request url='http://request.example.com/foo'/>   <Access url='http://access.example.com/bar'/>   <Authorization url='http://azn.example.com/quux'/></Service>";
        OAuthService s = new OAuthService(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)"thename", (Object)s.getName());
        Assert.assertEquals((Object)OAuthService.Location.HEADER, (Object)s.getAccessUrl().location);
        Assert.assertEquals((Object)"http://azn.example.com/quux", (Object)s.getAuthorizationUrl().toString());
    }

    @Test
    public void testParseService_noname() throws Exception {
        String xml = "<Service>   <Request url='http://request.example.com/foo'/>   <Access url='http://access.example.com/bar'/>   <Authorization url='http://azn.example.com/quux'/></Service>";
        OAuthService s = new OAuthService(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)"", (Object)s.getName());
        Assert.assertEquals((Object)OAuthService.Location.HEADER, (Object)s.getAccessUrl().location);
        Assert.assertEquals((Object)"http://azn.example.com/quux", (Object)s.getAuthorizationUrl().toString());
    }

    @Test
    public void testParseService_nodata() throws Exception {
        String xml = "<Service/>";
        try {
            new OAuthService(XmlUtil.parse((String)xml), SPEC_URL);
        }
        catch (SpecParserException e) {
            Assert.assertEquals((Object)"/OAuth/Service/Request is required", (Object)e.getMessage());
        }
    }

    @Test
    public void testParseService_reqonly() throws Exception {
        String xml = "<Service><Request url='http://www.example.com/request'/></Service>";
        try {
            new OAuthService(XmlUtil.parse((String)xml), SPEC_URL);
        }
        catch (SpecParserException e) {
            Assert.assertEquals((Object)"/OAuth/Service/Access is required", (Object)e.getMessage());
        }
    }
}

