/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.OAuthService;
import org.apache.shindig.gadgets.spec.OAuthSpec;
import org.junit.Assert;
import org.junit.Test;

public class OAuthSpecTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/g.xml");

    @Test
    public void testOAuthSpec() throws Exception {
        String xml = "<OAuth><Service><Request url='http://www.example.com/request'/><Access url='http://www.example.com/access'/><Authorization url='http://www.example.com/authorize'/></Service></OAuth>";
        OAuthSpec oauth = new OAuthSpec(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((long)1L, (long)oauth.getServices().size());
    }

    @Test
    public void testOAuthRelativeUrl() throws Exception {
        String xml = "<OAuth><Service><Request url='/request'/><Access url='/access'/><Authorization url='/authorize'/></Service></OAuth>";
        OAuthSpec oauth = new OAuthSpec(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((long)1L, (long)oauth.getServices().size());
        OAuthService service = (OAuthService)oauth.getServices().get("");
        Assert.assertEquals((Object)service.getRequestUrl().url.toString(), (Object)"http://example.org/request");
        Assert.assertEquals((Object)service.getAuthorizationUrl().toString(), (Object)"http://example.org/authorize");
        Assert.assertEquals((Object)service.getAccessUrl().url.toString(), (Object)"http://example.org/access");
    }

    @Test
    public void testOAuthSpec_noservice() throws Exception {
        String xml = "<OAuth/>";
        OAuthSpec oauth = new OAuthSpec(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((long)0L, (long)oauth.getServices().size());
    }

    @Test
    public void testOAuthSpec_threeservice() throws Exception {
        String xml = "<OAuth><Service name='one'> <Request url='http://req.example.com' param_location='uri-query' method='POST'/> <Access url='http://acc.example.com' param_location='uri-query' method='POST'/> <Authorization url='http://azn.example.com'/></Service><Service name='two'> <Request url='http://two.example.com/req'/> <Access url='http://two.example.com'/> <Authorization url='http://two.example.com/authorize'/></Service><Service name='three'> <Request url='http://three.example.com' param_location='uri-query' method='POST'/> <Access url='http://three.example.com/acc' param_location='uri-query' method='POST'/> <Authorization url='http://three.example.com/authorize'/></Service></OAuth>";
        OAuthSpec oauth = new OAuthSpec(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)"http://req.example.com", (Object)((OAuthService)oauth.getServices().get((Object)"one")).getRequestUrl().url.toString());
        Assert.assertEquals((Object)OAuthService.Location.URL, (Object)((OAuthService)oauth.getServices().get((Object)"one")).getRequestUrl().location);
        Assert.assertEquals((Object)"http://two.example.com", (Object)((OAuthService)oauth.getServices().get((Object)"two")).getAccessUrl().url.toString());
        Assert.assertEquals((Object)OAuthService.Method.POST, (Object)((OAuthService)oauth.getServices().get((Object)"three")).getRequestUrl().method);
        Assert.assertEquals((Object)"http://three.example.com/acc", (Object)((OAuthService)oauth.getServices().get((Object)"three")).getAccessUrl().url.toJavaUri().toASCIIString());
        Assert.assertEquals((Object)"http://three.example.com/authorize", (Object)((OAuthService)oauth.getServices().get("three")).getAuthorizationUrl().toJavaUri().toASCIIString());
    }
}

