/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.shindig.auth.BasicSecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.uri.DefaultIframeUriManager;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.apache.shindig.gadgets.uri.LockedDomainPrefixGenerator;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriManagerTestBase;
import org.apache.shindig.gadgets.uri.UriStatus;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DefaultIframeUriManagerTest
extends UriManagerTestBase {
    private static final String LD_PREFIX = "LOCKED";
    private static final String IFRAME_PATH = "/gadgets/ifr";
    private static final String LD_SUFFIX = ".lockeddomain.com";
    private static final String LD_SUFFIX_ALT = ".altld.com";
    private static final String UNLOCKED_DOMAIN = "unlockeddomain.com";
    private static final int TYPE_URL_NUM_BASE_PARAMS = 6;
    private static final int TYPE_HTML_NUM_BASE_PARAMS = 7;
    private static final LockedDomainPrefixGenerator prefixGen = new LockedDomainPrefixGenerator(){

        public String getLockedDomainPrefix(Uri gadgetUri) {
            return DefaultIframeUriManagerTest.LD_PREFIX;
        }
    };
    private static final SecurityTokenCodec tokenCodec = new BasicSecurityTokenCodec();

    @Test
    public void typeHtmlBasicOptions() {
        String prefKey = "prefKey";
        String prefVal = "prefVal";
        HashMap prefs = Maps.newHashMap();
        prefs.put(prefKey, prefVal);
        ArrayList features = Lists.newArrayList();
        Gadget gadget = this.mockGadget(SPEC_URI.toString(), false, false, false, prefs, prefs, false, features);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        Uri result = manager.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)result);
        UriBuilder uri = new UriBuilder(result);
        Assert.assertEquals((Object)"", (Object)uri.getScheme());
        Assert.assertEquals((Object)UNLOCKED_DOMAIN, (Object)uri.getAuthority());
        Assert.assertEquals((Object)IFRAME_PATH, (Object)uri.getPath());
        Assert.assertEquals((Object)SPEC_URI.toString(), (Object)uri.getQueryParameter(UriCommon.Param.URL.getKey()));
        Assert.assertEquals((Object)"container", (Object)uri.getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
        Assert.assertEquals((Object)"theview", (Object)uri.getQueryParameter(UriCommon.Param.VIEW.getKey()));
        Assert.assertEquals((Object)"en", (Object)uri.getQueryParameter(UriCommon.Param.LANG.getKey()));
        Assert.assertEquals((Object)"US", (Object)uri.getQueryParameter(UriCommon.Param.COUNTRY.getKey()));
        Assert.assertEquals((Object)"0", (Object)uri.getQueryParameter(UriCommon.Param.DEBUG.getKey()));
        Assert.assertEquals((Object)"0", (Object)uri.getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
        Assert.assertEquals((Object)prefVal, (Object)uri.getFragmentParameter("up_" + prefKey));
        Assert.assertEquals((long)7L, (long)uri.getQueryParameters().size());
        Assert.assertEquals((long)1L, (long)uri.getFragmentParameters().size());
        Assert.assertFalse((boolean)manager.tokenForRenderingCalled());
        Assert.assertTrue((boolean)manager.schemeCalled());
        Assert.assertTrue((boolean)manager.ldExclusionCalled());
        Assert.assertTrue((boolean)manager.addExtrasCalled());
    }

    @Test
    public void typeHtmlBasicOptionsTpl() {
        String prefKey = "prefKey";
        String prefVal = "prefVal";
        HashMap prefs = Maps.newHashMap();
        prefs.put(prefKey, prefVal);
        ArrayList features = Lists.newArrayList();
        Gadget gadget = this.mockGadget(SPEC_URI.toString(), false, false, false, prefs, prefs, false, features);
        TestDefaultIframeUriManager managerTpl = this.makeManager(false, false);
        managerTpl.setTemplatingSignal(this.tplSignal(true));
        Uri resultTpl = managerTpl.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)resultTpl);
        UriBuilder uriTpl = new UriBuilder(resultTpl);
        Assert.assertEquals((Object)"", (Object)uriTpl.getScheme());
        Assert.assertEquals((Object)UNLOCKED_DOMAIN, (Object)uriTpl.getAuthority());
        Assert.assertEquals((Object)IFRAME_PATH, (Object)uriTpl.getPath());
        Assert.assertEquals((Object)SPEC_URI.toString(), (Object)uriTpl.getQueryParameter(UriCommon.Param.URL.getKey()));
        Assert.assertEquals((Object)"container", (Object)uriTpl.getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)UriCommon.Param.VIEW.getKey()), (Object)uriTpl.getQueryParameter(UriCommon.Param.VIEW.getKey()));
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)UriCommon.Param.LANG.getKey()), (Object)uriTpl.getQueryParameter(UriCommon.Param.LANG.getKey()));
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)UriCommon.Param.COUNTRY.getKey()), (Object)uriTpl.getQueryParameter(UriCommon.Param.COUNTRY.getKey()));
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)UriCommon.Param.DEBUG.getKey()), (Object)uriTpl.getQueryParameter(UriCommon.Param.DEBUG.getKey()));
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)UriCommon.Param.NO_CACHE.getKey()), (Object)uriTpl.getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)("up_" + prefKey)), (Object)uriTpl.getFragmentParameter("up_" + prefKey));
        Assert.assertEquals((long)7L, (long)uriTpl.getQueryParameters().size());
        Assert.assertEquals((long)1L, (long)uriTpl.getFragmentParameters().size());
        Assert.assertFalse((boolean)managerTpl.tokenForRenderingCalled());
        Assert.assertTrue((boolean)managerTpl.schemeCalled());
        Assert.assertTrue((boolean)managerTpl.ldExclusionCalled());
        Assert.assertTrue((boolean)managerTpl.addExtrasCalled());
    }

    @Test
    public void typeUrlDefaultOptions() {
        String gadgetSite = "http://example.com/gadget";
        String prefKey = "prefKey";
        String prefVal = "prefVal";
        HashMap prefs = Maps.newHashMap();
        prefs.put(prefKey, prefVal);
        ArrayList features = Lists.newArrayList();
        Gadget gadget = this.mockGadget(gadgetSite, true, true, true, prefs, prefs, false, features);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        Uri result = manager.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)result);
        UriBuilder uri = new UriBuilder(result);
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        Assert.assertEquals((Object)"example.com", (Object)uri.getAuthority());
        Assert.assertEquals((Object)"/gadget", (Object)uri.getPath());
        Assert.assertEquals((Object)"container", (Object)uri.getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
        Assert.assertEquals((Object)"theview", (Object)uri.getQueryParameter(UriCommon.Param.VIEW.getKey()));
        Assert.assertEquals((Object)"en", (Object)uri.getQueryParameter(UriCommon.Param.LANG.getKey()));
        Assert.assertEquals((Object)"US", (Object)uri.getQueryParameter(UriCommon.Param.COUNTRY.getKey()));
        Assert.assertEquals((Object)"1", (Object)uri.getQueryParameter(UriCommon.Param.DEBUG.getKey()));
        Assert.assertEquals((Object)"1", (Object)uri.getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
        Assert.assertEquals((Object)prefVal, (Object)uri.getFragmentParameter("up_" + prefKey));
        Assert.assertEquals((long)6L, (long)uri.getQueryParameters().size());
        Assert.assertEquals((long)1L, (long)uri.getFragmentParameters().size());
        Assert.assertFalse((boolean)manager.tokenForRenderingCalled());
        Assert.assertFalse((boolean)manager.schemeCalled());
        Assert.assertFalse((boolean)manager.ldExclusionCalled());
        Assert.assertTrue((boolean)manager.addExtrasCalled());
    }

    @Test
    public void typeUrlDefaultOptionsTpl() {
        String gadgetSite = "http://example.com/gadget";
        String prefKey = "prefKey";
        String prefVal = "prefVal";
        HashMap prefs = Maps.newHashMap();
        prefs.put(prefKey, prefVal);
        ArrayList features = Lists.newArrayList();
        Gadget gadget = this.mockGadget(gadgetSite, true, true, true, prefs, prefs, false, features);
        TestDefaultIframeUriManager managerTpl = this.makeManager(false, false);
        managerTpl.setTemplatingSignal(this.tplSignal(true));
        Uri resultTpl = managerTpl.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)resultTpl);
        UriBuilder uriTpl = new UriBuilder(resultTpl);
        Assert.assertEquals((Object)"http", (Object)uriTpl.getScheme());
        Assert.assertEquals((Object)"example.com", (Object)uriTpl.getAuthority());
        Assert.assertEquals((Object)"/gadget", (Object)uriTpl.getPath());
        Assert.assertEquals((Object)"container", (Object)uriTpl.getQueryParameter(UriCommon.Param.CONTAINER.getKey()));
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)UriCommon.Param.VIEW.getKey()), (Object)uriTpl.getQueryParameter(UriCommon.Param.VIEW.getKey()));
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)UriCommon.Param.LANG.getKey()), (Object)uriTpl.getQueryParameter(UriCommon.Param.LANG.getKey()));
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)UriCommon.Param.COUNTRY.getKey()), (Object)uriTpl.getQueryParameter(UriCommon.Param.COUNTRY.getKey()));
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)UriCommon.Param.DEBUG.getKey()), (Object)uriTpl.getQueryParameter(UriCommon.Param.DEBUG.getKey()));
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)UriCommon.Param.NO_CACHE.getKey()), (Object)uriTpl.getQueryParameter(UriCommon.Param.NO_CACHE.getKey()));
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)("up_" + prefKey)), (Object)uriTpl.getFragmentParameter("up_" + prefKey));
        Assert.assertEquals((long)6L, (long)uriTpl.getQueryParameters().size());
        Assert.assertEquals((long)1L, (long)uriTpl.getFragmentParameters().size());
        Assert.assertFalse((boolean)managerTpl.tokenForRenderingCalled());
        Assert.assertFalse((boolean)managerTpl.schemeCalled());
        Assert.assertFalse((boolean)managerTpl.ldExclusionCalled());
        Assert.assertTrue((boolean)managerTpl.addExtrasCalled());
    }

    @Test
    public void securityTokenAddedWhenGadgetNeedsItFragment() {
        Gadget gadget = this.mockGadget("security-token");
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        manager.setTokenForRendering(false);
        Uri result = manager.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)result);
        UriBuilder uri = new UriBuilder(result);
        Assert.assertEquals((long)7L, (long)uri.getQueryParameters().size());
        Assert.assertEquals((long)1L, (long)uri.getFragmentParameters().size());
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)UriCommon.Param.SECURITY_TOKEN.getKey()), (Object)uri.getFragmentParameter(UriCommon.Param.SECURITY_TOKEN.getKey()));
        Assert.assertTrue((boolean)manager.tokenForRenderingCalled());
    }

    @Test
    public void securityTokenAddedWhenGadgetNeedsItQuery() {
        Gadget gadget = this.mockGadget("security-token");
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        manager.setTokenForRendering(true);
        Uri result = manager.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)result);
        UriBuilder uri = new UriBuilder(result);
        Assert.assertEquals((long)8L, (long)uri.getQueryParameters().size());
        Assert.assertEquals((long)0L, (long)uri.getFragmentParameters().size());
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)UriCommon.Param.SECURITY_TOKEN.getKey()), (Object)uri.getQueryParameter(UriCommon.Param.SECURITY_TOKEN.getKey()));
        Assert.assertTrue((boolean)manager.tokenForRenderingCalled());
    }

    @Test
    public void securityTokenAddedWhenForced() {
        Gadget gadget = this.mockGadget("foo", "bar");
        TestDefaultIframeUriManager manager = this.makeManager(true, false);
        manager.setTokenForRendering(false);
        Uri result = manager.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)result);
        UriBuilder uri = new UriBuilder(result);
        Assert.assertEquals((long)7L, (long)uri.getQueryParameters().size());
        Assert.assertEquals((long)1L, (long)uri.getFragmentParameters().size());
        Assert.assertEquals((Object)DefaultIframeUriManager.tplKey((String)UriCommon.Param.SECURITY_TOKEN.getKey()), (Object)uri.getFragmentParameter(UriCommon.Param.SECURITY_TOKEN.getKey()));
        Assert.assertTrue((boolean)manager.tokenForRenderingCalled());
    }

    @Test
    public void ldAddedGadgetRequests() {
        Gadget gadget = this.mockGadget("locked-domain");
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        Uri result = manager.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)result);
        UriBuilder uri = new UriBuilder(result);
        Assert.assertEquals((Object)"", (Object)uri.getScheme());
        Assert.assertEquals((Object)"LOCKED.lockeddomain.com", (Object)uri.getAuthority());
        Assert.assertEquals((Object)IFRAME_PATH, (Object)uri.getPath());
        Assert.assertEquals((long)7L, (long)uri.getQueryParameters().size());
        Assert.assertEquals((long)0L, (long)uri.getFragmentParameters().size());
    }

    @Test
    public void ldAddedForcedAlways() {
        Gadget gadget = this.mockGadget(new String[0]);
        TestDefaultIframeUriManager manager = this.makeManager(false, true);
        Uri result = manager.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)result);
        UriBuilder uri = new UriBuilder(result);
        Assert.assertEquals((Object)"", (Object)uri.getScheme());
        Assert.assertEquals((Object)"LOCKED.lockeddomain.com", (Object)uri.getAuthority());
        Assert.assertEquals((Object)IFRAME_PATH, (Object)uri.getPath());
        Assert.assertEquals((long)7L, (long)uri.getQueryParameters().size());
        Assert.assertEquals((long)0L, (long)uri.getFragmentParameters().size());
    }

    @Test
    public void ldNotAddedIfDisabled() {
        Gadget gadget = this.mockGadget("locked-domain");
        TestDefaultIframeUriManager manager = this.makeManager(false, true);
        manager.setLockedDomainEnabled(false);
        Uri result = manager.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)result);
        UriBuilder uri = new UriBuilder(result);
        Assert.assertEquals((Object)"", (Object)uri.getScheme());
        Assert.assertEquals((Object)UNLOCKED_DOMAIN, (Object)uri.getAuthority());
        Assert.assertEquals((Object)IFRAME_PATH, (Object)uri.getPath());
        Assert.assertEquals((long)7L, (long)uri.getQueryParameters().size());
        Assert.assertEquals((long)0L, (long)uri.getFragmentParameters().size());
    }

    @Test
    public void ldNotAddedWithExclusion() {
        Gadget gadget = this.mockGadget("locked-domain");
        TestDefaultIframeUriManager manager = this.makeManager(false, true);
        manager.setLdExclusion(true);
        Uri result = manager.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)result);
        UriBuilder uri = new UriBuilder(result);
        Assert.assertEquals((Object)"", (Object)uri.getScheme());
        Assert.assertEquals((Object)UNLOCKED_DOMAIN, (Object)uri.getAuthority());
        Assert.assertEquals((Object)IFRAME_PATH, (Object)uri.getPath());
        Assert.assertEquals((long)7L, (long)uri.getQueryParameters().size());
        Assert.assertEquals((long)0L, (long)uri.getFragmentParameters().size());
    }

    @Test
    public void versionAddedWithVersioner() {
        String version = "abcdlkjwef";
        Gadget gadget = this.mockGadget(new String[0]);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        manager.setVersioner(this.mockVersioner(version, true));
        Uri result = manager.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)result);
        UriBuilder uri = new UriBuilder(result);
        Assert.assertEquals((long)8L, (long)uri.getQueryParameters().size());
        Assert.assertEquals((Object)version, (Object)uri.getQueryParameter(UriCommon.Param.VERSION.getKey()));
    }

    @Test
    public void userPrefsAddedQuery() {
        HashMap specPrefs = Maps.newHashMap();
        specPrefs.put("specKey1", "specDefault1");
        specPrefs.put("specKey2", "specDefault2");
        HashMap inPrefs = Maps.newHashMap();
        inPrefs.put("specKey1", "inVal1");
        inPrefs.put("otherKey1", "inVal2");
        Gadget gadget = this.mockGadget(true, specPrefs, inPrefs);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        Uri result = manager.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)result);
        UriBuilder uri = new UriBuilder(result);
        Assert.assertEquals((long)9L, (long)uri.getQueryParameters().size());
        Assert.assertEquals((long)0L, (long)uri.getFragmentParameters().size());
        Assert.assertEquals((Object)"inVal1", (Object)uri.getQueryParameter("up_specKey1"));
        Assert.assertEquals((Object)"specDefault2", (Object)uri.getQueryParameter("up_specKey2"));
    }

    @Test
    public void userPrefsAddedFragment() {
        HashMap specPrefs = Maps.newHashMap();
        specPrefs.put("specKey1", "specDefault1");
        specPrefs.put("specKey2", "specDefault2");
        HashMap inPrefs = Maps.newHashMap();
        inPrefs.put("specKey1", "inVal1");
        inPrefs.put("otherKey1", "inVal2");
        Gadget gadget = this.mockGadget(false, specPrefs, inPrefs);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        Uri result = manager.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)result);
        UriBuilder uri = new UriBuilder(result);
        Assert.assertEquals((long)7L, (long)uri.getQueryParameters().size());
        Assert.assertEquals((long)2L, (long)uri.getFragmentParameters().size());
        Assert.assertEquals((Object)"inVal1", (Object)uri.getFragmentParameter("up_specKey1"));
        Assert.assertEquals((Object)"specDefault2", (Object)uri.getFragmentParameter("up_specKey2"));
    }

    @Test
    public void honorSchemeOverride() {
        String scheme = "file";
        Gadget gadget = this.mockGadget(new String[0]);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        manager.setScheme(scheme);
        Uri result = manager.makeRenderingUri(gadget);
        Assert.assertNotNull((Object)result);
        UriBuilder uri = new UriBuilder(result);
        Assert.assertEquals((Object)scheme, (Object)uri.getScheme());
    }

    @Test
    public void badUriValidatingUri() {
        Uri uri = new UriBuilder().addQueryParameter(UriCommon.Param.URL.getKey(), "^':   bad:").toUri();
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        UriStatus status = manager.validateRenderingUri(uri);
        Assert.assertEquals((Object)UriStatus.BAD_URI, (Object)status);
    }

    @Test
    public void invalidLockedDomainValidSuffix() {
        Uri uri = this.makeValidationTestUri("LOCKED.altld.com", null);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        Assert.assertEquals((Object)UriStatus.INVALID_DOMAIN, (Object)manager.validateRenderingUri(uri));
    }

    @Test
    public void invalidLockedDomainInvalidSuffix() {
        Uri uri = this.makeValidationTestUri("LOCKED.bad..lockeddomain.com", null);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        Assert.assertEquals((Object)UriStatus.INVALID_DOMAIN, (Object)manager.validateRenderingUri(uri));
    }

    @Test
    public void invalidLockedDomainValidSuffixExclusionBypass() {
        Uri uri = this.makeValidationTestUri("LOCKED.altld.com", null);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        manager.setLdExclusion(true);
        Assert.assertEquals((Object)UriStatus.VALID_UNVERSIONED, (Object)manager.validateRenderingUri(uri));
    }

    @Test
    public void invalidLockedDomainInvalidSuffixExclusionBypass() {
        Uri uri = this.makeValidationTestUri("LOCKED.bad..lockeddomain.com", null);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        manager.setLdExclusion(true);
        Assert.assertEquals((Object)UriStatus.VALID_UNVERSIONED, (Object)manager.validateRenderingUri(uri));
    }

    @Test
    public void invalidLockedDomainValidSuffixLdDisabled() {
        Uri uri = this.makeValidationTestUri("LOCKED.altld.com", null);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        manager.setLockedDomainEnabled(false);
        Assert.assertEquals((Object)UriStatus.VALID_UNVERSIONED, (Object)manager.validateRenderingUri(uri));
    }

    @Test
    public void invalidLockedDomainInvalidSuffixLdDisabled() {
        Uri uri = this.makeValidationTestUri("LOCKED.bad..lockeddomain.com", null);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        manager.setLockedDomainEnabled(false);
        Assert.assertEquals((Object)UriStatus.VALID_UNVERSIONED, (Object)manager.validateRenderingUri(uri));
    }

    @Test
    public void validUnversionedNoVersioner() {
        Uri uri = this.makeValidationTestUri("LOCKED.lockeddomain.com", "version");
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        Assert.assertEquals((Object)UriStatus.VALID_UNVERSIONED, (Object)manager.validateRenderingUri(uri));
    }

    @Test
    public void validUnversionedNoVersion() {
        Uri uri = this.makeValidationTestUri("LOCKED.lockeddomain.com", null);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        manager.setVersioner(this.mockVersioner("version", false));
        Assert.assertEquals((Object)UriStatus.VALID_UNVERSIONED, (Object)manager.validateRenderingUri(uri));
    }

    @Test
    public void versionerVersionInvalid() {
        Uri uri = this.makeValidationTestUri("LOCKED.lockeddomain.com", "in-version");
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        manager.setVersioner(this.mockVersioner("test-version", false));
        Assert.assertEquals((Object)UriStatus.INVALID_VERSION, (Object)manager.validateRenderingUri(uri));
    }

    @Test
    public void versionerVersionMatch() {
        String version = "abcdefg";
        Uri uri = this.makeValidationTestUri("LOCKED.lockeddomain.com", version);
        TestDefaultIframeUriManager manager = this.makeManager(false, false);
        manager.setVersioner(this.mockVersioner(version, true));
        Assert.assertEquals((Object)UriStatus.VALID_VERSIONED, (Object)manager.validateRenderingUri(uri));
    }

    private Uri makeValidationTestUri(String domain, String version) {
        UriBuilder uri = new UriBuilder();
        uri.setAuthority(domain);
        uri.setPath(IFRAME_PATH);
        uri.addQueryParameter(UriCommon.Param.URL.getKey(), SPEC_URI.toString());
        uri.addQueryParameter(UriCommon.Param.CONTAINER.getKey(), "container");
        if (version != null) {
            uri.addQueryParameter(UriCommon.Param.VERSION.getKey(), version);
        }
        return uri.toUri();
    }

    private TestDefaultIframeUriManager makeManager(boolean alwaysToken, boolean ldRequired) {
        ContainerConfig config = (ContainerConfig)EasyMock.createMock(ContainerConfig.class);
        String altContainer = "container-alt";
        ArrayList containers = Lists.newArrayList((Object[])new String[]{"container", altContainer});
        EasyMock.expect((Object)config.getContainers()).andReturn((Object)containers).anyTimes();
        EasyMock.expect((Object)config.getString("container", "gadgets.uri.iframe.basePath")).andReturn((Object)IFRAME_PATH).anyTimes();
        EasyMock.expect((Object)config.getString("container", "gadgets.uri.iframe.lockedDomainSuffix")).andReturn((Object)LD_SUFFIX).anyTimes();
        EasyMock.expect((Object)config.getString(altContainer, "gadgets.uri.iframe.lockedDomainSuffix")).andReturn((Object)LD_SUFFIX_ALT).anyTimes();
        EasyMock.expect((Object)config.getString("container", "gadgets.uri.iframe.unlockedDomain")).andReturn((Object)UNLOCKED_DOMAIN).anyTimes();
        EasyMock.expect((Object)config.getBool("container", "gadgets.uri.iframe.alwaysAppendSecurityToken")).andReturn((Object)alwaysToken).anyTimes();
        EasyMock.expect((Object)config.getBool("container", "gadgets.uri.iframe.lockedDomainRequired")).andReturn((Object)ldRequired).anyTimes();
        EasyMock.replay((Object[])new Object[]{config});
        return new TestDefaultIframeUriManager(config);
    }

    private IframeUriManager.Versioner mockVersioner(String version, boolean valid) {
        IframeUriManager.Versioner versioner = (IframeUriManager.Versioner)EasyMock.createMock(IframeUriManager.Versioner.class);
        EasyMock.expect((Object)versioner.version((Uri)EasyMock.isA(Uri.class), (String)EasyMock.isA(String.class))).andReturn((Object)version).anyTimes();
        EasyMock.expect((Object)versioner.validate((Uri)EasyMock.isA(Uri.class), (String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class))).andReturn((Object)(valid ? UriStatus.VALID_VERSIONED : UriStatus.INVALID_VERSION)).anyTimes();
        EasyMock.replay((Object[])new Object[]{versioner});
        return versioner;
    }

    private DefaultIframeUriManager.TemplatingSignal tplSignal(boolean value) {
        DefaultIframeUriManager.DefaultTemplatingSignal tplSignal = new DefaultIframeUriManager.DefaultTemplatingSignal();
        tplSignal.setUseTemplates(Boolean.valueOf(value));
        return tplSignal;
    }

    private static final class TestDefaultIframeUriManager
    extends DefaultIframeUriManager {
        private boolean ldExclusion = false;
        private boolean ldExclusionCalled = false;
        private String scheme = "";
        private boolean schemeCalled = false;
        private boolean tokenForRendering = true;
        private boolean tokenForRenderingCalled = false;
        private boolean addExtrasCalled = false;

        private TestDefaultIframeUriManager(ContainerConfig config) {
            super(config, prefixGen, tokenCodec);
        }

        private TestDefaultIframeUriManager setLdExclusion(boolean ldExclusion) {
            this.ldExclusion = ldExclusion;
            return this;
        }

        private TestDefaultIframeUriManager setScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        private TestDefaultIframeUriManager setTokenForRendering(boolean tokenForRendering) {
            this.tokenForRendering = tokenForRendering;
            return this;
        }

        protected boolean lockedDomainExclusion() {
            this.ldExclusionCalled = true;
            return this.ldExclusion;
        }

        private boolean ldExclusionCalled() {
            return this.ldExclusionCalled;
        }

        protected String getScheme(Gadget gadget, String container) {
            this.schemeCalled = true;
            return this.scheme;
        }

        private boolean schemeCalled() {
            return this.schemeCalled;
        }

        protected boolean isTokenNeededForRendering(Gadget gadget) {
            this.tokenForRenderingCalled = true;
            return this.tokenForRendering;
        }

        private boolean tokenForRenderingCalled() {
            return this.tokenForRenderingCalled;
        }

        protected void addExtras(UriBuilder uri) {
            this.addExtrasCalled = true;
        }

        private boolean addExtrasCalled() {
            return this.addExtrasCalled;
        }
    }
}

