/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.uri.DefaultJsVersioner;
import org.apache.shindig.gadgets.uri.UriStatus;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultJsVersionerTest {
    private static final Uri URI = Uri.parse((String)"http://apache.org/gadget.xml");
    private static final String CONTAINER = "container";
    private DefaultJsVersioner versioner;
    private FeatureRegistry registry;

    @Before
    public void setUp() {
        this.registry = (FeatureRegistry)EasyMock.createMock(FeatureRegistry.class);
        this.versioner = new DefaultJsVersioner(this.registry);
    }

    @Test
    public void versionCached() {
        String feature = "feature1";
        this.expectReq(feature, "content");
        EasyMock.replay((Object[])new Object[]{this.registry});
        ArrayList libs = Lists.newArrayList((Object[])new String[]{feature});
        String version = this.versioner.version(URI, CONTAINER, (Collection)libs);
        Assert.assertNotNull((Object)version);
        String versionAgain = this.versioner.version(URI, CONTAINER, (Collection)libs);
        Assert.assertSame((Object)version, (Object)versionAgain);
        EasyMock.verify((Object[])new Object[]{this.registry});
    }

    @Test
    public void versionDifferentForDifferentFeatures() {
        String feature1 = "feature1";
        String feature2 = "feature2";
        this.expectReq(feature1, "content1");
        this.expectReq(feature2, "content2");
        EasyMock.replay((Object[])new Object[]{this.registry});
        ArrayList libs1 = Lists.newArrayList((Object[])new String[]{feature1});
        String version1 = this.versioner.version(URI, CONTAINER, (Collection)libs1);
        ArrayList libs2 = Lists.newArrayList((Object[])new String[]{feature2});
        String version2 = this.versioner.version(URI, CONTAINER, (Collection)libs2);
        Assert.assertNotNull((Object)version1);
        Assert.assertNotNull((Object)version2);
        Assert.assertFalse((boolean)version1.equals(version2));
        EasyMock.verify((Object[])new Object[]{this.registry});
    }

    @Test
    public void validateMismatch() {
        String feature = "feature1";
        this.expectReq(feature, "content");
        EasyMock.replay((Object[])new Object[]{this.registry});
        ArrayList libs = Lists.newArrayList((Object[])new String[]{feature});
        String version = this.versioner.version(URI, CONTAINER, (Collection)libs);
        Assert.assertNotNull((Object)version);
        UriStatus status = this.versioner.validate(URI, CONTAINER, (Collection)libs, version + "-nomatch");
        Assert.assertEquals((Object)UriStatus.INVALID_VERSION, (Object)status);
        EasyMock.verify((Object[])new Object[]{this.registry});
    }

    @Test
    public void validateNull() {
        String feature = "feature1";
        this.expectReq(feature, "content");
        EasyMock.replay((Object[])new Object[]{this.registry});
        ArrayList libs = Lists.newArrayList((Object[])new String[]{feature});
        String version = this.versioner.version(URI, CONTAINER, (Collection)libs);
        Assert.assertNotNull((Object)version);
        UriStatus status = this.versioner.validate(URI, CONTAINER, (Collection)libs, null);
        Assert.assertEquals((Object)UriStatus.VALID_UNVERSIONED, (Object)status);
        EasyMock.verify((Object[])new Object[]{this.registry});
    }

    @Test
    public void validateEmpty() {
        String feature = "feature1";
        this.expectReq(feature, "content");
        EasyMock.replay((Object[])new Object[]{this.registry});
        ArrayList libs = Lists.newArrayList((Object[])new String[]{feature});
        String version = this.versioner.version(URI, CONTAINER, (Collection)libs);
        Assert.assertNotNull((Object)version);
        UriStatus status = this.versioner.validate(URI, CONTAINER, (Collection)libs, "");
        Assert.assertEquals((Object)UriStatus.VALID_UNVERSIONED, (Object)status);
        EasyMock.verify((Object[])new Object[]{this.registry});
    }

    @Test
    public void createAndValidateVersion() {
        String feature = "feature1";
        this.expectReq(feature, "content");
        EasyMock.replay((Object[])new Object[]{this.registry});
        ArrayList libs = Lists.newArrayList((Object[])new String[]{feature});
        String version = this.versioner.version(URI, CONTAINER, (Collection)libs);
        Assert.assertNotNull((Object)version);
        UriStatus status = this.versioner.validate(URI, CONTAINER, (Collection)libs, version);
        Assert.assertEquals((Object)UriStatus.VALID_VERSIONED, (Object)status);
        EasyMock.verify((Object[])new Object[]{this.registry});
    }

    private void expectReq(String feature, String content) {
        FeatureResource.Simple resource = new FeatureResource.Simple(content, "");
        ArrayList libs = Lists.newArrayList((Object[])new String[]{feature});
        ArrayList resources = Lists.newArrayList((Object[])new FeatureResource[]{resource});
        EasyMock.expect((Object)this.registry.getFeatureResources((GadgetContext)EasyMock.isA(GadgetContext.class), (Collection)EasyMock.eq((Object)libs), (List)EasyMock.isNull())).andReturn((Object)resources).anyTimes();
    }
}

