/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.uri.UriUtils;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriUtilsTest {
    Enumeration<String> makeEnumeration(String ... args) {
        Vector<String> vector = new Vector<String>();
        if (args != null) {
            vector.addAll(Arrays.asList(args));
        }
        return vector.elements();
    }

    private void verifyMime(String requestMime, String responseMime, String expectedMime) throws Exception {
        String url = "http://example.org/foo";
        HttpRequest req = new HttpRequest(Uri.parse((String)url)).setRewriteMimeType(requestMime);
        HttpResponseBuilder builder = new HttpResponseBuilder().setHeader("Content-Type", responseMime);
        UriUtils.maybeRewriteContentType((HttpRequest)req, (HttpResponseBuilder)builder);
        Assert.assertEquals((Object)expectedMime, (Object)builder.getHeader("Content-Type"));
    }

    @Test
    public void testMimeMatchPass() throws Exception {
        this.verifyMime("text/css", "text/css", "text/css");
    }

    @Test
    public void testMimeMatchPassWithAdditionalAttributes() throws Exception {
        this.verifyMime("text/css", "text/css; charset=UTF-8", "text/css");
    }

    @Test
    public void testNonMatchingMime() throws Exception {
        this.verifyMime("text/css", "image/png; charset=UTF-8", "text/css");
    }

    @Test
    public void testNonMatchingMimeWithSamePrefix() throws Exception {
        this.verifyMime("text/html", "text/plain", "text/html");
    }

    @Test
    public void testNonMatchingMimeWithWildCard() throws Exception {
        this.verifyMime("text/*", "image/png", "text/*");
    }

    @Test
    public void testNonMatchingMimeWithDifferentPrefix() throws Exception {
        this.verifyMime("text/*", "text123/html", "text/*");
    }

    @Test
    public void testMimeMatchVarySupport() throws Exception {
        this.verifyMime("image/*", "image/gif", "image/gif");
    }

    @Test
    public void testNullRequestMime() throws Exception {
        this.verifyMime(null, "image/png; charset=UTF-8", "image/png; charset=UTF-8");
    }

    @Test
    public void testEmptyRequestMime() throws Exception {
        this.verifyMime("", "image/png; charset=UTF-8", "image/png; charset=UTF-8");
    }

    @Test
    public void testNullResponseMime() throws Exception {
        this.verifyMime("text/*", null, "text/*");
    }

    @Test
    public void testCopyResponseHeadersAndStatusCode_AddHeader() throws Exception {
        HttpResponse resp = new HttpResponseBuilder().setHttpStatusCode(5000).addHeader("hello", "world1").addHeader("hello", "world2").addHeader("hello\u2297", "bad header").addHeader("Content-length", "10").addHeader("vary", "1").create();
        HttpResponseBuilder builder = new HttpResponseBuilder();
        UriUtils.copyResponseHeadersAndStatusCode((HttpResponse)resp, (HttpResponseBuilder)builder, (boolean)false, (boolean)false, (UriUtils.DisallowedHeaders[])new UriUtils.DisallowedHeaders[]{UriUtils.DisallowedHeaders.OUTPUT_TRANSFER_DIRECTIVES, UriUtils.DisallowedHeaders.CACHING_DIRECTIVES});
        HttpResponse response = builder.create();
        Assert.assertEquals((long)3L, (long)response.getHeaders().size());
        Iterator headers = response.getHeaders("hello").iterator();
        Assert.assertEquals((Object)"world1", headers.next());
        Assert.assertEquals((Object)"world2", headers.next());
        Assert.assertEquals((long)5000L, (long)response.getHttpStatusCode());
    }

    @Test
    public void testCopyResponseHeadersAndStatusCode_SetHeaders() throws Exception {
        HttpResponse resp = new HttpResponseBuilder().setHttpStatusCode(5000).addHeader("hello", "world1").addHeader("hello", "world2").addHeader("hello\u2297", "bad header").addHeader("Content-length", "10").addHeader("vary", "1").create();
        HttpResponseBuilder builder = new HttpResponseBuilder();
        UriUtils.copyResponseHeadersAndStatusCode((HttpResponse)resp, (HttpResponseBuilder)builder, (boolean)false, (boolean)true, (UriUtils.DisallowedHeaders[])new UriUtils.DisallowedHeaders[]{UriUtils.DisallowedHeaders.OUTPUT_TRANSFER_DIRECTIVES, UriUtils.DisallowedHeaders.CACHING_DIRECTIVES});
        HttpResponse response = builder.create();
        Assert.assertEquals((long)2L, (long)response.getHeaders().size());
        Assert.assertEquals((Object)"world2", (Object)response.getHeader("hello"));
        Assert.assertEquals((long)5000L, (long)response.getHttpStatusCode());
    }

    @Test
    public void testCopyResponseHeadersAndStatusCode_RemapTrue() throws Exception {
        HttpResponse resp = new HttpResponseBuilder().setHttpStatusCode(500).addHeader("hello", "world1").addHeader("hello", "world2").addHeader("hello\u2297", "bad header").addHeader("Content-length", "10").addHeader("vary", "1").create();
        HttpResponseBuilder builder = new HttpResponseBuilder();
        UriUtils.copyResponseHeadersAndStatusCode((HttpResponse)resp, (HttpResponseBuilder)builder, (boolean)true, (boolean)true, (UriUtils.DisallowedHeaders[])new UriUtils.DisallowedHeaders[]{UriUtils.DisallowedHeaders.OUTPUT_TRANSFER_DIRECTIVES, UriUtils.DisallowedHeaders.CACHING_DIRECTIVES});
        HttpResponse response = builder.create();
        Assert.assertEquals((long)2L, (long)response.getHeaders().size());
        Assert.assertEquals((Object)"world2", (Object)response.getHeader("hello"));
        Assert.assertEquals((long)502L, (long)response.getHttpStatusCode());
    }

    @Test
    public void testCopyResponseHeadersAndStatusCode_RemapFalse() throws Exception {
        HttpResponse resp = new HttpResponseBuilder().setHttpStatusCode(500).addHeader("hello", "world1").addHeader("hello", "world2").addHeader("hello\u2297", "bad header").addHeader("Content-length", "10").addHeader("vary", "1").create();
        HttpResponseBuilder builder = new HttpResponseBuilder();
        UriUtils.copyResponseHeadersAndStatusCode((HttpResponse)resp, (HttpResponseBuilder)builder, (boolean)false, (boolean)true, (UriUtils.DisallowedHeaders[])new UriUtils.DisallowedHeaders[]{UriUtils.DisallowedHeaders.OUTPUT_TRANSFER_DIRECTIVES, UriUtils.DisallowedHeaders.CACHING_DIRECTIVES});
        HttpResponse response = builder.create();
        Assert.assertEquals((long)2L, (long)response.getHeaders().size());
        Assert.assertEquals((Object)"world2", (Object)response.getHeader("hello"));
        Assert.assertEquals((long)500L, (long)response.getHttpStatusCode());
    }

    @Test
    public void testCopyRequestHeaders() throws Exception {
        HttpRequest origRequest = new HttpRequest(Uri.parse((String)"http://www.example.org/data.html"));
        ImmutableMap addedHeaders = ImmutableMap.builder().put((Object)"h1", (Object)ImmutableList.of((Object)"v1", (Object)"v2")).put((Object)"h2", (Object)ImmutableList.of((Object)"v3", (Object)"v4")).put((Object)"hello\u2297", (Object)ImmutableList.of((Object)"v5", (Object)"v6")).put((Object)"unchanged_header", (Object)ImmutableList.of()).put((Object)"Content-Length", (Object)ImmutableList.of((Object)"50", (Object)"100")).build();
        origRequest.addAllHeaders((Map)addedHeaders);
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://www.example.org/data.html"));
        req.removeHeader("X-shindig-dos");
        req.addHeader("h1", "hello");
        req.addHeader("Content-Length", "10");
        req.addHeader("unchanged_header", "original_value");
        UriUtils.copyRequestHeaders((HttpRequest)origRequest, (HttpRequest)req, (UriUtils.DisallowedHeaders[])new UriUtils.DisallowedHeaders[]{UriUtils.DisallowedHeaders.POST_INCOMPATIBLE_DIRECTIVES});
        ImmutableMap headers = ImmutableMap.builder().put((Object)"h1", (Object)ImmutableList.of((Object)"v1", (Object)"v2")).put((Object)"h2", (Object)ImmutableList.of((Object)"v3", (Object)"v4")).put((Object)"unchanged_header", (Object)ImmutableList.of((Object)"original_value")).put((Object)"Content-Length", (Object)ImmutableList.of((Object)"10")).put((Object)"X-shindig-dos", (Object)ImmutableList.of((Object)"on")).build();
        Assert.assertEquals((Object)headers, (Object)req.getHeaders());
    }

    @Test
    public void testCopyRequestData() throws Exception {
        HttpRequest origRequest = new HttpRequest(Uri.parse((String)"http://www.example.com"));
        origRequest.setMethod("Post");
        String data = "hello world";
        origRequest.setPostBody(data.getBytes());
        HttpRequest req = new HttpRequest(Uri.parse((String)"http://www.example.org/data.html"));
        UriUtils.copyRequestData((HttpRequest)origRequest, (HttpRequest)req);
        Assert.assertEquals((Object)data, (Object)req.getPostBodyAsString());
    }

    @Test
    public void testGetContentTypeWithoutCharset() {
        Assert.assertEquals((Object)"text/html", (Object)UriUtils.getContentTypeWithoutCharset((String)"text/html"));
        Assert.assertEquals((Object)"text/html;", (Object)UriUtils.getContentTypeWithoutCharset((String)"text/html;"));
        Assert.assertEquals((Object)"text/html", (Object)UriUtils.getContentTypeWithoutCharset((String)"text/html; charset=hello"));
        Assert.assertEquals((Object)"text/html; hello=world", (Object)UriUtils.getContentTypeWithoutCharset((String)"text/html; charset=hello; hello=world"));
        Assert.assertEquals((Object)"text/html; pharset=hello; hello=world", (Object)UriUtils.getContentTypeWithoutCharset((String)"text/html; pharset=hello; hello=world"));
        Assert.assertEquals((Object)"text/html; charsett=utf; hello=world", (Object)UriUtils.getContentTypeWithoutCharset((String)"text/html; charsett=utf; ; hello=world"));
    }
}

