/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.variables;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.variables.BidiSubstituter;
import org.apache.shindig.gadgets.variables.MessageSubstituter;
import org.apache.shindig.gadgets.variables.ModuleSubstituter;
import org.apache.shindig.gadgets.variables.UserPrefSubstituter;
import org.apache.shindig.gadgets.variables.VariableSubstituter;
import org.junit.Assert;
import org.junit.Test;

public class VariableSubstituterTest {
    private final FakeMessageBundleFactory messageBundleFactory = new FakeMessageBundleFactory();
    private final VariableSubstituter substituter = new VariableSubstituter((List)ImmutableList.of((Object)new MessageSubstituter((MessageBundleFactory)this.messageBundleFactory), (Object)new UserPrefSubstituter(), (Object)new ModuleSubstituter(), (Object)new BidiSubstituter((MessageBundleFactory)this.messageBundleFactory)));

    private GadgetSpec substitute(String xml) throws Exception {
        return this.substituter.substitute(new GadgetContext(), new GadgetSpec(Uri.parse((String)"#"), xml));
    }

    @Test
    public void messageBundlesSubstituted() throws Exception {
        String xml = "<Module><ModulePrefs title=''>  <Locale>    <msg name='foo'>bar</msg>    <msg name='bar'>baz</msg>  </Locale></ModulePrefs><Content>__MSG_foo__ - __MSG_bar__</Content></Module>";
        GadgetSpec spec = this.substitute(xml);
        Assert.assertEquals((Object)"bar - baz", (Object)spec.getView("default").getContent());
    }

    @Test
    public void bidiSubstituted() throws Exception {
        String xml = "<Module><ModulePrefs title='__BIDI_END_EDGE__ way'/><Content/></Module>";
        GadgetSpec spec = this.substitute(xml);
        Assert.assertEquals((Object)"right way", (Object)spec.getModulePrefs().getTitle());
    }

    @Test
    public void moduleIdSubstituted() throws Exception {
        String xml = "<Module><ModulePrefs title='Module is: __MODULE_ID__'/><Content/></Module>";
        GadgetSpec spec = this.substitute(xml);
        Assert.assertEquals((Object)"Module is: 0", (Object)spec.getModulePrefs().getTitle());
    }

    @Test
    public void userPrefsSubstituted() throws Exception {
        String xml = "<Module><ModulePrefs title='I heart __UP_foo__'/><UserPref name='foo'/><Content/></Module>";
        GadgetSpec spec = new GadgetSpec(Uri.parse((String)"#"), xml);
        GadgetContext context = new GadgetContext(){

            public UserPrefs getUserPrefs() {
                return new UserPrefs((Map)ImmutableMap.of((Object)"foo", (Object)"shindig"));
            }
        };
        spec = this.substituter.substitute(context, spec);
        Assert.assertEquals((Object)"I heart shindig", (Object)spec.getModulePrefs().getTitle());
    }

    @Test
    public void nestedMessageBundleInUserPrefSubstituted() throws Exception {
        String xml = "<Module> <ModulePrefs title='__UP_title__ for __MODULE_ID__'>  <Locale>   <msg name='title'>Gadget title</msg>  </Locale> </ModulePrefs> <UserPref name='title' default_value='__MSG_title__' /> <Content /></Module>";
        GadgetSpec spec = this.substitute(xml);
        Assert.assertEquals((Object)"Gadget title for 0", (Object)spec.getModulePrefs().getTitle());
    }

    private static class FakeMessageBundleFactory
    implements MessageBundleFactory {
        private FakeMessageBundleFactory() {
        }

        public MessageBundle getBundle(GadgetSpec spec, Locale locale, boolean ignoreCache, String container) throws GadgetException {
            LocaleSpec localeSpec = spec.getModulePrefs().getLocale(locale);
            if (localeSpec == null) {
                return MessageBundle.EMPTY;
            }
            return localeSpec.getMessageBundle();
        }
    }
}

