/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CajaCssUtils {
    private CajaCssUtils() {
    }

    public static <T extends CssTree> List<T> children(CssTree node, Class<T> nodeType) {
        ArrayList result = Lists.newArrayList();
        for (CssTree child : node.children()) {
            if (!nodeType.isAssignableFrom(child.getClass())) continue;
            result.add(nodeType.cast(child));
        }
        return result;
    }

    public static <T extends CssTree> List<T> descendants(CssTree node, final Class<T> nodeType) {
        final ArrayList descendants = Lists.newArrayList();
        node.acceptPreOrder(new Visitor(){

            public boolean visit(AncestorChain<?> ancestorChain) {
                if (nodeType.isAssignableFrom(ancestorChain.node.getClass())) {
                    descendants.add(nodeType.cast(ancestorChain.node));
                }
                return true;
            }
        }, null);
        return descendants;
    }

    public static void saveIp6Uris(CssTree.StyleSheet styleSheet, List<String> ip6Uris) {
        if (styleSheet == null || ip6Uris == null) {
            return;
        }
        List<CssTree.UriLiteral> uris = CajaCssUtils.descendants((CssTree)styleSheet, CssTree.UriLiteral.class);
        for (CssTree.UriLiteral uri : uris) {
            String sUri = uri.getValue();
            String ip6 = CajaCssUtils.extractIp6(sUri);
            if (ip6 == null) continue;
            int count = ip6Uris.indexOf(ip6);
            if (count == -1) {
                ip6Uris.add(ip6);
                count = ip6Uris.size() - 1;
            }
            String index = "ipv6i" + count + "f";
            uri.setValue(sUri.replace(ip6, index));
        }
    }

    public static String restoreIp6Uris(String styleSheet, List<String> ip6Uris) {
        if (ip6Uris == null || ip6Uris.size() == 0) {
            return styleSheet;
        }
        int length = styleSheet.length();
        int i = 0;
        int startToken = -1;
        int finishToken = -1;
        boolean finish = false;
        StringBuilder output = new StringBuilder();
        while (!finish) {
            boolean found = false;
            Character ch = Character.valueOf(styleSheet.charAt(i));
            if (ch.equals(Character.valueOf('i')) && i + 1 < length && styleSheet.charAt(i + 1) == 'p' && i + 2 < length && styleSheet.charAt(i + 2) == 'v' && i + 3 < length && styleSheet.charAt(i + 3) == '6' && i + 4 < length && styleSheet.charAt(i + 4) == 'i') {
                boolean numbers = true;
                startToken = i;
                finishToken = i + 5;
                while (numbers) {
                    if (finishToken < length && styleSheet.charAt(finishToken) >= '0' && styleSheet.charAt(finishToken) <= '9') {
                        ++finishToken;
                        continue;
                    }
                    numbers = false;
                }
                if (finishToken < length && styleSheet.charAt(finishToken) == 'f') {
                    String token = styleSheet.substring(startToken, finishToken);
                    int index = -1;
                    try {
                        index = new Integer(token.substring(5, token.length()));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (index > -1 && index < ip6Uris.size()) {
                        output.append(ip6Uris.get(index));
                        found = true;
                        i = finishToken;
                    }
                }
            }
            if (!found) {
                output.append(ch);
            }
            if (++i < length) continue;
            finish = true;
        }
        return output.toString();
    }

    public static String extractIp6(String sUri) {
        String authority;
        int lastColon;
        int beginFrom;
        if (sUri == null || sUri.length() < 7 || !sUri.startsWith("http")) {
            return null;
        }
        if (sUri.charAt(4) == ':') {
            beginFrom = 7;
        } else if (sUri.charAt(4) == 's') {
            beginFrom = 8;
        } else {
            return null;
        }
        int firstSlash = sUri.indexOf(47, beginFrom);
        if (firstSlash == -1) {
            firstSlash = sUri.length();
        }
        if ((lastColon = (authority = sUri.substring(beginFrom, firstSlash)).lastIndexOf(58)) == -1) {
            return null;
        }
        int openBracket = authority.lastIndexOf(91);
        if (openBracket == -1) {
            boolean moreColons;
            String untilColon = authority.substring(0, lastColon);
            boolean bl = moreColons = untilColon.lastIndexOf(58) > -1;
            if (moreColons) {
                return authority;
            }
            return null;
        }
        int closeBracket = authority.lastIndexOf(93);
        return authority.substring(openBracket, closeBracket + 1);
    }
}

