/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.spnego;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.exoplatform.services.security.jaas.UserPrincipal;
import org.jboss.security.negotiation.common.NegotiationContext;

public class SPNEGOLoginModule
extends org.jboss.security.negotiation.spnego.SPNEGOLoginModule {
    private String usernamePasswordDomain;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.usernamePasswordDomain = (String)options.get("usernamePasswordDomain");
    }

    protected Object innerLogin() throws LoginException {
        NegotiationContext negotiationContext = NegotiationContext.getCurrentNegotiationContext();
        if (negotiationContext == null) {
            if (this.usernamePasswordDomain == null) {
                throw new LoginException("No NegotiationContext and no usernamePasswordDomain defined.");
            }
            return this.usernamePasswordLogin();
        }
        return super.innerLogin();
    }

    private Object usernamePasswordLogin() throws LoginException {
        this.log.debug((Object)"Falling back to username/password authentication");
        LoginContext lc = new LoginContext(this.usernamePasswordDomain, this.callbackHandler);
        lc.login();
        Subject userSubject = lc.getSubject();
        Principal identity = this.getIdentityFromSubject(userSubject);
        this.setIdentity(identity);
        return Boolean.TRUE;
    }

    protected Principal getIdentityFromSubject(Subject userSubject) throws LoginException {
        Set<UserPrincipal> principals = userSubject.getPrincipals(UserPrincipal.class);
        if (principals.isEmpty()) {
            throw new LoginException("No UserPrincipals returned after login.");
        }
        if (principals.size() > 1) {
            this.log.warn((Object)"Multiple UserPrincipals returned, using first principal in set.");
        }
        Principal identity = (Principal)principals.iterator().next();
        return identity;
    }
}

