/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.spnego;

import java.io.IOException;
import java.lang.reflect.Field;
import java.security.Principal;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.NegotiationAuthenticator;

public class GateInNegotiationAuthenticator
extends NegotiationAuthenticator {
    private static final Logger log = Logger.getLogger(GateInNegotiationAuthenticator.class);

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        Principal principal;
        response.setContentType("text/html; charset=UTF-8");
        boolean superResult = super.authenticate(request, response, config);
        if (superResult && (principal = request.getPrincipal()) instanceof GenericPrincipal) {
            GenericPrincipal genPrincipal = (GenericPrincipal)principal;
            String userPrincipalName = genPrincipal.getUserPrincipal().getName();
            if (!genPrincipal.getName().equals(userPrincipalName)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("GenericPrincipal name: " + genPrincipal.getName() + " will be changed to name: " + userPrincipalName));
                }
                try {
                    Field nameField = GenericPrincipal.class.getDeclaredField("name");
                    nameField.setAccessible(true);
                    nameField.set(genPrincipal, userPrincipalName);
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return superResult;
    }

    protected String savedRequestURL(Session session) {
        String savedURI = super.savedRequestURL(session);
        if (savedURI == null) {
            savedURI = (String)session.getSession().getAttribute("SPNEGOFilter.initialURI");
        }
        if (savedURI == null) {
            savedURI = "/" + session.getSession().getServletContext().getServletContextName();
        }
        return savedURI;
    }
}

