/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.sso.spnego;

import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.jaas.AbstractLoginModule;
import org.gatein.security.sso.spnego.SPNEGOSSOContext;

public class SPNEGOSSOLoginModule
extends AbstractLoginModule {
    private static final Log log = ExoLogger.getLogger(SPNEGOSSOLoginModule.class);
    public static final String OPTION_ENABLE_FALLBACK_FORM_AUTHENTICATION = "enableFormAuthentication";

    protected Log getLogger() {
        return log;
    }

    public boolean login() throws LoginException {
        try {
            ExoContainer container = this.getContainer();
            HttpServletRequest servletRequest = SPNEGOSSOContext.getCurrentRequest();
            if (servletRequest == null) {
                log.debug((Object)"HttpServletRequest is null. SPNEGOLoginModule will be ignored.");
                return false;
            }
            HttpSession session = servletRequest.getSession();
            String username = (String)session.getAttribute("SPNEGO_PRINCIPAL");
            if (username != null) {
                this.establishSecurityContext(container, username);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Successfully established security context for user " + username));
                }
                return true;
            }
        }
        catch (Exception ex) {
            log.error((Object)"Exception when trying to login with SPNEGO", (Throwable)ex);
        }
        if ("false".equalsIgnoreCase((String)this.options.get(OPTION_ENABLE_FALLBACK_FORM_AUTHENTICATION))) {
            throw new LoginException("FORM authentication was disabled by SPNEGO login module.");
        }
        return false;
    }

    public boolean commit() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    protected void establishSecurityContext(ExoContainer container, String username) throws Exception {
        Authenticator authenticator = (Authenticator)container.getComponentInstanceOfType(Authenticator.class);
        if (authenticator == null) {
            throw new LoginException("No Authenticator component found, check your configuration");
        }
        Identity identity = authenticator.createIdentity(username);
        this.sharedState.put("exo.security.identity", identity);
        this.sharedState.put("javax.security.auth.login.name", username);
        this.subject.getPublicCredentials().add(new UsernameCredential(username));
    }
}

