/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.login;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.jaas.AbstractLoginModule;
import org.exoplatform.web.security.Credentials;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.web.security.security.TransientTokenService;

public final class SSOLoginModule
extends AbstractLoginModule {
    private static final Log LOG = ExoLogger.getLogger((String)SSOLoginModule.class.getName());

    protected Log getLogger() {
        return LOG;
    }

    public boolean login() throws LoginException {
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Username"), new PasswordCallback("Password", false)};
            this.callbackHandler.handle(callbacks);
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            ExoContainer container = this.getContainer();
            Credentials o = ((TransientTokenService)container.getComponentInstanceOfType(TransientTokenService.class)).validateToken(password, true);
            if (o == null) {
                o = ((CookieTokenService)container.getComponentInstanceOfType(CookieTokenService.class)).validateToken(password, false);
            }
            String username = null;
            if (o instanceof Credentials) {
                Credentials wc = o;
                username = wc.getUsername();
            }
            if (username == null) {
                LOG.error((Object)"---------------------------------------------------------");
                LOG.error((Object)"SSOLogin Failed. Credential Not Found!!");
                LOG.error((Object)"---------------------------------------------------------");
                return false;
            }
            Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
            if (authenticator == null) {
                throw new LoginException("No Authenticator component found, check your configuration");
            }
            Identity identity = authenticator.createIdentity(username);
            this.sharedState.put("exo.security.identity", identity);
            this.sharedState.put("javax.security.auth.login.name", username);
            this.subject.getPublicCredentials().add(new UsernameCredential(username));
            return true;
        }
        catch (Throwable e) {
            throw new LoginException(e.getMessage());
        }
    }

    public boolean logout() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean commit() throws LoginException {
        return true;
    }
}

