/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.exoplatform.web.login.InitiateLoginServlet;
import org.gatein.sso.agent.cas.CASAgent;
import org.gatein.sso.agent.josso.JOSSOAgent;
import org.gatein.sso.agent.opensso.OpenSSOAgent;

public class GenericSSOAgent
extends InitiateLoginServlet {
    private static final long serialVersionUID = 6330639010812906309L;
    private static Logger log = Logger.getLogger(GenericSSOAgent.class);
    private String ssoServerUrl;
    private String ssoCookieName;
    private boolean casRenewTicket;

    public void init() throws ServletException {
        super.init();
        this.ssoServerUrl = this.getServletConfig().getInitParameter("ssoServerUrl");
        this.ssoCookieName = this.getServletConfig().getInitParameter("ssoCookieName");
        String casRenewTicketConfig = this.getServletConfig().getInitParameter("casRenewTicket");
        if (casRenewTicketConfig != null) {
            this.casRenewTicket = Boolean.parseBoolean(casRenewTicketConfig);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.processSSOToken(req, resp);
            String portalContext = req.getContextPath();
            if (req.getAttribute("abort") != null) {
                String ssoRedirect = portalContext + "/sso";
                resp.sendRedirect(ssoRedirect);
                return;
            }
            super.doGet(req, resp);
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void processSSOToken(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        String ticket = httpRequest.getParameter("ticket");
        String jossoAssertion = httpRequest.getParameter("josso_assertion_id");
        if (ticket != null && ticket.trim().length() > 0) {
            CASAgent casagent = CASAgent.getInstance(this.ssoServerUrl);
            casagent.setRenewTicket(this.casRenewTicket);
            casagent.validateTicket(httpRequest, ticket);
        } else if (jossoAssertion != null && jossoAssertion.trim().length() > 0) {
            JOSSOAgent.getInstance().validateTicket(httpRequest, httpResponse);
        } else {
            try {
                OpenSSOAgent.getInstance(this.ssoServerUrl, this.ssoCookieName).validateTicket(httpRequest);
            }
            catch (IllegalStateException ilse) {
                httpRequest.setAttribute("abort", (Object)Boolean.TRUE);
            }
        }
    }
}

