/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.cas;

import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.exoplatform.web.security.Credentials;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;

public class CASAgent {
    private static Logger log = Logger.getLogger(CASAgent.class);
    private static CASAgent singleton;
    private String casServerUrl;
    private boolean renewTicket;

    private CASAgent(String casServerUrl) {
        this.casServerUrl = casServerUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CASAgent getInstance(String casServerUrl) {
        if (singleton != null) return singleton;
        Class<CASAgent> clazz = CASAgent.class;
        synchronized (CASAgent.class) {
            if (singleton != null) return singleton;
            singleton = new CASAgent(casServerUrl);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public boolean isRenewTicket() {
        return this.renewTicket;
    }

    public void setRenewTicket(boolean renewTicket) {
        this.renewTicket = renewTicket;
    }

    public void validateTicket(HttpServletRequest httpRequest, String ticket) throws Exception {
        Cas20ProxyTicketValidator ticketValidator = new Cas20ProxyTicketValidator(this.casServerUrl);
        ticketValidator.setRenew(this.renewTicket);
        String serviceUrl = "http://" + httpRequest.getServerName() + ":" + httpRequest.getServerPort() + httpRequest.getContextPath() + "/private/classic";
        Assertion assertion = ticketValidator.validate(ticket, serviceUrl);
        log.debug((Object)"------------------------------------------------------------------------------------");
        log.debug((Object)("Service: " + serviceUrl));
        log.debug((Object)("Principal: " + assertion.getPrincipal().getName()));
        log.debug((Object)"------------------------------------------------------------------------------------");
        Credentials credentials = new Credentials(assertion.getPrincipal().getName(), "");
        httpRequest.getSession().setAttribute("credentials", (Object)credentials);
    }
}

