/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractLogoutFilter
implements Filter {
    protected String logoutUrl;

    public void init(FilterConfig config) throws ServletException {
        this.logoutUrl = config.getInitParameter("LOGOUT_URL");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isLogoutInProgress = this.isLogoutInProgress(httpRequest);
        if (isLogoutInProgress) {
            if (httpRequest.getSession().getAttribute("SSO_LOGOUT_FLAG") == null) {
                httpRequest.getSession().setAttribute("SSO_LOGOUT_FLAG", (Object)Boolean.TRUE);
                httpResponse.sendRedirect(this.getRedirectUrl(httpRequest));
                return;
            }
            httpRequest.getSession().removeAttribute("SSO_LOGOUT_FLAG");
        }
        chain.doFilter(request, response);
    }

    private boolean isLogoutInProgress(HttpServletRequest request) {
        String action = request.getParameter("portal:action");
        return action != null && action.equals("Logout");
    }

    protected abstract String getRedirectUrl(HttpServletRequest var1);
}

