/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.login;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.jaas.UserPrincipal;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

public class SPNEGORolesModule
extends AbstractServerLoginModule {
    private Identity identity = null;
    private static final String OPTION_PORTAL_CONTAINER_NAME = "portalContainerName";
    private static final String OPTION_REALM_NAME = "realmName";
    private String portalContainerName;
    private String realmName;

    private String getPortalContainerName(Map options) {
        String optionValue;
        if (options != null && (optionValue = (String)options.get(OPTION_PORTAL_CONTAINER_NAME)) != null && optionValue.length() > 0) {
            return optionValue;
        }
        return PortalContainer.DEFAULT_PORTAL_CONTAINER_NAME;
    }

    private String getRealmName(Map options) {
        String optionValue;
        if (options != null && (optionValue = (String)options.get(OPTION_REALM_NAME)) != null && optionValue.length() > 0) {
            return optionValue;
        }
        return PortalContainer.DEFAULT_REALM_NAME;
    }

    private ExoContainer getContainer() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = RootContainer.getInstance().getPortalContainer(this.portalContainerName);
        }
        return container;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.portalContainerName = this.getPortalContainerName(options);
        this.realmName = this.getRealmName(options);
    }

    public boolean login() throws LoginException {
        try {
            if (super.login()) {
                Principal principal = this.getIdentity();
                Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
                this.identity = authenticator.createIdentity(principal.getName());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }

    protected Principal getIdentity() {
        return (Principal)this.sharedState.get("javax.security.auth.login.name");
    }

    protected Group[] getRoleSets() throws LoginException {
        try {
            SimpleGroup roles = new SimpleGroup("Roles");
            for (String role : this.identity.getRoles()) {
                roles.addMember(this.createIdentity(role));
            }
            Group[] groups = new Group[]{roles};
            return groups;
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }

    public boolean commit() throws LoginException {
        try {
            if (super.commit()) {
                IdentityRegistry identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
                if (identityRegistry.getIdentity(this.identity.getUserId()) != null) {
                    return true;
                }
                this.identity.setSubject(this.subject);
                identityRegistry.register(this.identity);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }

    public boolean logout() throws LoginException {
        block10: {
            J2EEServerInfo info = new J2EEServerInfo();
            MBeanServer jbossServer = info.getMBeanServer();
            if (jbossServer != null) {
                try {
                    this.log.debug((Object)"Performing JBoss security manager cache eviction");
                    ObjectName securityManagerName = new ObjectName("jboss.security:service=JaasSecurityManager");
                    HttpServletRequest request = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
                    if (request == null) {
                        return true;
                    }
                    HttpSession session = request.getSession(false);
                    String sessionId = session.getId();
                    if (sessionId != null) {
                        String userName = null;
                        Set<UserPrincipal> userPrincipals = this.subject.getPrincipals(UserPrincipal.class);
                        if (!userPrincipals.isEmpty()) {
                            userName = userPrincipals.iterator().next().getName();
                        }
                        this.log.debug((Object)("Going to perform JBoss security manager cache eviction for user " + userName));
                        ArrayList allPrincipals = (ArrayList)jbossServer.invoke(securityManagerName, "getAuthenticationCachePrincipals", new Object[]{this.realmName}, new String[]{String.class.getName()});
                        allPrincipals = new ArrayList(allPrincipals);
                        Principal key = null;
                        for (Principal principal : allPrincipals) {
                            if (!principal.getName().equals(sessionId)) continue;
                            key = principal;
                            break;
                        }
                        if (key != null) {
                            jbossServer.invoke(securityManagerName, "flushAuthenticationCache", new Object[]{this.realmName, key}, new String[]{String.class.getName(), Principal.class.getName()});
                            this.log.debug((Object)("Performed JBoss security manager cache eviction for user " + sessionId + " with principal " + key));
                        } else {
                            this.log.warn((Object)("No principal found when performing JBoss security manager cache eviction for user " + userName));
                        }
                        break block10;
                    }
                    this.log.warn((Object)"No user name found when performing JBoss security manager cache eviction");
                }
                catch (Exception e) {
                    this.log.debug((Object)"Could not perform JBoss security manager cache eviction", (Throwable)e);
                }
            } else {
                this.log.debug((Object)"Could not find mbean server for performing JBoss security manager cache eviction");
            }
        }
        return true;
    }
}

