/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginRedirectFilter
implements Filter {
    private String loginUrl;

    public void init(FilterConfig config) throws ServletException {
        this.loginUrl = config.getInitParameter("LOGIN_URL");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isLoginInProgress = this.isLoginInProgress(httpRequest);
        if (isLoginInProgress) {
            httpResponse.sendRedirect(this.loginUrl);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isLoginInProgress(HttpServletRequest request) {
        String action = request.getRequestURI();
        return action != null && action.equals("/portal/sso");
    }
}

