/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.login;

import java.lang.reflect.Method;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.jaas.AbstractLoginModule;

public final class SSOLoginModule
extends AbstractLoginModule {
    private static final Log log = ExoLogger.getLogger((String)SSOLoginModule.class.getName());
    private static Method getContextMethod;

    public boolean login() throws LoginException {
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Username"), new PasswordCallback("Password", false)};
            this.callbackHandler.handle(callbacks);
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            String username = null;
            if (getContextMethod != null && password.startsWith("wci-ticket")) {
                try {
                    HttpServletRequest request = (HttpServletRequest)getContextMethod.invoke(null, "javax.servlet.http.HttpServletRequest");
                    username = (String)request.getSession().getAttribute("username");
                }
                catch (Throwable e) {
                    log.error((Object)this, e);
                    log.error((Object)"LoginModule error. Turn off session credentials checking with proper configuration option of LoginModule set to false");
                }
            }
            if (username == null) {
                log.error((Object)"---------------------------------------------------------");
                log.error((Object)"SSOLogin Failed. Credential Not Found!!");
                log.error((Object)"---------------------------------------------------------");
                return false;
            }
            Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
            if (authenticator == null) {
                throw new LoginException("No Authenticator component found, check your configuration");
            }
            Identity identity = authenticator.createIdentity(username);
            this.sharedState.put("exo.security.identity", identity);
            this.sharedState.put("javax.security.auth.login.name", username);
            this.subject.getPublicCredentials().add(new UsernameCredential(username));
            return true;
        }
        catch (Throwable e) {
            throw new LoginException(e.getMessage());
        }
    }

    public boolean logout() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean commit() throws LoginException {
        return true;
    }

    protected Log getLogger() {
        return log;
    }

    static {
        try {
            Class<?> policyContextClass = Thread.currentThread().getContextClassLoader().loadClass("javax.security.jacc.PolicyContext");
            getContextMethod = policyContextClass.getDeclaredMethod("getContext", String.class);
        }
        catch (ClassNotFoundException ignore) {
            log.debug((Object)"JACC not found ignoring it", (Throwable)ignore);
        }
        catch (Exception e) {
            log.error((Object)"Could not obtain JACC get context method", (Throwable)e);
        }
    }
}

