/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.josso;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.GenericAgent;
import org.gatein.sso.agent.josso.GateInJOSSOAgentFactory;
import org.josso.agent.Lookup;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SingleSignOnEntry;
import org.josso.agent.http.HttpSSOAgent;

public class JOSSOAgent
extends GenericAgent {
    private static Logger log = LoggerFactory.getLogger(JOSSOAgent.class);
    private static JOSSOAgent singleton;
    private HttpSSOAgent httpAgent;

    private JOSSOAgent() {
        try {
            Lookup lookup = Lookup.getInstance();
            lookup.init("josso-agent-config.xml");
            this.httpAgent = (HttpSSOAgent)lookup.lookupSSOAgent();
            this.httpAgent.start();
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JOSSOAgent getInstance() {
        if (singleton != null) return singleton;
        Class<JOSSOAgent> clazz = JOSSOAgent.class;
        synchronized (JOSSOAgent.class) {
            if (singleton != null) return singleton;
            singleton = new JOSSOAgent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public void validateTicket(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        String ticket = httpRequest.getParameter("josso_assertion_id");
        log.debug((Object)("Trying to validate the following Ticket: " + ticket));
        String requester = httpRequest.getContextPath().substring(1);
        SSOAgentRequest agentRequest = this.doMakeSSOAgentRequest(requester, 2, null, ticket, httpRequest, httpResponse);
        SingleSignOnEntry entry = this.httpAgent.processRequest(agentRequest);
        if (entry != null) {
            String sessionId = agentRequest.getSessionId();
            String assertionId = agentRequest.getAssertionId();
            String principal = entry.principal.getName();
            log.debug((Object)"-----------------------------------------------------------");
            log.debug((Object)("SessionId: " + sessionId));
            log.debug((Object)("AssertionId: " + assertionId));
            log.debug((Object)("Principal: " + principal));
            log.debug((Object)"-----------------------------------------------------------");
            this.saveSSOCredentials(principal, httpRequest);
        }
    }

    protected SSOAgentRequest doMakeSSOAgentRequest(String requester, int action, String sessionId, String assertionId, HttpServletRequest hreq, HttpServletResponse hres) {
        return GateInJOSSOAgentFactory.getInstance().getSSOAgentRequest(requester, action, sessionId, assertionId, hreq, hres);
    }
}

