/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.opensso;

import java.io.InputStream;
import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import org.gatein.sso.agent.GenericAgent;

public class OpenSSOAgent
extends GenericAgent {
    private static Logger log = Logger.getLogger(OpenSSOAgent.class);
    private static OpenSSOAgent singleton;
    private String cookieName;
    private String serverUrl;

    private OpenSSOAgent(String serverUrl, String cookieName) {
        this.serverUrl = serverUrl;
        this.cookieName = cookieName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpenSSOAgent getInstance(String serverUrl, String cookieName) {
        if (singleton != null) return singleton;
        Class<OpenSSOAgent> clazz = OpenSSOAgent.class;
        synchronized (OpenSSOAgent.class) {
            if (singleton != null) return singleton;
            singleton = new OpenSSOAgent(serverUrl, cookieName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return singleton;
        }
    }

    public void validateTicket(HttpServletRequest httpRequest) throws Exception {
        String token = null;
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(this.cookieName)) continue;
            token = cookie.getValue();
            break;
        }
        if (token == null) {
            throw new IllegalStateException("No SSO Tokens Found");
        }
        if (token != null) {
            boolean isValid = this.isTokenValid(token);
            if (!isValid) {
                throw new IllegalStateException("OpenSSO Token is not valid!!");
            }
            String subject = this.getSubject(token);
            if (subject != null) {
                this.saveSSOCredentials(subject, httpRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTokenValid(String token) throws Exception {
        HttpClient client = new HttpClient();
        PostMethod post = null;
        try {
            String url = this.serverUrl + "/identity/isTokenValid";
            post = new PostMethod(url);
            post.addParameter("tokenid", token);
            int status = client.executeMethod((HttpMethod)post);
            String response = post.getResponseBodyAsString();
            log.debug((Object)"-------------------------------------------------------");
            log.debug((Object)("Status: " + status));
            log.debug((Object)("Response: " + response));
            log.debug((Object)"-------------------------------------------------------");
            if (response.contains(Boolean.TRUE.toString())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSubject(String token) throws Exception {
        HttpClient client = new HttpClient();
        PostMethod post = null;
        try {
            String uid = null;
            String url = this.serverUrl + "/identity/attributes";
            post = new PostMethod(url);
            post.addParameter("subjectid", token);
            post.addParameter("attributes_names", "uid");
            int status = client.executeMethod((HttpMethod)post);
            String response = post.getResponseBodyAsString();
            log.debug((Object)"--------------------------------------------------------");
            log.debug((Object)("Status: " + status));
            log.debug((Object)response);
            log.debug((Object)"--------------------------------------------------------");
            if (response != null) {
                Properties properties = this.loadAttributes(response);
                uid = properties.getProperty("uid");
            }
            String string = uid;
            return string;
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadAttributes(String response) throws Exception {
        InputStream is = null;
        try {
            Properties properties = new Properties();
            String[] tokens = response.split(System.getProperty("line.separator"));
            String name = null;
            for (String token : tokens) {
                if (token.startsWith("userdetails.attribute.name")) {
                    name = token.substring(token.indexOf("=") + 1);
                    continue;
                }
                if (!token.startsWith("userdetails.attribute.value")) continue;
                String value = token.substring(token.indexOf("=") + 1);
                if (name != null) {
                    properties.setProperty(name, value);
                }
                name = null;
            }
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

